/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.core;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class OpenGLDebug
implements IClassTransformer {
    private static final String[] checkExclusions = new String[]{"glBegin", "glEnd", "glVertex", "glColor", "glSecondaryColor", "glIndex", "glNormal", "glFogCoord", "glTexCoord", "glMultiTexCoord", "glVertexAttrib", "glEvalCoord", "glEvalPoint", "glArrayElement", "glMaterial", "glEdgeFlag"};
    private static final List<Integer> foundErrors = new ArrayList<Integer>();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (name != null) {
            return this.writeClass(this.transformClass(this.readClass(basicClass)));
        }
        return basicClass;
    }

    private ClassNode readClass(byte[] classBytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    private byte[] writeClass(ClassNode classNode) {
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    private ClassNode transformClass(ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode insnNode = method.instructions.get(i);
                if (insnNode.getOpcode() != 184) continue;
                MethodInsnNode methodInsn = (MethodInsnNode)insnNode;
                if (this.isExcluded(methodInsn.name) || !methodInsn.owner.startsWith("org/lwjgl/opengl")) continue;
                InsnList checkErrorInsns = new InsnList();
                method.instructions.insert((AbstractInsnNode)methodInsn, (AbstractInsnNode)new MethodInsnNode(184, OpenGLDebug.class.getCanonicalName().replace(".", "/"), "checkThrowError", "()V", false));
                System.out.println(String.format("[OpenGLDebug] Hooked method '%s' at '%s' (%s)", classNode.name + "#" + method.name, methodInsn.name + methodInsn.desc, i));
            }
        }
        return classNode;
    }

    private boolean isExcluded(String method) {
        for (String exclusion : checkExclusions) {
            if (!method.startsWith(exclusion)) continue;
            return true;
        }
        return false;
    }

    public static void checkThrowError() {
        if (OpenGLDebug.checkGlContext()) {
            int glErrorId;
            while ((glErrorId = GL11.glGetError()) != 0) {
                foundErrors.add(glErrorId);
            }
            if (!foundErrors.isEmpty()) {
                StringBuilder errors = new StringBuilder();
                for (int i = 0; i < foundErrors.size(); ++i) {
                    errors.append(GLU.gluErrorString((int)foundErrors.get(i))).append(" (").append(foundErrors.get(i)).append(")");
                    if (i >= foundErrors.size() - 1) continue;
                    errors.append(", ");
                }
                foundErrors.clear();
                new OpenGLError(errors.toString()).printStackTrace();
            }
        }
    }

    public static boolean checkGlContext() {
        try {
            ContextCapabilities capabilities = GLContext.getCapabilities();
            return capabilities != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static class OpenGLError
    extends Error {
        public OpenGLError(String errors) {
            super("An OpenGL Error has occurred: " + errors);
        }
    }
}

