/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.theoneprobe;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.providers.ChestInfoTools;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.api.IListInfoProvider;
import reborncore.api.power.IEnergyInterfaceTile;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.StringUtils;

public class ProbeProvider
implements IProbeInfoProvider {
    ProgressStyle euStyle;
    MethodHandle methodHandle_addStacks;

    public ProbeProvider() {
        this.euStyle = new ProgressStyle().backgroundColor(-7631989).borderColor(-13158601).alternateFilledColor(PowerSystem.getDisplayPower().altColour).filledColor(PowerSystem.getDisplayPower().colour);
        this.euStyle.suffix(" " + PowerSystem.getDisplayPower().abbreviation);
        this.euStyle.numberFormat(NumberFormat.COMMAS);
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Method pm = ChestInfoTools.class.getDeclaredMethod("showChestContents", IProbeInfo.class, World.class, BlockPos.class, List.class, Boolean.TYPE);
            pm.setAccessible(true);
            this.methodHandle_addStacks = lookup.unreflect(pm);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public String getID() {
        return "TechReborn";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        this.euStyle = new ProgressStyle().backgroundColor(-7631989).borderColor(-13158601).alternateFilledColor(PowerSystem.getDisplayPower().altColour).filledColor(PowerSystem.getDisplayPower().colour);
        this.euStyle.suffix(" " + PowerSystem.getDisplayPower().abbreviation);
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile instanceof IListInfoProvider) {
            ArrayList strs = new ArrayList();
            ((IListInfoProvider)tile).addInfo(strs, true);
            for (String string : strs) {
                probeInfo.text(string);
            }
        }
        if (tile instanceof IEnergyInterfaceTile) {
            IEnergyInterfaceTile energy = (IEnergyInterfaceTile)tile;
            if (PowerSystem.getDisplayPower() != PowerSystem.EnergySystem.EU) {
                probeInfo.progress((int)energy.getEnergy() * RebornCoreConfig.euPerFU, (int)energy.getMaxPower() * RebornCoreConfig.euPerFU, (IProgressStyle)this.euStyle);
            } else {
                probeInfo.progress((int)energy.getEnergy(), (int)energy.getMaxPower(), (IProgressStyle)this.euStyle);
            }
        }
        if (tile instanceof TileLegacyMachineBase && this.methodHandle_addStacks != null) {
            TileLegacyMachineBase legacyMachineBase = (TileLegacyMachineBase)tile;
            if (legacyMachineBase.getInventoryForTile().isPresent()) {
                Inventory inventory;
                if (player.func_70093_af()) {
                    probeInfo.text(StringUtils.t((String)"techreborn.tooltip.inventory"));
                }
                if (!(inventory = (Inventory)legacyMachineBase.getInventoryForTile().get()).func_191420_l()) {
                    List stacks = Arrays.stream(inventory.contents).filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
                    try {
                        this.methodHandle_addStacks.invoke(probeInfo, world, null, stacks, player.func_70093_af());
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            if (!legacyMachineBase.upgradeInventory.func_191420_l() && player.func_70093_af()) {
                probeInfo.horizontal();
                probeInfo.text(StringUtils.t((String)"techreborn.tooltip.upgrades"));
                List stacks = Arrays.stream(legacyMachineBase.upgradeInventory.contents).filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
                try {
                    this.methodHandle_addStacks.invoke(probeInfo, world, null, stacks, player.func_70093_af());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }
}

