/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import reborncore.api.praescriptum.ingredients.Ingredient;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.api.praescriptum.recipes.RecipeHandler;

public class CTPraescriptum {
    public static void add(Recipe recipe) {
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    public static void remove(Recipe recipe, RecipeHandler recipeHandler) {
        CraftTweakerAPI.apply((IAction)new Remove(recipe, recipeHandler));
    }

    public static void removeAll(RecipeHandler recipeHandler) {
        CraftTweakerAPI.apply((IAction)new RemoveAll(recipeHandler));
    }

    private static class RemoveAll
    implements IAction {
        private final RecipeHandler recipeHandler;
        private final List<Recipe> removedRecipes = new ArrayList<Recipe>();

        public RemoveAll(RecipeHandler recipeHandler) {
            this.recipeHandler = recipeHandler;
        }

        public void apply() {
            this.recipeHandler.getRecipes().stream().collect(Collectors.toCollection(() -> this.removedRecipes));
            this.recipeHandler.getRecipes().removeAll(this.removedRecipes);
        }

        public String describe() {
            return "Removing all recipes from " + this.recipeHandler;
        }
    }

    private static class Remove
    implements IAction {
        private final Recipe recipe;
        private final RecipeHandler recipeHandler;
        private final List<Recipe> removedRecipes = new ArrayList<Recipe>();

        public Remove(Recipe recipe, RecipeHandler recipeHandler) {
            this.recipe = recipe;
            this.recipeHandler = recipeHandler;
        }

        public void apply() {
            if (this.recipeHandler.removeRecipe(this.recipe)) {
                this.removedRecipes.add(this.recipe);
            }
        }

        public String describe() {
            return "Removing " + this.recipe + " for " + this.recipe.getOutputIngredients().stream().map(Ingredient::toFormattedString).collect(Collectors.joining(", ", "{", "}"));
        }
    }

    private static class Add
    implements IAction {
        private final Recipe recipe;

        public Add(Recipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            this.recipe.register();
        }

        public String describe() {
            return "Adding " + this.recipe + " for " + this.recipe.getOutputIngredients().stream().map(Ingredient::toFormattedString).collect(Collectors.joining(", ", "{", "}"));
        }
    }
}

