/*
 * Decompiled with CFR 0.152.
 */
package levelup2.util;

import com.google.common.base.Charsets;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import levelup2.config.LevelUpConfig;
import levelup2.util.Library;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeHooks;

public class LevelUpLootManager {
    private static final Gson GSON_INSTANCE = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    private final LoadingCache<ResourceLocation, LootTable> registeredLootTables = CacheBuilder.newBuilder().build((CacheLoader)new Loader());
    private final File baseFolder = LevelUpConfig.lootDir.toFile();

    public LevelUpLootManager() {
        this.reloadLootTables();
    }

    public LootTable getLootTableFromLocation(ResourceLocation resources) {
        return (LootTable)this.registeredLootTables.getUnchecked((Object)resources);
    }

    public void reloadLootTables() {
        this.registeredLootTables.invalidateAll();
        for (ResourceLocation location : Library.getLootTables()) {
            this.getLootTableFromLocation(location);
        }
    }

    class Loader
    extends CacheLoader<ResourceLocation, LootTable> {
        private Loader() {
        }

        public LootTable load(ResourceLocation location) throws Exception {
            if (location.func_110623_a().contains(".")) {
                System.out.println("[LEVELUP] ERROR: Cannot load loot table " + location.func_110623_a());
                return LootTable.field_186464_a;
            }
            LootTable table = this.loadLootTable(location);
            if (table == null) {
                System.out.println("[LEVELUP] ERROR: Cannot load loot table " + location.func_110623_a());
                table = LootTable.field_186464_a;
            }
            return table;
        }

        private LootTable loadLootTable(ResourceLocation location) {
            File file = new File(LevelUpLootManager.this.baseFolder, location.func_110623_a() + ".json");
            if (file.exists()) {
                if (file.isFile()) {
                    String s;
                    try {
                        s = Files.toString((File)file, (Charset)Charsets.UTF_8);
                    }
                    catch (IOException e) {
                        System.out.println("[LEVELUP] ERROR: Cannot load loot table " + file.toString());
                        return LootTable.field_186464_a;
                    }
                    return ForgeHooks.loadLootTable((Gson)GSON_INSTANCE, (ResourceLocation)location, (String)s, (boolean)true, null);
                }
                return LootTable.field_186464_a;
            }
            return null;
        }
    }
}

