/*
 * Decompiled with CFR 0.152.
 */
package levelup2.player;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import levelup2.api.ICharacterClass;
import levelup2.api.IPlayerSkill;
import levelup2.api.PlayerSkillStorage;
import levelup2.player.IPlayerClass;
import levelup2.skills.SkillRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class PlayerExtension
implements IPlayerClass {
    private Map<ResourceLocation, Integer> skillMap = new HashMap<ResourceLocation, Integer>();
    private ResourceLocation playerClass;
    private int levels = 0;
    private boolean isActive = true;

    public PlayerExtension() {
        for (ResourceLocation loc : SkillRegistry.getSkills().keySet()) {
            this.skillMap.put(loc, 0);
        }
    }

    @Override
    public NBTTagCompound saveNBTData(NBTTagCompound tag) {
        if (this.playerClass != null) {
            tag.func_74778_a("Class", this.playerClass.toString());
        }
        if (this.levels > 0) {
            tag.func_74768_a("Levels", this.levels);
        }
        HashMap types = Maps.newHashMap();
        for (ResourceLocation skillName : this.skillMap.keySet()) {
            IPlayerSkill skill = this.getSkillFromName(skillName);
            ResourceLocation skillType = skill.getSkillType();
            String type = skillType.func_110623_a();
            if (type.endsWith("_bonus")) {
                type = type.replace("_bonus", "");
            }
            if (!types.containsKey(type)) {
                types.put(type, new NBTTagCompound());
            }
            ((NBTTagCompound)types.get(type)).func_74768_a(skill.getSkillName().toString(), this.skillMap.get(skillName).intValue());
        }
        for (String type : types.keySet()) {
            tag.func_74782_a(type, (NBTBase)types.get(type));
        }
        tag.func_74774_a("Version", (byte)2);
        tag.func_74757_a("Active", this.isActive);
        return tag;
    }

    @Override
    public void loadNBTData(NBTTagCompound tag) {
        if (!tag.func_74764_b("Version")) {
            for (ResourceLocation skill : this.skillMap.keySet()) {
                IPlayerSkill sk = this.getSkillFromName(skill);
                ResourceLocation type = sk.getSkillType();
                String skillName = type.func_110623_a().startsWith("m") ? "Mining" : (type.func_110623_a().startsWith("cr") ? "Crafting" : "Combat");
                NBTTagCompound skillTag = tag.func_74775_l(skillName);
                this.setSkillLevel(skill, skillTag.func_74762_e(sk.getSkillName().toString()));
            }
        } else {
            for (ResourceLocation skill : this.skillMap.keySet()) {
                IPlayerSkill playerSkill = this.getSkillFromName(skill);
                ResourceLocation skillType = playerSkill.getSkillType();
                String skillName = skillType.func_110623_a();
                if (skillName.endsWith("_bonus")) {
                    skillName = skillName.replace("_bonus", "");
                }
                NBTTagCompound skillTag = tag.func_74775_l(skillName);
                this.setSkillLevel(skill, skillTag.func_74762_e(playerSkill.getSkillName().toString()));
            }
        }
        this.playerClass = tag.func_74764_b("Class") ? new ResourceLocation(tag.func_74779_i("Class")) : this.getClassFromSpecialization();
        if (tag.func_74764_b("Levels")) {
            this.levels = tag.func_74762_e("Levels");
        }
        if (tag.func_74764_b("Active")) {
            this.isActive = tag.func_74767_n("Active");
        }
    }

    @Override
    public IPlayerSkill getSkillFromName(ResourceLocation name) {
        return SkillRegistry.getSkillFromName(name);
    }

    @Override
    public void addToSkill(ResourceLocation name, int increase) {
        this.setSkillLevel(name, this.skillMap.get(name) + increase);
    }

    @Override
    public int getSkillLevel(ResourceLocation name, boolean checkActive) {
        if (this.getSkillFromName(name) == null || !this.getSkillFromName(name).isActive() || checkActive && !this.isActive()) {
            return 0;
        }
        return this.skillMap.get(name);
    }

    @Override
    public void setSkillLevel(ResourceLocation name, int level) {
        IPlayerSkill skill = this.getSkillFromName(name);
        if (level > skill.getMaxLevel()) {
            level = skill.getMaxLevel();
        }
        this.skillMap.put(name, level);
    }

    @Override
    public void setPlayerData(ResourceLocation[] names, int[] data) {
        for (int i = 0; i < names.length && i < data.length; ++i) {
            this.setSkillLevel(names[i], data[i]);
        }
    }

    @Override
    public boolean hasClass() {
        return this.playerClass != null;
    }

    @Override
    public ResourceLocation getPlayerClass() {
        return this.playerClass;
    }

    @Override
    public int getLevelBank() {
        return this.levels;
    }

    @Override
    public boolean addLevelFromExperience(EntityPlayer player) {
        if (player.field_71068_ca >= 5) {
            ++this.levels;
            player.func_82242_a(-5);
            return true;
        }
        return false;
    }

    @Override
    public void changeLevelBank(int levels) {
        this.levels = Math.max(0, levels);
    }

    @Override
    public ResourceLocation getSpecialization() {
        if (this.playerClass != null) {
            return Objects.requireNonNull(SkillRegistry.getClassFromName(this.playerClass)).getSpecializationSkill().getSkillName();
        }
        return null;
    }

    private ResourceLocation getClassFromSpecialization() {
        if (this.getSpec() > -1) {
            switch (this.getSpec()) {
                case 1: {
                    return new ResourceLocation("levelup", "artisan");
                }
                case 2: {
                    return new ResourceLocation("levelup", "warrior");
                }
            }
            return new ResourceLocation("levelup", "miner");
        }
        return null;
    }

    private byte getSpec() {
        if (this.getSkillLevel(new ResourceLocation("levelup:mining_bonus"), false) > 0) {
            return 0;
        }
        if (this.getSkillLevel(new ResourceLocation("levelup:craft_bonus"), false) > 0) {
            return 1;
        }
        if (this.getSkillLevel(new ResourceLocation("levelup:combat_bonus"), false) > 0) {
            return 2;
        }
        return -1;
    }

    @Override
    public void resetClass() {
        for (ResourceLocation loc : SkillRegistry.getSkills().keySet()) {
            this.skillMap.put(loc, 0);
        }
        this.playerClass = null;
    }

    @Override
    public Map<ResourceLocation, Integer> getSkills() {
        return this.skillMap;
    }

    @Override
    public void toggleActive() {
        this.isActive = !this.isActive;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setPlayerClass(ResourceLocation location) {
        ICharacterClass oldClass;
        ICharacterClass cl = SkillRegistry.getClassFromName(location);
        if (this.playerClass != null && cl != null && (oldClass = SkillRegistry.getClassFromName(this.playerClass)) != null && !oldClass.getSkillBonuses().isEmpty()) {
            this.skillMap.put(oldClass.getSpecializationSkill().getSkillName(), this.skillMap.get(oldClass.getSpecializationSkill().getSkillName()) - 1);
            for (PlayerSkillStorage sk : oldClass.getSkillBonuses()) {
                int level = this.skillMap.get(sk.getSkill().getSkillName());
                this.skillMap.put(sk.getSkill().getSkillName(), Math.max(0, level - sk.getLevel()));
            }
        }
        if (cl != null) {
            if (this.skillMap.get(cl.getSpecializationSkill().getSkillName()) < 1) {
                this.skillMap.put(cl.getSpecializationSkill().getSkillName(), 1);
            }
            if (!cl.getSkillBonuses().isEmpty()) {
                for (PlayerSkillStorage sk : cl.getSkillBonuses()) {
                    if (this.skillMap.get(sk.getSkill().getSkillName()) >= sk.getLevel()) continue;
                    this.skillMap.put(sk.getSkill().getSkillName(), sk.getLevel());
                }
            }
        }
        this.playerClass = location;
    }
}

