/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener;

import com.pau101.fairylights.server.fastener.accessor.FastenerAccessor;
import com.pau101.fairylights.server.fastener.accessor.FastenerAccessorBlock;
import com.pau101.fairylights.server.fastener.accessor.FastenerAccessorFence;
import com.pau101.fairylights.server.fastener.accessor.FastenerAccessorPlayer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public enum FastenerType {
    BLOCK(FastenerAccessorBlock::new),
    FENCE(FastenerAccessorFence::new),
    PLAYER(FastenerAccessorPlayer::new);

    private static final Map<String, FastenerType> NAME_TO_TYPE;
    private final Supplier<? extends FastenerAccessor> supplier;
    private final String name;

    private FastenerType(Supplier<? extends FastenerAccessor> supplier) {
        this.supplier = supplier;
        this.name = this.name().toLowerCase(Locale.ENGLISH);
    }

    public final FastenerAccessor createAccessor() {
        return this.supplier.get();
    }

    public static NBTTagCompound serialize(FastenerAccessor accessor) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("type", accessor.getType().name);
        compound.func_74782_a("data", (NBTBase)accessor.serialize());
        return compound;
    }

    public static FastenerAccessor deserialize(NBTTagCompound compound) {
        FastenerAccessor accessor = NAME_TO_TYPE.get(compound.func_74779_i("type")).createAccessor();
        accessor.deserialize(compound.func_74775_l("data"));
        return accessor;
    }

    static {
        NAME_TO_TYPE = new HashMap<String, FastenerType>();
        for (FastenerType type : FastenerType.values()) {
            NAME_TO_TYPE.put(type.name, type);
        }
    }
}

