/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.model.connection;

import com.pau101.fairylights.client.model.AdvancedModelRenderer;
import com.pau101.fairylights.client.model.connection.ModelConnection;
import com.pau101.fairylights.server.fastener.connection.type.garland.ConnectionGarlandTinsel;
import com.pau101.fairylights.util.RandomArray;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public final class ModelConnectionTinsel
extends ModelConnection<ConnectionGarlandTinsel> {
    private static final RandomArray RAND = new RandomArray(9171L, 32);
    private AdvancedModelRenderer cordModel = new AdvancedModelRenderer(this, 62, 0);
    private AdvancedModelRenderer stripModel;
    private int uniquifier;

    public ModelConnectionTinsel() {
        this.cordModel.addBox(-0.5f, -0.5f, 0.0f, 1, 1, 1);
        this.stripModel = new AdvancedModelRenderer(this, 62, 0);
        this.stripModel.addBox(-0.5f, 0.0f, -0.5f, 1, 3, 1);
        this.stripModel.scaleZ = 0.5f;
    }

    @Override
    public void renderCord(ConnectionGarlandTinsel connection, World world, int sunlight, int moonlight, float delta) {
        this.uniquifier = connection.hashCode();
        super.renderCord(connection, world, sunlight, moonlight, delta);
    }

    @Override
    protected void renderSegment(ConnectionGarlandTinsel tinsel, int index, double angleX, double angleY, double length, double x, double y, double z, float delta) {
        int color = tinsel.getColor();
        float colorRed = (float)(color >> 16 & 0xFF) / 255.0f;
        float colorGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        float colorBlue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179124_c((float)colorRed, (float)colorGreen, (float)colorBlue);
        this.cordModel.field_78795_f = (float)angleX;
        this.cordModel.field_78796_g = (float)angleY;
        this.cordModel.scaleZ = (float)length;
        this.cordModel.setRotationPoint(x, y, z);
        this.cordModel.func_78785_a(0.0625f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x / 16.0), (double)(y / 16.0), (double)(z / 16.0));
        GlStateManager.func_179114_b((float)((float)angleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)angleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
        int rings = MathHelper.func_76143_f((double)(length * 4.0));
        for (int i = 0; i < rings; ++i) {
            double t = (double)((float)i / (float)rings) * length / 16.0;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)t);
            float rotX = RAND.get(index + i + this.uniquifier) * 22.0f;
            float rotY = RAND.get(index * 3 + i + this.uniquifier) * 180.0f;
            float rotZ = RAND.get(index * 7 + i + this.uniquifier) * 180.0f;
            GlStateManager.func_179114_b((float)rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)rotY, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)rotX, (float)1.0f, (float)0.0f, (float)0.0f);
            this.stripModel.func_78785_a(0.0625f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

