/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.emt.item.tool;

import com.rumaruka.emt.client.creativetabs.EMTCreativeTabs;
import com.rumaruka.emt.util.EMTConfigHandler;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemDiamondChainsaw
extends ItemAxe
implements IElectricItem {
    public int maxCharge = 50000;
    public int cost = 200;
    public int hitCost = 300;
    public int tier = 2;

    public ItemDiamondChainsaw() {
        super(Item.ToolMaterial.DIAMOND);
        this.field_77864_a = 16.0f;
        this.func_77656_e(27);
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == EMTCreativeTabs.EMT_CREATIVEtabs) {
            ItemStack itemStack = new ItemStack((Item)this, 1);
            if (this.getChargedItem(itemStack) == this) {
                ItemStack charged = new ItemStack((Item)this, 1);
                ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
                items.add((Object)charged);
            }
            if (this.getEmptyItem(itemStack) == this) {
                items.add((Object)new ItemStack((Item)this, 1, this.func_77612_l()));
            }
        }
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        ElectricItem.manager.use(stack, (double)this.cost, entityLiving);
        return true;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return Items.field_151056_x.canHarvestBlock(state, stack) || Items.field_151048_u.canHarvestBlock(state, stack) || Items.field_151097_aZ.canHarvestBlock(state, stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (!ElectricItem.manager.canUse(stack, (double)this.cost)) {
            return 0.0f;
        }
        if (Items.field_151053_p.func_150893_a(stack, state) > 1.0f || Items.field_151041_m.func_150893_a(stack, state) > 1.0f || Items.field_151041_m.func_150893_a(stack, state) > 1.0f) {
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (ElectricItem.manager.use(stack, (double)this.hitCost, attacker)) {
            attacker.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 12.0f);
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            Item item;
            ItemStack torchItem = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (torchItem == ItemStack.field_190927_a || !Objects.requireNonNull(torchItem.func_77973_b().getRegistryName()).func_110623_a().contains("torch") || !((item = torchItem.func_77973_b()) instanceof ItemBook)) continue;
            int oldMeta = torchItem.func_77952_i();
            if (player.field_71075_bZ.field_75098_d) {
                torchItem.func_77964_b(oldMeta);
            } else if (torchItem.func_190916_E() <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)torchItem, (EnumHand)EnumHand.MAIN_HAND);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!IC2.platform.isSimulating()) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        if (IC2.keyboard.isModeSwitchKeyDown(playerIn)) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
            if (!nbt.func_74764_b("shearsMode")) {
                nbt.func_74757_a("shearsMode", true);
            }
            if (!nbt.func_74767_n("shearsMode")) {
                nbt.func_74757_a("shearsMode", true);
                IC2.platform.messagePlayer(playerIn, "ic2.tooltip.mode", new Object[]{"ic2.tooltip.mode.normal"});
            } else {
                nbt.func_74757_a("shearsMode", false);
                IC2.platform.messagePlayer(playerIn, "ic2.tooltip.mode", new Object[]{"ic2.tooltip.mode.noShear"});
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        IShearable target;
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
        if (!nbt.func_74764_b("shearsMode")) {
            nbt.func_74757_a("shearsMode", true);
        }
        if (!nbt.func_74767_n("shearsMode") || player.field_70170_p.field_72995_K) {
            return false;
        }
        IBlockState b = player.field_70170_p.func_180495_p(pos);
        if (b instanceof IShearable && (target = (IShearable)b).isShearable(itemstack, (IBlockAccess)player.field_70170_p, pos)) {
            ArrayList drops = (ArrayList)target.onSheared(itemstack, (IBlockAccess)player.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemstack));
            Random r = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double xOffset = (double)(r.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double yOffset = (double)(r.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double zOffset = (double)(r.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)pos.func_177958_n() + xOffset, (double)pos.func_177956_o() + yOffset, (double)pos.func_177952_p() + zOffset, stack);
                entityitem.func_174867_a(10);
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            player.func_71064_a((StatBase)StatList.field_188096_e.get(Block.func_149682_b((Block)((Block)b))), 1);
        }
        return false;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (!nbt.func_74764_b("shearsMode")) {
            nbt.func_74757_a("shearsMode", true);
        }
        if (!nbt.func_74767_n("shearsMode") || target.field_70170_p.field_72995_K) {
            return false;
        }
        if (target instanceof IShearable) {
            IShearable t = (IShearable)target;
            if (t.isShearable(stack, (IBlockAccess)target.field_70170_p, new BlockPos((int)target.field_70165_t, (int)target.field_70163_u, (int)target.field_70161_v))) {
                ArrayList drops = (ArrayList)t.onSheared(stack, (IBlockAccess)target.field_70170_p, new BlockPos((int)target.field_70165_t, (int)target.field_70163_u, (int)target.field_70161_v), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
                Random rand = new Random();
                for (ItemStack s : drops) {
                    EntityItem ent = target.func_70099_a(s, 1.0f);
                    ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
            }
            return true;
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound nbt;
        if (entityIn instanceof EntityLivingBase && !(nbt = StackUtil.getOrCreateNbtData((ItemStack)stack)).func_74764_b("shearsMode")) {
            nbt.func_74757_a("shearsMode", true);
        }
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        if (!EMTConfigHandler.enchanting) {
            return 0;
        }
        return 4;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EMTConfigHandler.enchanting;
    }

    private Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    private Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public boolean canProvideEnergy(ItemStack paramItemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack paramItemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack paramItemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack paramItemStack) {
        return 300.0;
    }
}

