/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.emt.item.armor;

import com.rumaruka.emt.item.armor.ItemNanoGoggles;
import com.rumaruka.emt.util.EMTConfigHandler;
import ic2.api.item.ElectricItem;
import java.util.HashMap;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ItemQuantumGoggles
extends ItemNanoGoggles {
    private static final HashMap<Integer, Integer> potionCost = new HashMap();

    public ItemQuantumGoggles(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.maxCharge = 1.0E7;
        this.tier = 4;
        this.visDiscount = 8;
        this.transferLimit = 12000.0;
        this.energyPerDamage = 20000;
        potionCost.put(Potion.func_188409_a((Potion)MobEffects.field_76436_u), 1000);
        potionCost.put(Potion.func_188409_a((Potion)MobEffects.field_82731_v), 15000);
        potionCost.put(Potion.func_188409_a((Potion)MobEffects.field_76431_k), 5000);
    }

    @Override
    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "emt:textures/models/armor/thaumicquantumhelmet.png";
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 1.0;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return 4;
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        int ref = player.func_70086_ai();
        if (ElectricItem.manager.canUse(itemStack, 1000.0) && ref < 100) {
            player.func_70050_g(ref + 200);
            ElectricItem.manager.use(itemStack, 1000.0, null);
        }
        for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
            Potion potionID = effect.func_188419_a();
            Integer cost = potionCost.get(potionID);
            if (cost == null) continue;
            ElectricItem.manager.use(itemStack, (double)cost.intValue(), null);
            ItemStack milk = new ItemStack(Items.field_151117_aB);
            player.curePotionEffects(milk);
        }
        if (!EMTConfigHandler.nightVisionOff) {
            if (ElectricItem.manager.canUse(itemStack, 1000.0)) {
                int x = MathHelper.func_76128_c((double)player.field_70165_t);
                int z = MathHelper.func_76128_c((double)player.field_70161_v);
                int y = MathHelper.func_76128_c((double)player.field_70163_u);
                int lightlevel = player.field_70170_p.func_175699_k(new BlockPos(x, y, z));
                if (lightlevel >= 0) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300, -3));
                }
                ElectricItem.manager.use(itemStack, 1000.0, (EntityLivingBase)player);
            } else {
                player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 300, 0, true, true));
            }
        }
    }
}

