/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.emt.item.armor;

import com.rumaruka.emt.client.creativetabs.EMTCreativeTabs;
import com.rumaruka.emt.item.armor.ItemThaumiumReinforcedWing;
import com.rumaruka.emt.util.EMTConfigHandler;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemNanoWing
extends ItemThaumiumReinforcedWing
implements IElectricItem,
ISpecialArmor,
IMetalArmor {
    public static int maxCharge = 1000000;
    public int tier = 3;
    public double transferLimit = 1600.0;
    public int energyPerDamage = 5000;
    public int cost;

    public ItemNanoWing(ItemArmor.ArmorMaterial material, int par3, EntityEquipmentSlot par4) {
        super(material, par3, par4);
        this.func_77625_d(1);
        this.func_77656_e(27);
        this.visDiscount = 5;
    }

    @Override
    public float getFallDamageMult() {
        return 0.2f;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == EMTCreativeTabs.EMT_CREATIVEtabs) {
            ItemStack itemStack = new ItemStack((Item)this, 1);
            if (this.getChargedItem(itemStack) == this) {
                ItemStack charged = new ItemStack((Item)this, 1);
                ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
                items.add((Object)charged);
            }
            if (this.getEmptyItem(itemStack) == this) {
                items.add((Object)new ItemStack((Item)this, 1, this.func_77612_l()));
            }
        }
    }

    public boolean drainEnergy(ItemStack wing, int amount) {
        return ElectricItem.manager.discharge(wing, (double)(amount + 6), Integer.MAX_VALUE, true, false, false) > 0.0;
    }

    @Override
    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "emt:textures/models/armor/nanowing.png";
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        this.useWings(player, stack, world, 0.25f, 0.6f, 0.3f, 5);
    }

    private Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    private Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean isMetalArmor(ItemStack itemStack, EntityPlayer entityPlayer) {
        return true;
    }

    public int func_77619_b() {
        if (!EMTConfigHandler.enchanting) {
            return 0;
        }
        return 4;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return EMTConfigHandler.enchanting;
    }

    public int getEnergyPerDamage() {
        return this.energyPerDamage;
    }

    private double getBaseAbsorptionRatio() {
        return 0.25;
    }

    public double getDamageAbsorptionRatio() {
        return 0.9;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 3);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        double damageLimit = energyPerDamage <= 0 ? 0.0 : 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage;
        return new ISpecialArmor.ArmorProperties(3, absorptionRatio, (int)damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage()) {
            return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
    }
}

