/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.emt.item.armor;

import com.rumaruka.emt.client.model.ModelSpecialArmor;
import com.rumaruka.emt.init.EMTItems;
import com.rumaruka.emt.util.EMTConfigHandler;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.item.armor.ItemArmorElectric;
import ic2.core.item.armor.jetpack.IJetpack;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemInfusedQuantumChestplate
extends ItemArmorElectric
implements IJetpack {
    private static ArrayList<Integer> potionRemovecost = new ArrayList();
    private static AudioSource audioSource;
    private static boolean onJetpackActive;
    private final String armorName;

    public ItemInfusedQuantumChestplate(String armorName, double maxCharge, double transferLimit, int tier) {
        super(null, null, EntityEquipmentSlot.CHEST, maxCharge, transferLimit, tier);
        this.armorName = armorName;
        this.func_77656_e(27);
    }

    protected boolean hasOverlayTexture() {
        return true;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (stack.func_77973_b() == EMTItems.quantumarmor_nano) {
            return "emt:textures/models/armor/quantumarmor_nano.png";
        }
        if (stack.func_77973_b() == EMTItems.quantumarmor_jetpack) {
            return "emt:textures/models/armor/quantumarmor_jetpack.png";
        }
        if (stack.func_77973_b() == EMTItems.quantumarmor_quantum) {
            return "emt:textures/models/armor/quantumarmor_quantum.png";
        }
        if (stack.func_77973_b() == EMTItems.quantumarmor_thaumium) {
            return "emt:textures/models/armor/quantumarmor_thaumium.png";
        }
        return "emt:textures/models/armor/quantumarmor.png";
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        EntityLivingBase entity;
        ItemStack armor;
        if (IC2.platform.isSimulating() && event.getEntity() instanceof EntityLivingBase && (armor = (entity = (EntityLivingBase)event.getEntity()).func_184607_cu()).func_190926_b() && armor.func_77973_b() == this) {
            int fallDamage = Math.max((int)event.getDistance() - 10, 0);
            double energyCost = this.getEnergyPerDamage() * fallDamage;
            if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false, false);
                event.setCanceled(true);
            }
        }
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack stack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        try {
            if (entity instanceof EntityPlayer) {
                if (stack.func_77973_b() == EMTItems.quantumarmor_jetpack) {
                    ModelSpecialArmor mbm = new ModelSpecialArmor(1.0f, 1);
                    return mbm;
                }
                if (stack.func_77973_b() == EMTItems.quantumarmor_nano || stack.func_77973_b() == EMTItems.quantumarmor_thaumium || stack.func_77973_b() == EMTItems.quantumarmor_quantum) {
                    ModelSpecialArmor mbm = new ModelSpecialArmor(1.0f, 2);
                    mbm.isJumping = stack.func_77978_p().func_74767_n("isJumping");
                    return mbm;
                }
            }
        }
        catch (NullPointerException e) {
            new ModelSpecialArmor(1.0f, 0);
        }
        return new ModelSpecialArmor(1.0f, 0);
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name")).trim();
    }

    public double getDamageAbsorptionRatio() {
        return 1.1;
    }

    public int getEnergyPerDamage() {
        return 20000;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        int toggleTimer = nbt.func_74771_c("toggleTimer");
        boolean ret = false;
        boolean hoverMode = nbt.func_74767_n("hoverMode");
        boolean jetpackUsed = false;
        if (!world.field_72995_K) {
            Item currentItem;
            for (PotionEffect effect : player.func_70651_bq()) {
                if (!potionRemovecost.contains(effect.func_188419_a())) continue;
                IC2.platform.removePotion((EntityLivingBase)player, effect.func_188419_a());
            }
            ItemStack currentStack = player.field_71071_by.func_70448_g();
            Item item = currentItem = currentStack == ItemStack.field_190927_a ? null : currentStack.func_77973_b();
            if (currentStack.func_77973_b() == EMTItems.quantumarmor) {
                return;
            }
            if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
                toggleTimer = 30;
                boolean bl = hoverMode = !hoverMode;
                if (IC2.platform.isSimulating()) {
                    nbt.func_74757_a("hoverMode", hoverMode);
                    if (hoverMode) {
                        IC2.platform.messagePlayer(player, "Hover Mode enabled.", new Object[0]);
                    } else {
                        IC2.platform.messagePlayer(player, "Hover Mode disabled.", new Object[0]);
                    }
                }
            }
            if (currentStack != ItemStack.field_190927_a && player.func_70093_af() && toggleTimer == 0 && currentStack.func_77973_b() == EMTItems.quantumarmor) {
                if (currentItem == Item.func_111206_d((String)"ic2:jetpack_electric")) {
                    IC2.platform.messagePlayer(player, "Jetpack enabled.", new Object[0]);
                    nbt.func_74768_a("jetpackCharge", (int)ElectricItem.manager.getCharge(currentStack));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(EMTItems.quantumarmor_jetpack));
                } else if (currentItem == EMTItems.thaumiumwing) {
                    IC2.platform.messagePlayer(player, "Thaumium wings enabled.", new Object[0]);
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(EMTItems.quantumarmor_thaumium));
                } else if (currentItem == EMTItems.nanowing) {
                    IC2.platform.messagePlayer(player, "Nano wings enabled.", new Object[0]);
                    nbt.func_74768_a("NWCharge", (int)ElectricItem.manager.getCharge(player.field_71071_by.func_70448_g()));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(EMTItems.quantumarmor_nano));
                } else if (currentItem == EMTItems.quantumwing) {
                    IC2.platform.messagePlayer(player, "Quantum wings enabled.", new Object[0]);
                    nbt.func_74768_a("QWCharge", (int)ElectricItem.manager.getCharge(player.field_71071_by.func_70448_g()));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(EMTItems.quantumarmor_quantum));
                }
                if (currentStack.func_190926_b() && nbt.func_74767_n("unequip") && player.func_70093_af()) {
                    ItemStack charged;
                    toggleTimer = 30;
                    if (currentItem == EMTItems.quantumarmor_jetpack) {
                        IC2.platform.messagePlayer(player, "Jetpack disabled.", new Object[0]);
                        charged = new ItemStack(Item.func_111206_d((String)"ic2:jetpack_electric"));
                        if (nbt.func_74762_e("jetpackCharge") > 0) {
                            ElectricItem.manager.charge(charged, (double)nbt.func_74762_e("jetpackCharge"), 1, true, false);
                        } else {
                            ElectricItem.manager.charge(charged, 0.0, 1, true, false);
                        }
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, charged);
                    }
                    if (currentItem == EMTItems.quantumarmor_thaumium) {
                        IC2.platform.messagePlayer(player, "Thaumium wings disabled.", new Object[0]);
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(EMTItems.thaumiumwing));
                    }
                    if (currentItem == EMTItems.quantumarmor_nano) {
                        IC2.platform.messagePlayer(player, "Nano wings disabled.", new Object[0]);
                        charged = new ItemStack(EMTItems.nanowing);
                        if (nbt.func_74762_e("NWCharge") > 0) {
                            ElectricItem.manager.charge(charged, (double)nbt.func_74762_e("NWCharge"), 3, true, false);
                        } else {
                            ElectricItem.manager.charge(charged, 0.0, 3, true, false);
                        }
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, charged);
                    }
                    if (currentItem == EMTItems.quantumarmor_thaumium) {
                        IC2.platform.messagePlayer(player, "Quantum wings disabled.", new Object[0]);
                        charged = new ItemStack(EMTItems.quantumwing);
                        if (nbt.func_74762_e("QWCharge") > 0) {
                            ElectricItem.manager.charge(charged, (double)nbt.func_74762_e("QWCharge"), 3, true, false);
                        } else {
                            ElectricItem.manager.charge(charged, 0.0, 3, true, false);
                        }
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, charged);
                    }
                }
                nbt.func_74757_a("unequip", false);
            }
            if (IC2.keyboard.isJumpKeyDown(player) && currentItem == EMTItems.quantumarmor_jetpack || hoverMode && player.field_70181_x < (double)-0.03f) {
                jetpackUsed = this.useJetpack(player, hoverMode, itemStack);
            }
            if (currentItem == EMTItems.quantumarmor_thaumium) {
                this.useWings(player, itemStack, world, 0.15f, 0.7f, 0.5f, 0, false);
            }
            if (currentItem == EMTItems.quantumarmor_nano) {
                this.useWings(player, itemStack, world, 0.25f, 0.6f, 0.3f, 5, true);
            }
            if (currentItem == EMTItems.quantumarmor_quantum) {
                this.useWings(player, itemStack, world, 0.33f, 0.5f, 0.2f, 7, true);
            }
            if (IC2.platform.isSimulating() && toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
                nbt.func_74774_a("toggleTimer", (byte)toggleTimer);
            }
            if (IC2.platform.isRendering() && player == IC2.platform.getPlayerInstance()) {
                if (onJetpackActive != jetpackUsed) {
                    if (jetpackUsed) {
                        if (audioSource == null) {
                            audioSource = IC2.audioManager.createSource((Object)player, PositionSpec.Backpack, "Tools/Jetpack/JetpackLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                        }
                        if (audioSource != null) {
                            audioSource.play();
                        }
                    } else if (audioSource != null) {
                        audioSource.remove();
                        audioSource = null;
                    }
                    onJetpackActive = jetpackUsed;
                }
                if (audioSource != null) {
                    audioSource.updatePosition();
                }
            }
            ret = jetpackUsed;
            player.func_70066_B();
            if (ret) {
                player.field_71069_bz.func_75142_b();
            }
        }
    }

    public int func_77619_b() {
        if (!EMTConfigHandler.enchanting) {
            return 0;
        }
        return 4;
    }

    public int getTier(ItemStack stack) {
        return 4;
    }

    public boolean useJetpack(EntityPlayer player, boolean hoverMode, ItemStack stack) {
        int worldHeight;
        double y;
        int jetpackMaxCharge = 30000;
        float power = 1.0f;
        float dropPercantage = 0.5f;
        if (ElectricItem.manager.getCharge(stack) <= 0.0) {
            return false;
        }
        if ((float)ElectricItem.manager.getCharge(stack) / (float)jetpackMaxCharge <= dropPercantage) {
            power = (float)((double)power * (ElectricItem.manager.getCharge(stack) / (double)jetpackMaxCharge) * (double)dropPercantage);
        }
        if (IC2.keyboard.isForwardKeyDown(player)) {
            float forwardpower;
            float retruster = 3.5f;
            if (hoverMode) {
                retruster = 0.5f;
            }
            if ((forwardpower = power * retruster * 2.0f) > 0.0f) {
                if (player.field_70181_x > 0.0) {
                    player.field_70181_x = Math.max(player.field_70181_x - 0.15, 0.0);
                } else if (player.field_70181_x < 0.0 && !player.field_70122_E) {
                    player.field_70181_x = Math.min(player.field_70181_x + 0.15, 0.0);
                }
            }
        }
        if ((y = player.field_70163_u) > (double)((worldHeight = IC2.getWorldHeight((World)player.field_70170_p)) - 25)) {
            if (y > (double)worldHeight) {
                y = worldHeight;
            }
            power = (float)((double)power * (((double)worldHeight - y) / 25.0));
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = -0.025f;
            if (IC2.keyboard.isSneakKeyDown(player)) {
                maxHoverY = -0.1f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        double consume = 8.0;
        if (hoverMode) {
            consume = 10.0;
        }
        ElectricItem.manager.use(stack, consume, (EntityLivingBase)player);
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    private void useWings(EntityPlayer player, ItemStack stack, World world, float motionY, float motionXZ, float f1, int amount, boolean isElectric) {
        int playerZ;
        int playerY;
        int playerX;
        byte f;
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        boolean isJumping = IC2.keyboard.isJumpKeyDown(player);
        nbt.func_74757_a("isJumping", isJumping);
        if (isJumping) {
            f = nbt.func_74771_c("f");
            nbt.func_74757_a("isHolding", true);
            nbt.func_74774_a("f", (byte)(f + 1));
            if (f > 7) {
                nbt.func_74774_a("f", (byte)7);
            }
        } else if (nbt.func_74767_n("isHolding")) {
            f = nbt.func_74771_c("f");
            nbt.func_74757_a("isHolding", false);
            player.field_70181_x = motionY * (float)f;
            if (isElectric) {
                ElectricItem.manager.use(stack, (double)(motionY * (float)f * 10.0f * (float)amount), (EntityLivingBase)player);
            }
            if (player.field_70159_w < 0.5 && player.field_70179_y < 0.5 && player.field_70159_w > -0.5 && player.field_70179_y > -0.5) {
                player.field_70159_w /= (double)motionXZ;
                player.field_70179_y /= (double)motionXZ;
            }
            world.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187557_bK, SoundCategory.MASTER, 1.0f, 1.0f, true);
            for (int i = 0; i < 4; ++i) {
                world.func_175688_a(EnumParticleTypes.CLOUD, player.field_70165_t - 1.0 + (double)world.field_73012_v.nextInt(100) / 50.0, player.field_70163_u - 1.0, player.field_70161_v - 1.0 + (double)world.field_73012_v.nextInt(100) / 50.0, 0.0, -0.5, 0.0, new int[0]);
            }
            nbt.func_74774_a("f", (byte)0);
        }
        if (isJumping && !player.field_70122_E && player.field_70181_x < 0.0) {
            player.field_70181_x *= (double)f1;
        }
        if (player.func_70090_H() && !player.field_71075_bZ.field_75098_d) {
            player.field_70181_x += -0.05;
        }
        if (EMTConfigHandler.impactOfRain && world.func_175710_j(new BlockPos(playerX = MathHelper.func_76128_c((double)player.field_70165_t), playerY = MathHelper.func_76128_c((double)player.field_70163_u), playerZ = MathHelper.func_76128_c((double)player.field_70161_v))) && world.func_72896_J() && !player.field_71075_bZ.field_75098_d) {
            player.field_70181_x += -0.05;
        }
        if (player.func_70093_af() && !player.field_70122_E && player.field_70181_x < 0.0) {
            player.field_70181_x *= 0.6;
        }
        if (player.field_70143_R > 0.0f) {
            player.field_70143_R = 0.0f;
        }
    }

    public boolean drainEnergy(ItemStack itemStack, int i) {
        return ElectricItem.manager.discharge(itemStack, (double)(i + 6), Integer.MAX_VALUE, true, false, false) > 0.0;
    }

    public float getPower(ItemStack itemStack) {
        return 1000.1f;
    }

    public float getDropPercentage(ItemStack itemStack) {
        return 0.0f;
    }

    public double getChargeLevel(ItemStack itemStack) {
        return ElectricItem.manager.getCharge(itemStack) / this.getMaxCharge(itemStack);
    }

    public boolean isJetpackActive(ItemStack itemStack) {
        return itemStack.func_77973_b() == EMTItems.quantumarmor_jetpack;
    }

    public float getHoverMultiplier(ItemStack itemStack, boolean b) {
        return 0.0f;
    }

    public float getWorldHeightDivisor(ItemStack itemStack) {
        return 0.0f;
    }

    static {
        onJetpackActive = false;
    }
}

