/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.emt.item.armor;

import com.rumaruka.emt.client.creativetabs.EMTCreativeTabs;
import com.rumaruka.emt.util.EMTConfigHandler;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ISpecialArmor;
import thaumcraft.api.items.IGoggles;
import thaumcraft.api.items.IRevealer;
import thaumcraft.api.items.IVisDiscountGear;

public class ItemElectricGoggles
extends ItemArmor
implements IElectricItem,
IVisDiscountGear,
IGoggles,
IRevealer,
IMetalArmor,
ISpecialArmor {
    public double maxCharge = 100000.0;
    public double transferLimit = 100.0;
    public int tier = 2;
    public int energyPerDamage = 1000;
    public int visDiscount = 5;

    public ItemElectricGoggles(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "emt:textures/models/armor/electricgoggles.png";
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == EMTCreativeTabs.EMT_CREATIVEtabs) {
            ItemStack itemStack = new ItemStack((Item)this, 1);
            if (this.getChargedItem(itemStack) == this) {
                ItemStack charged = new ItemStack((Item)this, 1);
                ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
                items.add((Object)charged);
            }
            if (this.getEmptyItem(itemStack) == this) {
                items.add((Object)new ItemStack((Item)this, 1, this.func_77612_l()));
            }
        }
    }

    public int func_77619_b() {
        if (!EMTConfigHandler.enchanting) {
            return 0;
        }
        return 4;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return EMTConfigHandler.enchanting;
    }

    public boolean isRepairable() {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean isMetalArmor(ItemStack itemStack, EntityPlayer entityPlayer) {
        return true;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        double damageLimit = energyPerDamage <= 0 ? 0.0 : 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage;
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, (int)damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage()) {
            return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
        }
        return 0;
    }

    public double getDamageAbsorptionRatio() {
        return 0.5;
    }

    private int getEnergyPerDamage() {
        return this.energyPerDamage;
    }

    private double getBaseAbsorptionRatio() {
        return 0.15;
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(damage * this.getEnergyPerDamage()), Integer.MAX_VALUE, true, false, false);
    }

    public boolean showIngamePopups(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return true;
    }

    public boolean showNodes(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return true;
    }

    public int getVisDiscount(ItemStack itemStack, EntityPlayer entityPlayer) {
        return this.visDiscount;
    }
}

