/*
 * Decompiled with CFR 0.152.
 */
package com.rumaruka.emt.item.armor;

import com.rumaruka.emt.client.creativetabs.EMTCreativeTabs;
import com.rumaruka.emt.util.EMTConfigHandler;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.IVisDiscountGear;
import thaumcraft.api.items.RechargeHelper;
import thaumcraft.common.lib.events.PlayerEvents;

public class ItemElectricBootsTraveller
extends ItemArmor
implements IElectricItem,
IVisDiscountGear,
IMetalArmor,
ISpecialArmor,
IRechargable {
    public int maxCharge = 100000;
    public int energyPerDamage = 1000;
    public int visDiscount = 2;
    public float jumpBonus = 0.3f;
    public double transferLimit = 100.0;

    public ItemElectricBootsTraveller(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.func_77656_e(27);
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == EMTCreativeTabs.EMT_CREATIVEtabs) {
            ItemStack itemStack = new ItemStack((Item)this, 1);
            if (this.getChargedItem(itemStack) == this) {
                ItemStack charged = new ItemStack((Item)this, 1);
                ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
                items.add((Object)charged);
            }
            if (this.getEmptyItem(itemStack) == this) {
                items.add((Object)new ItemStack((Item)this, 1, this.func_77612_l()));
            }
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        double damageLimit = energyPerDamage <= 0 ? 0.0 : 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage;
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, (int)damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage()) {
            return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(damage * this.getEnergyPerDamage()), Integer.MAX_VALUE, true, false, false);
    }

    public double getDamageAbsorptionRatio() {
        return 0.5;
    }

    private double getBaseAbsorptionRatio() {
        return 0.15;
    }

    public int getVisDiscount(ItemStack itemStack, EntityPlayer entityPlayer) {
        return this.visDiscount;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        boolean hasCharge;
        boolean bl = hasCharge = RechargeHelper.getCharge((ItemStack)itemStack) > 0;
        if (player.field_70170_p.field_72995_K && player.field_70173_aa % 20 == 0) {
            int e = 0;
            if (itemStack.func_77942_o()) {
                e = itemStack.func_77978_p().func_74762_e("energy");
            }
            if (e > 0) {
                --e;
            } else if (RechargeHelper.consumeCharge((ItemStack)itemStack, (EntityLivingBase)player, (int)1)) {
                e = 60;
            }
            itemStack.func_77983_a("energy", (NBTBase)new NBTTagInt(e));
        }
        if (hasCharge && !player.field_71075_bZ.field_75100_b && player.field_191988_bg > 0.0f && ElectricItem.manager.use(itemStack, 50.0, (EntityLivingBase)player)) {
            if (player.field_70170_p.field_72995_K && !player.func_70093_af()) {
                if (!PlayerEvents.prevStep.containsKey(player.func_145782_y())) {
                    PlayerEvents.prevStep.put(player.func_145782_y(), Float.valueOf(player.field_70138_W));
                }
                player.field_70138_W = 2.0f;
            }
            if (player.field_70122_E) {
                float bonus = 0.05f;
                if (player.func_70090_H()) {
                    bonus /= 4.0f;
                }
                player.func_191958_b(0.0f, 0.0f, bonus, 4.0f);
            } else {
                if (player.func_70090_H()) {
                    player.func_191958_b(0.0f, 0.0f, 0.025f, 1.0f);
                }
                player.field_70747_aH = 1.5f;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            ItemStack stack;
            boolean hasArmor;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            boolean bl = hasArmor = player.func_184209_aF() != Collections.emptyList();
            if (hasArmor) {
                player.field_70181_x += (double)this.jumpBonus;
            }
            if (((ItemStack)player.field_71071_by.field_70460_b.get(0)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(0)).func_77973_b() instanceof ItemElectricBootsTraveller && ElectricItem.manager.use(stack = (ItemStack)player.field_71071_by.field_70460_b.get(0), (double)this.energyPerDamage, (EntityLivingBase)player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            ItemStack stack;
            EntityPlayer entity = (EntityPlayer)event.getEntity();
            if (((ItemStack)entity.field_71071_by.field_70460_b.get(0)).func_190926_b() && ((ItemStack)entity.field_71071_by.field_70460_b.get(0)).func_77973_b() instanceof ItemElectricBootsTraveller && ElectricItem.manager.use(stack = (ItemStack)entity.field_71071_by.field_70460_b.get(0), (double)this.energyPerDamage, (EntityLivingBase)entity)) {
                event.setCanceled(true);
            }
        }
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "emt:textures/models/armor/electricboots.png";
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        if (!EMTConfigHandler.enchanting) {
            return 0;
        }
        return 4;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return EMTConfigHandler.enchanting;
    }

    private int getEnergyPerDamage() {
        return this.energyPerDamage;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return 2;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean isMetalArmor(ItemStack itemStack, EntityPlayer entityPlayer) {
        return true;
    }

    public int getMaxCharge(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return 240;
    }

    public IRechargable.EnumChargeDisplay showInHud(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return IRechargable.EnumChargeDisplay.PERIODIC;
    }
}

