/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.skyworld;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.dave.compactmachines3.skyworld.SkyWorldType;
import org.dave.compactmachines3.utility.Logz;

public class SkyWorldSavedData
extends WorldSavedData {
    private static final String SAVED_DATA_NAME = "CompactSkiesSavedData";
    public static SkyWorldSavedData instance;
    private Set<UUID> hubMachineOwners = new HashSet<UUID>();
    private Set<UUID> startingInventoryReceivers = new HashSet<UUID>();
    private Map<UUID, Integer> homeOwnerMapping = new HashMap<UUID, Integer>();

    public SkyWorldSavedData(String name) {
        super(name);
    }

    public boolean isHubMachineOwner(EntityPlayer player) {
        return this.hubMachineOwners.contains(player.func_110124_au());
    }

    public void setHomeOwner(EntityPlayer player, int coords) {
        this.homeOwnerMapping.put(player.func_110124_au(), coords);
        this.hubMachineOwners.add(player.func_110124_au());
        this.func_76185_a();
    }

    public boolean hasSkyworldHome(EntityPlayer player) {
        return this.homeOwnerMapping.containsKey(player.func_110124_au());
    }

    public int getSkyworldHome(EntityPlayer player) {
        return this.homeOwnerMapping.get(player.func_110124_au());
    }

    public boolean hasReceivedStartingInventory(EntityPlayer player) {
        return this.startingInventoryReceivers.contains(player.func_110124_au());
    }

    public void addToStartingInventoryReceiverSet(EntityPlayer player) {
        this.startingInventoryReceivers.add(player.func_110124_au());
        this.func_76185_a();
    }

    @SubscribeEvent
    public static void loadWorld(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world.field_72995_K || !(world.func_175624_G() instanceof SkyWorldType)) {
            return;
        }
        SkyWorldSavedData data = (SkyWorldSavedData)world.func_175693_T().func_75742_a(SkyWorldSavedData.class, SAVED_DATA_NAME);
        if (data == null) {
            data = new SkyWorldSavedData(SAVED_DATA_NAME);
            data.func_76185_a();
        }
        Logz.info("Compact Skies Machine Owners: %d", data.hubMachineOwners.size());
        instance = data;
        world.func_175693_T().func_75745_a(SAVED_DATA_NAME, (WorldSavedData)data);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        UUID uuid;
        NBTTagCompound compoundUUID;
        NBTTagList tagList;
        this.hubMachineOwners.clear();
        if (nbt.func_74764_b("hubMachineOwners")) {
            tagList = nbt.func_150295_c("hubMachineOwners", 10);
            for (NBTBase baseUUID : tagList) {
                compoundUUID = (NBTTagCompound)baseUUID;
                uuid = compoundUUID.func_186857_a("");
                this.hubMachineOwners.add(uuid);
            }
        }
        this.startingInventoryReceivers.clear();
        if (nbt.func_74764_b("startingInventoryReceivers")) {
            tagList = nbt.func_150295_c("startingInventoryReceivers", 10);
            for (NBTBase baseUUID : tagList) {
                compoundUUID = (NBTTagCompound)baseUUID;
                uuid = compoundUUID.func_186857_a("");
                this.startingInventoryReceivers.add(uuid);
            }
        }
        this.homeOwnerMapping.clear();
        if (nbt.func_74764_b("homeOwnerMapping")) {
            NBTTagCompound tagCompound = nbt.func_74775_l("homeOwnerMapping");
            for (String key : tagCompound.func_150296_c()) {
                int coord = Integer.parseInt(key);
                NBTTagCompound innerCompound = tagCompound.func_74775_l(key);
                UUID owner = innerCompound.func_186857_a("");
                this.homeOwnerMapping.put(owner, coord);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList hubMachineOwnersTagList = new NBTTagList();
        for (UUID uUID : this.hubMachineOwners) {
            NBTTagCompound compoundUUID = new NBTTagCompound();
            compoundUUID.func_186854_a("", uUID);
            hubMachineOwnersTagList.func_74742_a((NBTBase)compoundUUID);
        }
        compound.func_74782_a("hubMachineOwners", (NBTBase)hubMachineOwnersTagList);
        NBTTagList startingInventoryReceiversTagList = new NBTTagList();
        for (UUID uuid : this.startingInventoryReceivers) {
            NBTTagCompound compoundUUID = new NBTTagCompound();
            compoundUUID.func_186854_a("", uuid);
            startingInventoryReceiversTagList.func_74742_a((NBTBase)compoundUUID);
        }
        compound.func_74782_a("startingInventoryReceivers", (NBTBase)startingInventoryReceiversTagList);
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        for (UUID owner : this.homeOwnerMapping.keySet()) {
            NBTTagCompound innerKey = new NBTTagCompound();
            innerKey.func_186854_a("", owner);
            int coords = this.homeOwnerMapping.get(owner);
            nBTTagCompound.func_74782_a("" + coords, (NBTBase)innerKey);
        }
        compound.func_74782_a("homeOwnerMapping", (NBTBase)nBTTagCompound);
        return compound;
    }
}

