/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.common.affix.affix;

import c4.champions.common.affix.core.AffixBase;
import c4.champions.common.affix.core.AffixCategory;
import c4.champions.common.affix.core.AffixNBT;
import c4.champions.common.capability.CapabilityChampionship;
import c4.champions.common.capability.IChampionship;
import c4.champions.common.config.ConfigHandler;
import c4.champions.common.rank.RankManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class AffixInfested
extends AffixBase {
    public AffixInfested() {
        super("infested", AffixCategory.OFFENSE);
    }

    @Override
    public void onInitialSpawn(EntityLiving entity, IChampionship cap) {
        AffixNBT.Integer buffer = AffixNBT.getData(cap, this.getIdentifier(), AffixNBT.Integer.class);
        buffer.num = Math.min(ConfigHandler.affix.infested.silverfishTotal, Math.max(1, (int)((double)entity.func_110138_aP() * ConfigHandler.affix.infested.silverfishPerHealth)));
        buffer.saveData(entity);
    }

    @Override
    public void onSpawn(EntityLiving entity, IChampionship cap) {
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new AISpawnParasite(entity));
    }

    @Override
    public float onHealed(EntityLiving entity, IChampionship cap, float amount, float newAmount) {
        if (newAmount > 0.0f && rand.nextFloat() < 0.5f) {
            AffixNBT.Integer buffer = AffixNBT.getData(cap, this.getIdentifier(), AffixNBT.Integer.class);
            buffer.num = Math.min(ConfigHandler.affix.infested.silverfishTotal, buffer.num + 2);
            buffer.saveData(entity);
            return 0.0f;
        }
        return newAmount;
    }

    @Override
    public void onDeath(EntityLiving entity, IChampionship cap, DamageSource source, LivingDeathEvent evt) {
        if (!entity.field_70170_p.field_72995_K) {
            AffixNBT.Integer buffer = AffixNBT.getData(cap, this.getIdentifier(), AffixNBT.Integer.class);
            EntityLivingBase target = null;
            if (source.func_76346_g() instanceof EntityLivingBase) {
                target = (EntityLivingBase)source.func_76346_g();
            }
            boolean isEnder = false;
            if (entity instanceof EntityEnderman || entity instanceof EntityShulker || entity instanceof EntityEndermite || entity instanceof EntityDragon) {
                isEnder = true;
            }
            List<EntityLiving> parasites = this.spawnParasites(entity.field_70170_p, entity.func_180425_c(), buffer.num, isEnder);
            for (EntityLiving en : parasites) {
                en.func_70604_c(target);
            }
        }
    }

    private List<EntityLiving> spawnParasites(World world, BlockPos pos, int amount, boolean isEnder) {
        ArrayList parasites = Lists.newArrayList();
        for (int i = 0; i < amount; ++i) {
            EntityEndermite para = isEnder ? new EntityEndermite(world) : new EntitySilverfish(world);
            para.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            IChampionship chp = CapabilityChampionship.getChampionship((EntityLiving)para);
            if (chp != null) {
                chp.setRank(RankManager.getEmptyRank());
            }
            world.func_72838_d((Entity)para);
            para.func_70656_aK();
            parasites.add(para);
        }
        return parasites;
    }

    @Override
    public boolean canApply(EntityLiving entity) {
        return !(entity instanceof EntitySilverfish) && !(entity instanceof EntityEndermite);
    }

    class AISpawnParasite
    extends EntityAIBase {
        private final EntityLiving entity;
        private int attackTime;

        public AISpawnParasite(EntityLiving entityLiving) {
            this.entity = entityLiving;
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.entity.func_70638_az();
            return AffixBase.isValidAffixTarget(this.entity, entitylivingbase, true) && entitylivingbase.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
        }

        public void func_75249_e() {
            this.attackTime = ConfigHandler.affix.infested.silverfishInterval;
        }

        public void func_75246_d() {
            if (this.entity.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                --this.attackTime;
                EntityLivingBase entitylivingbase = this.entity.func_70638_az();
                IChampionship chp = CapabilityChampionship.getChampionship(this.entity);
                if (entitylivingbase != null && chp != null) {
                    this.entity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 180.0f, 180.0f);
                    AffixNBT.Integer buffer = AffixNBT.getData(chp, AffixInfested.this.getIdentifier(), AffixNBT.Integer.class);
                    if (this.attackTime <= 0 && buffer.num > 0) {
                        this.attackTime = ConfigHandler.affix.desecrator.attackInterval + this.entity.func_70681_au().nextInt(5) * 10;
                        boolean isEnder = false;
                        if (this.entity instanceof EntityEnderman || this.entity instanceof EntityShulker || this.entity instanceof EntityEndermite || this.entity instanceof EntityDragon) {
                            isEnder = true;
                        }
                        List parasites = AffixInfested.this.spawnParasites(this.entity.field_70170_p, this.entity.func_180425_c(), ConfigHandler.affix.infested.silverfishAmount, isEnder);
                        for (EntityLiving en : parasites) {
                            en.func_70624_b(entitylivingbase);
                        }
                        buffer.num = Math.max(0, buffer.num - parasites.size());
                        buffer.saveData(this.entity);
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

