/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.entity.spirit.demon;

import com.bewitchment.Util;
import com.bewitchment.api.BewitchmentAPI;
import com.bewitchment.common.entity.util.ModEntityMob;
import com.bewitchment.common.item.ItemContract;
import com.bewitchment.common.village.VillagerTradeHandler;
import com.bewitchment.registry.ModObjects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class EntityDemon
extends ModEntityMob
implements IMerchant {
    public int attackTimer = 0;
    public EntityPlayer buyer;
    public EntityPlayer lastBuyer;
    private MerchantRecipeList recipeList;
    private int careerId;
    private int careerLevel;
    private int timeUntilReset;
    private boolean needsInitilization;

    public EntityDemon(World world) {
        super(world, new ResourceLocation("bewitchment", "entities/demon" + world.field_73012_v.nextInt(4)));
        this.func_70105_a(1.425f, 3.8f);
        this.field_70178_ae = true;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70728_aV = 75;
        this.func_110163_bv();
    }

    public boolean func_70687_e(PotionEffect effect) {
        return effect.func_188419_a() != MobEffects.field_76436_u && effect.func_188419_a() != MobEffects.field_82731_v && super.func_70687_e(effect);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return BewitchmentAPI.DEMON;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.field_70173_aa % 20 == 0 && this.func_180799_ab()) {
            this.func_70691_i(6.0f);
        }
        if (this.func_70638_az() != null) {
            boolean launchFireball;
            EntityLivingBase player = this.func_70638_az();
            boolean bl = launchFireball = this.field_70173_aa % 80 > 5;
            if (!launchFireball && this.func_70032_d((Entity)player) > 2.0f) {
                double d0 = this.func_70068_e((Entity)player);
                double d1 = player.field_70165_t - this.field_70165_t;
                double d2 = player.func_174813_aQ().field_72338_b + (double)(player.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
                double d3 = player.field_70161_v - this.field_70161_v;
                float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                this.field_70170_p.func_180498_a(null, 1018, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
                EntitySmallFireball entitysmallfireball = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, d1 + this.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.func_70681_au().nextGaussian() * (double)f);
                entitysmallfireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
                this.func_184609_a(EnumHand.MAIN_HAND);
                this.field_70170_p.func_72838_d((Entity)entitysmallfireball);
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        if (flag) {
            this.attackTimer = 10;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 1, false, false));
                entity.func_70015_d(25);
                entity.field_70181_x += 0.6;
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity));
                }
            }
        }
        return flag;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(6.66);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(3.33);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(195.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.8);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.7);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new DemonAITradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 5.0f, 1.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.6666666666666666));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, false, false, e -> (Util.hasBauble(e, ModObjects.hellish_bauble) ? this.field_70170_p.field_73012_v.nextInt(4) == 0 : !e.func_70045_F()) && !BewitchmentAPI.hasBesmirchedGear(e)));
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(--i);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(300);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
        } else {
            super.func_70103_a(id);
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70619_bc() {
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.needsInitilization) {
                    for (MerchantRecipe merchantrecipe : this.recipeList) {
                        if (merchantrecipe.func_77397_d().func_77973_b() instanceof ItemContract || !merchantrecipe.func_82784_g()) continue;
                        merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                    this.populateBuyingList();
                    this.needsInitilization = false;
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151057_cb || itemstack.func_77973_b() == Items.field_151058_ca) {
            itemstack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (this.func_70089_S() && !this.isTrading() && !this.func_70631_g_() && !player.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
            }
            if (this.recipeList == null) {
                this.populateBuyingList();
            }
            if (hand == EnumHand.MAIN_HAND) {
                player.func_71029_a(StatList.field_188074_H);
            }
            if (!this.field_70170_p.field_72995_K && !this.recipeList.isEmpty()) {
                player.func_180472_a((IMerchant)this);
            } else if (this.recipeList.isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public ITextComponent func_145748_c_() {
        Team team = this.func_96124_cp();
        String s = this.func_95999_t();
        if (s != null && !s.isEmpty()) {
            TextComponentString textcomponentstring = new TextComponentString(ScorePlayerTeam.func_96667_a((Team)team, (String)s));
            textcomponentstring.func_150256_b().func_150209_a(this.func_174823_aP());
            textcomponentstring.func_150256_b().func_179989_a(this.func_189512_bd());
            return textcomponentstring;
        }
        TextComponentString itextcomponent = new TextComponentString(this.func_70005_c_());
        itextcomponent.func_150256_b().func_150209_a(this.func_174823_aP());
        itextcomponent.func_150256_b().func_179989_a(this.func_189512_bd());
        if (team != null) {
            itextcomponent.func_150256_b().func_150238_a(team.func_178775_l());
        }
        return itextcomponent;
    }

    @Override
    protected int getSkinTypes() {
        return 4;
    }

    @Override
    protected boolean func_70814_o() {
        return true;
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("careerId", this.careerId);
        tag.func_74768_a("careerLevel", this.careerLevel);
        if (this.recipeList != null) {
            tag.func_74782_a("recipeList", (NBTBase)this.recipeList.func_77202_a());
        }
        super.func_70014_b(tag);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        this.careerId = tag.func_74762_e("careerId");
        this.careerLevel = tag.func_74762_e("careerLevel");
        if (tag.func_74764_b("recipeList")) {
            NBTTagCompound compound = tag.func_74775_l("recipeList");
            this.recipeList = new MerchantRecipeList(compound);
        }
        super.func_70037_a(tag);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        this.func_96094_a((this.field_70146_Z.nextInt(3) == 0 ? new TextComponentTranslation("entity.bewitchment.prefix." + this.field_70146_Z.nextInt(102), new Object[0]).func_150254_d() + " " : "") + new TextComponentTranslation("entity.bewitchment.given_name." + this.field_70146_Z.nextInt(503), new Object[0]).func_150254_d());
        return super.func_180482_a(difficulty, data);
    }

    public VillagerRegistry.VillagerProfession getProfessionForge() {
        return VillagerTradeHandler.INSTANCE.demon;
    }

    private void populateBuyingList() {
        if (this.careerId != 0 && this.careerLevel != 0) {
            ++this.careerLevel;
        } else {
            this.careerId = this.getProfessionForge().getRandomCareer(this.field_70146_Z) + 1;
            this.careerLevel = 1;
        }
        if (this.recipeList == null) {
            this.recipeList = new MerchantRecipeList();
        }
        int i = this.careerId - 1;
        int j = this.careerLevel - 1;
        List trades = this.getProfessionForge().getCareer(i).getTrades(j);
        if (trades != null && !trades.isEmpty()) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int t = 0; t < trades.size(); ++t) {
                list.add(t);
            }
            Collections.shuffle(list);
            ((EntityVillager.ITradeList)trades.get((Integer)list.get(0))).func_190888_a((IMerchant)this, this.recipeList, this.field_70146_Z);
            if (j <= 3 && list.size() > 1) {
                ((EntityVillager.ITradeList)trades.get((Integer)list.get(1))).func_190888_a((IMerchant)this, this.recipeList, this.field_70146_Z);
            }
        }
    }

    public boolean isTrading() {
        return this.buyer != null;
    }

    public BlockPos func_190671_u_() {
        return this.func_180425_c();
    }

    public EntityPlayer func_70931_l_() {
        return this.buyer;
    }

    public void func_70932_a_(EntityPlayer player) {
        this.buyer = player;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.recipeList == null) {
            this.populateBuyingList();
        }
        return this.recipeList;
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public void func_70930_a(MerchantRecipeList recipeList) {
        this.recipeList = recipeList;
    }

    public void func_110297_a_(ItemStack stack) {
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.timeUntilReset = 40;
            this.needsInitilization = true;
            this.lastBuyer = this.buyer != null ? this.buyer : null;
            i += 5;
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t + 0.5, this.field_70163_u, this.field_70161_v, i));
        }
    }

    private class DemonAITradePlayer
    extends EntityAIBase {
        private final EntityDemon demon;

        public DemonAITradePlayer(EntityDemon demon) {
            this.demon = demon;
            this.func_75248_a(4);
        }

        public boolean func_75250_a() {
            if (!this.demon.func_70089_S()) {
                return false;
            }
            if (this.demon.func_70090_H()) {
                return false;
            }
            if (!this.demon.field_70122_E) {
                return false;
            }
            if (this.demon.field_70133_I) {
                return false;
            }
            EntityPlayer entityplayer = this.demon.func_70931_l_();
            if (entityplayer == null) {
                return false;
            }
            if (this.demon.func_70068_e((Entity)entityplayer) > 16.0) {
                return false;
            }
            return entityplayer.field_71070_bA != null;
        }

        public void func_75251_c() {
            this.demon.func_70932_a_(null);
        }

        public void func_75246_d() {
            this.demon.func_70661_as().func_75499_g();
        }
    }
}

