/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block.tile.entity;

import com.bewitchment.Util;
import com.bewitchment.api.registry.OvenRecipe;
import com.bewitchment.common.block.BlockWitchesOven;
import com.bewitchment.common.block.tile.entity.util.ModTileEntity;
import com.bewitchment.registry.ModObjects;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.botania.api.item.IExoflameHeatable;

@Optional.Interface(iface="vazkii.botania.api.item.IExoflameHeatable", modid="botania")
public class TileEntityWitchesOven
extends ModTileEntity
implements ITickable,
IExoflameHeatable {
    private final ItemStackHandler inventory_down = new ItemStackHandler(2){

        public boolean isItemValid(int index, ItemStack stack) {
            return false;
        }
    };
    public int burnTime;
    public int fuelBurnTime;
    public int progress;
    private OvenRecipe recipe;
    private final ItemStackHandler inventory_up = new ItemStackHandler(3){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return ((slot != 0 ? slot == 2 : TileEntityFurnace.func_145954_b((ItemStack)stack)) || (slot == 1 ? stack.func_77973_b() == ModObjects.empty_jar : slot == 2)) && (this.getStackInSlot(slot).func_190926_b() || Util.canMerge(stack, this.getStackInSlot(slot)));
        }

        protected void onContentsChanged(int index) {
            TileEntityWitchesOven.this.recipe = GameRegistry.findRegistry(OvenRecipe.class).getValuesCollection().stream().filter(p -> p.matches(this.getStackInSlot(2))).findFirst().orElse(null);
        }
    };
    private boolean burning;

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.recipe = tag.func_74779_i("recipe").isEmpty() ? null : (OvenRecipe)GameRegistry.findRegistry(OvenRecipe.class).getValue(new ResourceLocation(tag.func_74779_i("recipe")));
        this.burning = tag.func_74767_n("burning");
        this.burnTime = tag.func_74762_e("burnTime");
        this.fuelBurnTime = tag.func_74762_e("fuelBurnTime");
        this.progress = tag.func_74762_e("progress");
        super.func_145839_a(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74778_a("recipe", this.recipe == null ? "" : this.recipe.getRegistryName().toString());
        tag.func_74757_a("burning", this.burning);
        tag.func_74768_a("burnTime", this.burnTime);
        tag.func_74768_a("fuelBurnTime", this.fuelBurnTime);
        tag.func_74768_a("progress", this.progress);
        return super.func_189515_b(tag);
    }

    @Override
    public ItemStackHandler[] getInventories() {
        return new ItemStackHandler[]{this.inventory_up, this.inventory_down};
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing face) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, face);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing face) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)(face == EnumFacing.DOWN ? this.inventory_down : this.inventory_up)) : super.getCapability(capability, face));
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.burning && this.burnTime < 1) {
                this.burning = this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockWitchesOven.LIT, (Comparable)Boolean.valueOf(false)));
            }
            if (this.burnTime > 0) {
                --this.burnTime;
            } else if (this.progress > 0) {
                this.progress -= 2;
                if (this.progress < 0) {
                    this.progress = 0;
                }
            }
            if (!(this.recipe != null && this.recipe.isValid(this.inventory_up, this.inventory_down) || this.isFurnaceRecipe())) {
                this.progress = 0;
            } else if (this.burnTime < 1) {
                int time = TileEntityFurnace.func_145952_a((ItemStack)this.inventory_up.getStackInSlot(0));
                if (time > 0) {
                    this.burnFuel(time, true);
                }
            } else {
                ++this.progress;
                if (this.progress >= 200) {
                    this.progress = 0;
                    if (this.recipe == null) {
                        this.outputFurnace();
                    } else {
                        this.recipe.giveOutput(this.field_145850_b.field_73012_v, this.inventory_up, this.inventory_down);
                    }
                }
            }
        }
    }

    private void burnFuel(int time, boolean consume) {
        ItemStack stack;
        this.fuelBurnTime = this.burnTime = time + 1;
        if (consume && (stack = this.inventory_up.extractItem(0, 1, false)).func_77973_b() == Items.field_151129_at) {
            this.inventory_up.insertItem(0, new ItemStack(Items.field_151133_ar), false);
        }
        if (!this.burning) {
            this.burning = this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockWitchesOven.LIT, (Comparable)Boolean.valueOf(true)));
        }
    }

    @Optional.Method(modid="botania")
    public boolean canSmelt() {
        return this.recipe != null && this.recipe.isValid(this.inventory_up, this.inventory_down) || this.isFurnaceRecipe();
    }

    @Optional.Method(modid="botania")
    public int getBurnTime() {
        return this.burnTime;
    }

    @Optional.Method(modid="botania")
    public void boostBurnTime() {
        this.burnFuel(200, false);
    }

    @Optional.Method(modid="botania")
    public void boostCookTime() {
        ++this.progress;
    }

    private boolean isFurnaceRecipe() {
        ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory_up.getStackInSlot(2));
        return !stack.func_190926_b() && Util.canMerge(this.inventory_down.getStackInSlot(0), stack);
    }

    private void outputFurnace() {
        this.inventory_down.insertItem(0, FurnaceRecipes.func_77602_a().func_151395_a(this.inventory_up.getStackInSlot(2)).func_77946_l(), false);
        this.inventory_up.extractItem(2, 1, false);
    }
}

