/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecturecraft.repackage.com.elytradev.concrete.config;

import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.common.ConcreteLog;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.common.ShadingValidator;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.config.ConfigValue;
import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FilenameUtils;

public abstract class ConcreteConfig {
    private final Configuration configuration;
    private Map<Field, Object> fieldToDefaultValue = null;
    private final String modID;

    @Deprecated
    protected ConcreteConfig(File configFile) {
        this(configFile, FilenameUtils.removeExtension((String)configFile.getName()));
    }

    protected ConcreteConfig(File configFile, String modID) {
        this.configuration = new Configuration(configFile);
        this.modID = modID;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void loadConfig() {
        if (this.fieldToDefaultValue == null) {
            this.fieldToDefaultValue = Maps.newHashMap();
            for (Class<?> cursor = this.getClass(); cursor != null && cursor != Object.class; cursor = cursor.getSuperclass()) {
                for (Field field : cursor.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(ConfigValue.class)) continue;
                    try {
                        field.setAccessible(true);
                        this.fieldToDefaultValue.put(field, field.get(this));
                    }
                    catch (IllegalAccessException e) {
                        ConcreteLog.error("Failed to access field when loading a concrete configuration.", (Throwable)e);
                    }
                }
            }
        }
        for (Map.Entry<Field, Object> fieldEntry : this.fieldToDefaultValue.entrySet()) {
            Field field = fieldEntry.getKey();
            Object defaultValue = fieldEntry.getValue();
            ConfigValue cfgValue = field.getAnnotation(ConfigValue.class);
            String valueKey = cfgValue.key();
            String valueComment = cfgValue.comment();
            String valueCategory = cfgValue.category();
            String valueLangKey = cfgValue.langKey();
            boolean showValueInGui = cfgValue.showInGui();
            boolean valueRequiresMcRestart = cfgValue.requiresMcRestart();
            boolean valueRequiresWorldRestart = cfgValue.requiresWorldRestart();
            if (valueKey.isEmpty()) {
                valueKey = field.getName();
            }
            if (valueLangKey.isEmpty()) {
                valueLangKey = this.modID + ".configgui." + valueKey;
            }
            Property property = null;
            try {
                if (field.getType().isArray()) {
                    switch (cfgValue.type()) {
                        case INTEGER: {
                            property = this.configuration.get(valueCategory, valueKey, (int[])defaultValue, valueComment);
                            field.set(this, property.getIntList());
                            break;
                        }
                        case BOOLEAN: {
                            property = this.configuration.get(valueCategory, valueKey, (boolean[])defaultValue, valueComment);
                            field.set(this, property.getBooleanList());
                            break;
                        }
                        case DOUBLE: {
                            property = this.configuration.get(valueCategory, valueKey, (double[])defaultValue, valueComment);
                            field.set(this, property.getDoubleList());
                            break;
                        }
                        case STRING: {
                            property = this.configuration.get(valueCategory, valueKey, (String[])defaultValue, valueComment);
                            field.set(this, property.getStringList());
                        }
                    }
                } else {
                    switch (cfgValue.type()) {
                        case INTEGER: {
                            property = this.configuration.get(valueCategory, valueKey, ((Integer)defaultValue).intValue(), valueComment);
                            field.set(this, property.getInt());
                            break;
                        }
                        case BOOLEAN: {
                            property = this.configuration.get(valueCategory, valueKey, ((Boolean)defaultValue).booleanValue(), valueComment);
                            field.set(this, property.getBoolean());
                            break;
                        }
                        case DOUBLE: {
                            property = this.configuration.get(valueCategory, valueKey, ((Double)defaultValue).doubleValue(), valueComment);
                            field.set(this, property.getDouble());
                            break;
                        }
                        case STRING: {
                            property = this.configuration.get(valueCategory, valueKey, (String)defaultValue, valueComment);
                            field.set(this, property.getString());
                        }
                    }
                }
            }
            catch (IllegalAccessException e) {
                ConcreteLog.error("Failed to access field when loading a concrete configuration.", (Throwable)e);
            }
            if (property == null) continue;
            property.setShowInGui(showValueInGui);
            property.setLanguageKey(valueLangKey);
            property.setRequiresMcRestart(valueRequiresMcRestart);
            if (!valueRequiresWorldRestart) continue;
            property.setRequiresWorldRestart(true);
        }
        for (String categoryName : this.configuration.getCategoryNames()) {
            ConfigCategory category = this.configuration.getCategory(categoryName);
            category.setLanguageKey(this.modID + ".configgui.ctgy." + categoryName);
        }
        this.configuration.save();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getModID() {
        return this.modID;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (this.modID.equals(event.getModID())) {
            this.loadConfig();
        }
    }

    static {
        ShadingValidator.ensureShaded();
    }
}

