/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.persistence;

import com.google.common.collect.ListMultimap;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.chest.ChestInfo;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.enums.WorldGenerators;
import com.someguyssoftware.treasure2.generator.oasis.OasisInfo;
import com.someguyssoftware.treasure2.registry.ChestRegistry;
import com.someguyssoftware.treasure2.registry.OasisRegistry;
import com.someguyssoftware.treasure2.worldgen.GemOreWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.OasisWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.SubmergedChestWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.SurfaceChestWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.WellWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.WitherTreeWorldGenerator;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class GenDataPersistence
extends WorldSavedData {
    private static final String TREASURE_GEN_TAG_NAME = "treasureGenerator";
    public static final String GEN_DATA_KEY = "treasureGenData";
    private static final String SURFACE_CHEST_GEN_TAG_NAME = "surfaceChestGen";
    private static final String SUBMERGED_CHEST_GEN_TAG_NAME = "submergedChestGen";
    private static final String OASIS_GEN_TAG_NAME = "oasisGen";
    private static final String KEY_TAG_NAME = "key";
    private static final String COUNT_TAG_NAME = "count";
    private static final String CHUNKS_SINCE_LAST_CHEST_TAG_NAME = "chunksSinceLastChest";
    private static final String CHUNKS_SINCE_LAST_RARITY_CHEST_TAG_NAME = "chunksSinceLastRarityChest";
    private static final String CHEST_REGISTRY_TAG_NAME = "chestRegistry";
    private static final String OASIS_REGISTRY_TAG_NAME = "oasisRegistry";
    private static final String CHUNKS_SINCE_LAST_OASIS_TAG_NAME = "chunksSinceLastOasis";
    private static final String COORDS_TAG_NAME = "coords";
    private static final String RARITY_TAG_NAME = "rarity";
    private static final String DIMENSION_ID_TAG_NAME = "dimensionID";
    private static final String DIMENSIONS_TAG_NAME = "dimensions";
    private static final String BIOME_ID_TAG_NAME = "biomeID";
    private static final String BIOMES_TAG_NAME = "biomes";

    public GenDataPersistence() {
        super(GEN_DATA_KEY);
    }

    public GenDataPersistence(String key) {
        super(key);
    }

    public void func_76184_a(NBTTagCompound tag) {
        NBTTagCompound oasisTag;
        String key;
        int count;
        NBTTagCompound chunkTag;
        int i;
        NBTTagList chunksSinceTagList;
        Treasure.logger.debug("Loading Treasure! saved gen data...");
        SurfaceChestWorldGenerator surfaceChestGen = (SurfaceChestWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.SURFACE_CHEST);
        SubmergedChestWorldGenerator submergedChestGen = (SubmergedChestWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.SUBMERGED_CHEST);
        WellWorldGenerator wellGen = (WellWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.WELL);
        WitherTreeWorldGenerator witherGen = (WitherTreeWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.WITHER_TREE);
        GemOreWorldGenerator gemGen = (GemOreWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.GEM);
        OasisWorldGenerator oasisGen = (OasisWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.OASIS);
        NBTTagCompound treasureGen = tag.func_74775_l(TREASURE_GEN_TAG_NAME);
        NBTTagCompound surfaceTag = treasureGen.func_74775_l(SURFACE_CHEST_GEN_TAG_NAME);
        NBTTagCompound submergedTag = treasureGen.func_74775_l(SUBMERGED_CHEST_GEN_TAG_NAME);
        if (surfaceTag != null) {
            surfaceChestGen.setChunksSinceLastChest(surfaceTag.func_74762_e(CHUNKS_SINCE_LAST_CHEST_TAG_NAME));
            chunksSinceTagList = surfaceTag.func_150295_c(CHUNKS_SINCE_LAST_RARITY_CHEST_TAG_NAME, 10);
            for (i = 0; i < chunksSinceTagList.func_74745_c(); ++i) {
                chunkTag = chunksSinceTagList.func_150305_b(i);
                count = chunkTag.func_74762_e(COUNT_TAG_NAME);
                key = chunkTag.func_74779_i(KEY_TAG_NAME);
                surfaceChestGen.getChunksSinceLastRarityChest().put(Rarity.valueOf(key), count);
            }
        }
        if (submergedTag != null) {
            submergedChestGen.setChunksSinceLastChest(submergedTag.func_74762_e(CHUNKS_SINCE_LAST_CHEST_TAG_NAME));
            chunksSinceTagList = submergedTag.func_150295_c(CHUNKS_SINCE_LAST_RARITY_CHEST_TAG_NAME, 10);
            for (i = 0; i < chunksSinceTagList.func_74745_c(); ++i) {
                chunkTag = chunksSinceTagList.func_150305_b(i);
                count = chunkTag.func_74762_e(COUNT_TAG_NAME);
                key = chunkTag.func_74779_i(KEY_TAG_NAME);
                submergedChestGen.getChunksSinceLastRarityChest().put(Rarity.valueOf(key), count);
            }
        }
        if ((oasisTag = treasureGen.func_74775_l(OASIS_GEN_TAG_NAME)) != null) {
            NBTTagList dimTagList = oasisTag.func_150295_c(DIMENSIONS_TAG_NAME, 10);
            for (int i2 = 0; i2 < dimTagList.func_74745_c(); ++i2) {
                NBTTagCompound dimTag = dimTagList.func_150305_b(i2);
                int dimensionID = dimTag.func_74762_e(DIMENSION_ID_TAG_NAME);
                int chunksSince = dimTag.func_74762_e(CHUNKS_SINCE_LAST_OASIS_TAG_NAME);
                oasisGen.getChunksSinceLastDimensionOasis().put(dimensionID, chunksSince);
                NBTTagList biomeTagList = dimTag.func_150295_c(BIOMES_TAG_NAME, 10);
                for (int k = 0; k < biomeTagList.func_74745_c(); ++k) {
                    NBTTagCompound biomeTag = dimTagList.func_150305_b(k);
                    int biomeID = biomeTag.func_74762_e(BIOME_ID_TAG_NAME);
                    int chunksSinceBiome = biomeTag.func_74762_e(CHUNKS_SINCE_LAST_OASIS_TAG_NAME);
                    oasisGen.getChunksSinceLastDimensionBiomeOasis().get(dimensionID).put(biomeID, chunksSinceBiome);
                }
            }
        }
        wellGen.setChunksSinceLastWell(treasureGen.func_74762_e("chunksSinceLastWell"));
        witherGen.setChunksSinceLastTree(treasureGen.func_74762_e("chunksSinceLastTree"));
        gemGen.setChunksSinceLastOre(treasureGen.func_74762_e("chunksSinceLastOre"));
        ChestRegistry chestRegistry = ChestRegistry.getInstance();
        Treasure.logger.debug("ChestConfig Registry size before loading -> {}", (Object)chestRegistry.getValues().size());
        chestRegistry.clear();
        NBTTagList chestRegistryTagList = treasureGen.func_150295_c(CHEST_REGISTRY_TAG_NAME, 10);
        for (int i3 = 0; i3 < chestRegistryTagList.func_74745_c(); ++i3) {
            NBTTagCompound chunkTag2 = chestRegistryTagList.func_150305_b(i3);
            String key2 = chunkTag2.func_74779_i(KEY_TAG_NAME);
            String rarity = chunkTag2.func_74779_i(RARITY_TAG_NAME);
            NBTTagCompound coords = chunkTag2.func_74775_l(COORDS_TAG_NAME);
            int x = coords.func_74762_e("x");
            int y = coords.func_74762_e("y");
            int z = coords.func_74762_e("z");
            chestRegistry.register(key2, new ChestInfo(Rarity.getByValue(rarity), (ICoords)new Coords(x, y, z)));
        }
        Treasure.logger.debug("ChestConfig Registry size after loading -> {}", (Object)chestRegistry.getValues().size());
        OasisRegistry oasisRegistry = OasisRegistry.getInstance();
        oasisRegistry.clear();
        NBTTagList oasisRegistryDimensionTagList = treasureGen.func_150295_c(OASIS_REGISTRY_TAG_NAME, 10);
        for (int dimIndex = 0; dimIndex < oasisRegistryDimensionTagList.func_74745_c(); ++dimIndex) {
            NBTTagCompound dimTag = oasisRegistryDimensionTagList.func_150305_b(dimIndex);
            int dimensionID = dimTag.func_74762_e(DIMENSION_ID_TAG_NAME);
            NBTTagList oasisRegistryTagList = dimTag.func_150295_c("registry", 10);
            for (int registryIndex = 0; registryIndex < oasisRegistryTagList.func_74745_c(); ++registryIndex) {
                NBTTagCompound registryTag = oasisRegistryTagList.func_150305_b(registryIndex);
                String key3 = registryTag.func_74779_i(KEY_TAG_NAME);
                int biomeID = registryTag.func_74762_e(BIOME_ID_TAG_NAME);
                NBTTagCompound coordsTag = registryTag.func_74775_l(COORDS_TAG_NAME);
                int x = coordsTag.func_74762_e("x");
                int y = coordsTag.func_74762_e("y");
                int z = coordsTag.func_74762_e("z");
                oasisRegistry.register(dimensionID, key3, new OasisInfo((ICoords)new Coords(x, y, z), dimensionID, biomeID));
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        try {
            Object key;
            NBTTagCompound entry;
            NBTTagCompound treasureGen = new NBTTagCompound();
            tag.func_74782_a(TREASURE_GEN_TAG_NAME, (NBTBase)treasureGen);
            SurfaceChestWorldGenerator surfaceChestGen = (SurfaceChestWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.SURFACE_CHEST);
            SubmergedChestWorldGenerator submergedChestGen = (SubmergedChestWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.SUBMERGED_CHEST);
            NBTTagCompound surfaceTag = new NBTTagCompound();
            NBTTagCompound submergedTag = new NBTTagCompound();
            surfaceTag.func_74768_a(CHUNKS_SINCE_LAST_CHEST_TAG_NAME, surfaceChestGen.getChunksSinceLastChest());
            NBTTagList chunksSinceTagList = new NBTTagList();
            for (Map.Entry<Rarity, Integer> since : surfaceChestGen.getChunksSinceLastRarityChest().entrySet()) {
                entry = new NBTTagCompound();
                key = new NBTTagString(since.getKey().name());
                NBTTagInt nBTTagInt = new NBTTagInt(since.getValue().intValue());
                entry.func_74782_a(KEY_TAG_NAME, (NBTBase)key);
                entry.func_74782_a(COUNT_TAG_NAME, (NBTBase)nBTTagInt);
                chunksSinceTagList.func_74742_a((NBTBase)entry);
            }
            surfaceTag.func_74782_a(CHUNKS_SINCE_LAST_RARITY_CHEST_TAG_NAME, (NBTBase)chunksSinceTagList);
            submergedTag.func_74768_a(CHUNKS_SINCE_LAST_CHEST_TAG_NAME, submergedChestGen.getChunksSinceLastChest());
            chunksSinceTagList = new NBTTagList();
            for (Map.Entry<Rarity, Integer> since : submergedChestGen.getChunksSinceLastRarityChest().entrySet()) {
                entry = new NBTTagCompound();
                key = new NBTTagString(since.getKey().name());
                NBTTagInt nBTTagInt = new NBTTagInt(since.getValue().intValue());
                entry.func_74782_a(KEY_TAG_NAME, (NBTBase)key);
                entry.func_74782_a(COUNT_TAG_NAME, (NBTBase)nBTTagInt);
                chunksSinceTagList.func_74742_a((NBTBase)entry);
            }
            submergedTag.func_74782_a(CHUNKS_SINCE_LAST_RARITY_CHEST_TAG_NAME, (NBTBase)chunksSinceTagList);
            treasureGen.func_74782_a(SURFACE_CHEST_GEN_TAG_NAME, (NBTBase)surfaceTag);
            treasureGen.func_74782_a(SUBMERGED_CHEST_GEN_TAG_NAME, (NBTBase)submergedTag);
            OasisWorldGenerator oasisGen = (OasisWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.OASIS);
            NBTTagCompound oasisTag = new NBTTagCompound();
            NBTTagList dimTagList = new NBTTagList();
            for (Map.Entry entry2 : oasisGen.getChunksSinceLastDimensionOasis().entrySet()) {
                Treasure.logger.debug("dimension ID -> {}", entry2.getKey());
                NBTTagCompound dimTag = new NBTTagCompound();
                dimTag.func_74768_a(DIMENSION_ID_TAG_NAME, ((Integer)entry2.getKey()).intValue());
                dimTag.func_74768_a(CHUNKS_SINCE_LAST_OASIS_TAG_NAME, ((Integer)entry2.getValue()).intValue());
                Map<Integer, Integer> biomeMap = oasisGen.getChunksSinceLastDimensionBiomeOasis().get(entry2.getKey());
                Treasure.logger.debug("biome map size -> {}", (Object)biomeMap.size());
                NBTTagList biomeTagList = new NBTTagList();
                for (Map.Entry entry3 : biomeMap.entrySet()) {
                    NBTTagCompound biomeTag = new NBTTagCompound();
                    biomeTag.func_74768_a(BIOME_ID_TAG_NAME, ((Integer)entry3.getKey()).intValue());
                    biomeTag.func_74768_a(CHUNKS_SINCE_LAST_OASIS_TAG_NAME, ((Integer)entry3.getValue()).intValue());
                    biomeTagList.func_74742_a((NBTBase)biomeTag);
                }
                dimTag.func_74782_a(BIOMES_TAG_NAME, (NBTBase)biomeTagList);
                dimTagList.func_74742_a((NBTBase)dimTag);
            }
            oasisTag.func_74782_a(DIMENSIONS_TAG_NAME, (NBTBase)dimTagList);
            treasureGen.func_74782_a(OASIS_GEN_TAG_NAME, (NBTBase)oasisTag);
            WellWorldGenerator wellGen = (WellWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.WELL);
            treasureGen.func_74768_a("chunksSinceLastWell", wellGen.getChunksSinceLastWell());
            WitherTreeWorldGenerator witherTreeWorldGenerator = (WitherTreeWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.WITHER_TREE);
            treasureGen.func_74768_a("chunksSinceLastTree", witherTreeWorldGenerator.getChunksSinceLastTree());
            GemOreWorldGenerator gemGen = (GemOreWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.GEM);
            treasureGen.func_74768_a("chunksSinceLastOre", gemGen.getChunksSinceLastOre());
            NBTTagList chestRegistryTagList = new NBTTagList();
            ChestRegistry chestRegistry = ChestRegistry.getInstance();
            for (ChestInfo chestInfo : chestRegistry.getValues()) {
                NBTTagCompound entry3 = new NBTTagCompound();
                NBTTagString key2 = new NBTTagString(chestInfo.getCoords().toShortString());
                NBTTagString rarity = new NBTTagString(chestInfo.getRarity().getValue());
                NBTTagCompound coords = new NBTTagCompound();
                NBTTagInt x = new NBTTagInt(chestInfo.getCoords().getX());
                NBTTagInt y = new NBTTagInt(chestInfo.getCoords().getY());
                NBTTagInt z = new NBTTagInt(chestInfo.getCoords().getZ());
                coords.func_74782_a("x", (NBTBase)x);
                coords.func_74782_a("y", (NBTBase)y);
                coords.func_74782_a("z", (NBTBase)z);
                entry3.func_74782_a(KEY_TAG_NAME, (NBTBase)key2);
                entry3.func_74782_a(RARITY_TAG_NAME, (NBTBase)rarity);
                entry3.func_74782_a(COORDS_TAG_NAME, (NBTBase)coords);
                chestRegistryTagList.func_74742_a((NBTBase)entry3);
            }
            treasureGen.func_82580_o(CHEST_REGISTRY_TAG_NAME);
            treasureGen.func_74782_a(CHEST_REGISTRY_TAG_NAME, (NBTBase)chestRegistryTagList);
            OasisRegistry oasisRegistry = OasisRegistry.getInstance();
            NBTTagList nBTTagList = new NBTTagList();
            for (Integer dimensionKey : oasisRegistry.getDimensionKeys()) {
                ListMultimap<String, OasisInfo> dimensionMap = oasisRegistry.getDimensionEntry(dimensionKey);
                NBTTagCompound dimTag = new NBTTagCompound();
                dimTag.func_74768_a(DIMENSION_ID_TAG_NAME, dimensionKey.intValue());
                NBTTagList oasisRegistryTagList = new NBTTagList();
                for (Map.Entry entry4 : dimensionMap.entries()) {
                    OasisInfo oasisInfo = (OasisInfo)entry4.getValue();
                    NBTTagCompound oasisEntry = new NBTTagCompound();
                    NBTTagString key3 = new NBTTagString((String)entry4.getKey());
                    NBTTagInt biomeID = new NBTTagInt(oasisInfo.getBiomeID().intValue());
                    NBTTagCompound coords = new NBTTagCompound();
                    NBTTagInt x = new NBTTagInt(oasisInfo.getCoords().getX());
                    NBTTagInt y = new NBTTagInt(oasisInfo.getCoords().getY());
                    NBTTagInt z = new NBTTagInt(oasisInfo.getCoords().getZ());
                    coords.func_74782_a("x", (NBTBase)x);
                    coords.func_74782_a("y", (NBTBase)y);
                    coords.func_74782_a("z", (NBTBase)z);
                    oasisEntry.func_74782_a(KEY_TAG_NAME, (NBTBase)key3);
                    oasisEntry.func_74782_a(BIOME_ID_TAG_NAME, (NBTBase)biomeID);
                    oasisEntry.func_74782_a(COORDS_TAG_NAME, (NBTBase)coords);
                    oasisRegistryTagList.func_74742_a((NBTBase)oasisEntry);
                }
                dimTag.func_74782_a("registry", (NBTBase)oasisRegistryTagList);
                nBTTagList.func_74742_a((NBTBase)dimTag);
            }
            treasureGen.func_82580_o(OASIS_REGISTRY_TAG_NAME);
            treasureGen.func_74782_a(OASIS_REGISTRY_TAG_NAME, (NBTBase)nBTTagList);
        }
        catch (Exception e) {
            e.printStackTrace();
            Treasure.logger.error("An exception occurred:", (Throwable)e);
        }
        return tag;
    }

    public static GenDataPersistence get(World world) {
        GenDataPersistence data = (GenDataPersistence)world.func_72943_a(GenDataPersistence.class, GEN_DATA_KEY);
        if (data == null) {
            data = new GenDataPersistence();
            world.func_72823_a(GEN_DATA_KEY, (WorldSavedData)data);
        }
        return data;
    }
}

