/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.particle;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.network.PoisonMistMessageToServer;
import com.someguyssoftware.treasure2.particle.AbstractMistParticle;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PoisonMistParticle
extends AbstractMistParticle {
    protected static final float ALPHA_VALUE = 0.4f;
    private static ResourceLocation[] mistParticlesSprites = new ResourceLocation[4];

    public PoisonMistParticle(World world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, ICoords parentCoords) {
        super(world, x, y, z);
        this.setParentEmitterCoords(parentCoords);
        Random random = new Random();
        int index = random.nextInt(4);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(mistParticlesSprites[index].toString());
        this.func_187117_a(sprite);
    }

    @Override
    public void inflictEffectOnPlayer(EntityPlayer player) {
        if (WorldInfo.isServerSide((World)Minecraft.func_71410_x().field_71441_e)) {
            return;
        }
        PotionEffect potionEffect = player.func_70660_b(MobEffects.field_76436_u);
        if (potionEffect == null) {
            PoisonMistMessageToServer messageToServer = new PoisonMistMessageToServer(player.func_70005_c_());
            Treasure.simpleNetworkWrapper.sendToServer((IMessage)messageToServer);
        }
    }

    @Override
    public float provideAlpha() {
        return 0.4f;
    }

    static {
        PoisonMistParticle.mistParticlesSprites[0] = new ResourceLocation("treasure2", "particle/poison_mist_particle");
        PoisonMistParticle.mistParticlesSprites[1] = new ResourceLocation("treasure2", "particle/poison_mist_particle2");
        PoisonMistParticle.mistParticlesSprites[2] = new ResourceLocation("treasure2", "particle/poison_mist_particle3");
        PoisonMistParticle.mistParticlesSprites[3] = new ResourceLocation("treasure2", "particle/poison_mist_particle4");
    }
}

