/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.network;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PoisonMistMessageToServer
implements IMessage {
    private boolean messageIsValid;
    private String playerName;

    public PoisonMistMessageToServer(String playerName) {
        this.messageIsValid = true;
        this.playerName = playerName;
    }

    public PoisonMistMessageToServer() {
        this.messageIsValid = false;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Exception while reading PoisonMistMessageToServer: " + e);
            return;
        }
        this.messageIsValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageIsValid) {
            return;
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerName);
    }

    public boolean isMessageValid() {
        return this.playerName != null && !this.playerName.equals("");
    }

    public boolean isMessageIsValid() {
        return this.messageIsValid;
    }

    public void setMessageIsValid(boolean messageIsValid) {
        this.messageIsValid = messageIsValid;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerID(String playerName) {
        this.playerName = playerName;
    }
}

