/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.network;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.CharmCapabilityProvider;
import com.someguyssoftware.treasure2.capability.ICharmCapability;
import com.someguyssoftware.treasure2.capability.PouchCapabilityProvider;
import com.someguyssoftware.treasure2.item.charm.ICharmState;
import com.someguyssoftware.treasure2.network.CharmMessageToClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;

public class CharmMessageHandlerOnClient
implements IMessageHandler<CharmMessageToClient, IMessage> {
    public IMessage onMessage(final CharmMessageToClient message, MessageContext ctx) {
        if (ctx.side != Side.CLIENT) {
            Treasure.logger.error("CharmedItemMessageToClient received on wrong side -> {}", (Object)ctx.side);
            return null;
        }
        if (!message.isMessageValid()) {
            Treasure.logger.warn("CharmedItemMessageToClient was invalid -> {}", (Object)message.toString());
            return null;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        final WorldClient worldClient = minecraft.field_71441_e;
        minecraft.func_152344_a(new Runnable(){

            @Override
            public void run() {
                CharmMessageHandlerOnClient.this.processMessage(worldClient, message);
            }
        });
        return null;
    }

    void processMessage(WorldClient worldClient, CharmMessageToClient message) {
        try {
            ItemStack heldItemStack;
            EntityPlayer player = worldClient.func_72924_a(message.getPlayerName());
            if (player != null && message.getHand() != null && (heldItemStack = player.func_184586_b(message.getHand())) != null) {
                if (heldItemStack.hasCapability(PouchCapabilityProvider.INVENTORY_CAPABILITY, null)) {
                    if (message.getSlot() != null && message.getSlot() > -1) {
                        IItemHandler pouchCap = (IItemHandler)heldItemStack.getCapability(PouchCapabilityProvider.INVENTORY_CAPABILITY, null);
                        ItemStack charmedItemStack = pouchCap.getStackInSlot(message.getSlot().intValue());
                        this.updateCharms(charmedItemStack, message);
                    }
                } else if (heldItemStack.hasCapability(CharmCapabilityProvider.CHARM_CAPABILITY, null)) {
                    this.updateCharms(heldItemStack, message);
                }
            }
        }
        catch (Exception e) {
            Treasure.logger.error("Unexpected error ->", (Throwable)e);
        }
    }

    private void updateCharms(ItemStack heldItemStack, CharmMessageToClient message) {
        ICharmCapability heldItemCaps = (ICharmCapability)heldItemStack.getCapability(CharmCapabilityProvider.CHARM_CAPABILITY, null);
        String charmName = message.getCharmName();
        for (ICharmState state : heldItemCaps.getCharmStates()) {
            if (!state.getCharm().getName().equals(charmName)) continue;
            state.setVitals(message.getVitals());
        }
    }
}

