/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.lock;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.chest.ILockSlot;
import com.someguyssoftware.treasure2.item.LockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class LockState {
    private ILockSlot slot;
    private LockItem lockItem;

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        try {
            if (this.getSlot() != null) {
                NBTTagCompound slotNBT = new NBTTagCompound();
                slotNBT = this.getSlot().writeToNBT(slotNBT);
                nbt.func_74782_a("slot", (NBTBase)slotNBT);
            }
            if (this.getLock() != null) {
                NBTTagCompound lockNBT = new NBTTagCompound();
                new ItemStack((Item)this.getLock()).func_77955_b(lockNBT);
                nbt.func_74782_a("lockItem", (NBTBase)lockNBT);
            }
        }
        catch (Exception e) {
            Treasure.logger.error("Unable to write state to NBT:", (Throwable)e);
        }
        return nbt;
    }

    public static LockState readFromNBT(NBTTagCompound tag) {
        ILockSlot slot = null;
        ItemStack lockStack = null;
        NBTTagCompound slotNBT = null;
        if (tag.func_150297_b("slot", 10)) {
            slotNBT = tag.func_74775_l("slot");
            slot = ILockSlot.readFromNBT(slotNBT);
        }
        NBTTagCompound lockNBT = null;
        if (tag.func_150297_b("lockItem", 10) && (lockNBT = tag.func_74775_l("lockItem")) != null) {
            lockStack = new ItemStack(lockNBT);
        }
        LockState lockState = new LockState();
        if (slot != null) {
            lockState.setSlot(slot);
        }
        if (lockStack != null) {
            lockState.setLock((LockItem)lockStack.func_77973_b());
        }
        return lockState;
    }

    public ILockSlot getSlot() {
        return this.slot;
    }

    public void setSlot(ILockSlot slot) {
        this.slot = slot;
    }

    public LockItem getLock() {
        return this.lockItem;
    }

    public void setLock(LockItem lockItem) {
        this.lockItem = lockItem;
    }

    public String toString() {
        return "LockState [slot=" + this.slot + ", lockItem=" + (Object)((Object)this.lockItem) + "]";
    }
}

