/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item.charm;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.item.charm.Charm;
import com.someguyssoftware.treasure2.item.charm.ICharmBuilder;
import com.someguyssoftware.treasure2.item.charm.ICharmVitals;
import com.someguyssoftware.treasure2.item.charm.IlluminationCharmVitals;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;

public class IlluminationCharm
extends Charm {
    IlluminationCharm(ICharmBuilder builder) {
        super(builder);
    }

    @Override
    public boolean doCharm(World world, Random random, ICoords coords, EntityPlayer player, LivingEvent.LivingUpdateEvent event, ICharmVitals vitals) {
        boolean result = false;
        if (!player.field_70128_L && vitals.getValue() > 0.0 && world.func_82737_E() % 100L == 0L) {
            Coords currentCoords = new Coords((int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u), (int)Math.floor(player.field_70161_v));
            Cube cube = new Cube(world, (ICoords)currentCoords);
            if (!cube.isAir() && !cube.isReplaceable()) {
                return false;
            }
            cube = new Cube(world, currentCoords.down(1));
            if (!cube.isSolid()) {
                Treasure.logger.debug("not solid at -> {}", (Object)currentCoords.down(1));
                return false;
            }
            if (!(vitals instanceof IlluminationCharmVitals)) {
                return false;
            }
            IlluminationCharmVitals charmVitals = (IlluminationCharmVitals)vitals;
            List<ICoords> list = charmVitals.getCoordsList();
            double value = vitals.getValue();
            boolean isUpdated = false;
            if (list.isEmpty()) {
                list.add(0, (ICoords)currentCoords);
                isUpdated = true;
            } else {
                ICoords firstCoords = list.get(0);
                if (!currentCoords.equals((Object)firstCoords) && firstCoords.getDistanceSq((ICoords)currentCoords) >= 25.0) {
                    list.add(0, (ICoords)currentCoords);
                    if (list.size() > (int)charmVitals.getValue()) {
                        int diff = (int)((double)list.size() - charmVitals.getValue());
                        for (int index = 0; index < diff; ++index) {
                            ICoords lastCoords = list.get(list.size() - 1);
                            Block block = world.func_180495_p(lastCoords.toPos()).func_177230_c();
                            if (block == Blocks.field_150478_aa) {
                                world.func_175698_g(lastCoords.toPos());
                            } else {
                                value -= 1.0;
                            }
                            list.remove(lastCoords);
                        }
                    }
                    isUpdated = true;
                }
            }
            if (isUpdated) {
                world.func_175656_a(currentCoords.toPos(), Blocks.field_150478_aa.func_176223_P());
                if (value < 0.0) {
                    value = 0.0;
                }
                vitals.setValue(value);
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean doCharm(World world, Random random, ICoords coords, EntityPlayer player, LivingDamageEvent event, ICharmVitals vitals) {
        return false;
    }

    @Override
    public boolean doCharm(World world, Random random, ICoords coords, EntityPlayer player, BlockEvent.HarvestDropsEvent event, ICharmVitals vitals) {
        return false;
    }
}

