/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item.charm;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.item.charm.ICharm;
import com.someguyssoftware.treasure2.item.charm.ICharmState;
import com.someguyssoftware.treasure2.item.charm.ICharmVitals;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CharmState
implements ICharmState {
    private ICharm charm;
    private ICharmVitals vitals;

    public CharmState(ICharm charm, ICharmVitals vitals) {
        this.charm = charm;
        this.vitals = vitals;
    }

    @Override
    public boolean doCharm(World world, Random random, ICoords coords, EntityPlayer player, Event event) {
        if (event instanceof LivingEvent.LivingUpdateEvent) {
            return this.charm.doCharm(world, random, coords, player, (LivingEvent.LivingUpdateEvent)event, this.vitals);
        }
        if (event instanceof LivingDamageEvent) {
            return this.charm.doCharm(world, random, coords, player, (LivingDamageEvent)event, this.vitals);
        }
        return this.charm.doCharm(world, random, coords, player, (BlockEvent.HarvestDropsEvent)event, this.vitals);
    }

    @Override
    public boolean doCharm(World world, Random random, ICoords coords, EntityPlayer player, LivingEvent.LivingUpdateEvent event) {
        return this.charm.doCharm(world, random, coords, player, event, this.vitals);
    }

    @Override
    public boolean doCharm(World world, Random random, ICoords coords, EntityPlayer player, LivingDamageEvent event) {
        return this.charm.doCharm(world, random, coords, player, event, this.vitals);
    }

    @Override
    public boolean doCharm(World world, Random random, ICoords coords, EntityPlayer player, BlockEvent.HarvestDropsEvent event) {
        return this.charm.doCharm(world, random, coords, player, event, this.vitals);
    }

    @Deprecated
    private boolean checkVitals(ICharmVitals vitals, ICharmVitals newVitals) {
        if (vitals != null && newVitals != null && !vitals.equals(newVitals)) {
            this.vitals = newVitals;
            return true;
        }
        return false;
    }

    @Override
    public ICharm getCharm() {
        return this.charm;
    }

    @Override
    public void setCharm(ICharm charm) {
        this.charm = charm;
    }

    @Override
    public ICharmVitals getVitals() {
        return this.vitals;
    }

    @Override
    public void setVitals(ICharmVitals vitals) {
        this.vitals = vitals;
    }

    public String toString() {
        return "CharmState [charm=" + this.charm + ", vitals=" + this.vitals + "]";
    }
}

