/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.item.ModItem;
import com.someguyssoftware.gottschcore.loot.LootTable;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.IWishingWellBlock;
import com.someguyssoftware.treasure2.enums.Pearls;
import com.someguyssoftware.treasure2.item.IPouchable;
import com.someguyssoftware.treasure2.item.wish.IWishable;
import com.someguyssoftware.treasure2.loot.TreasureLootTableMaster;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class PearlItem
extends ModItem
implements IWishable,
IPouchable {
    public static final int MAX_STACK_SIZE = 8;
    private Pearls pearl;

    public PearlItem(String modID, String name) {
        this.setItemName(modID, name);
        this.func_77625_d(8);
        this.func_77637_a(Treasure.TREASURE_TAB);
        this.pearl = Pearls.WHITE;
    }

    public PearlItem(String modID, String name, Pearls pearl) {
        this(modID, name);
        this.setPearl(pearl);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"tooltip.label.coin"));
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        World world = entityItem.func_130014_f_();
        if (WorldInfo.isClientSide((World)world)) {
            return super.onEntityItemUpdate(entityItem);
        }
        Coords coords = new Coords(entityItem.func_180425_c());
        Cube cube = new Cube(world, (ICoords)coords);
        int numWishingWellBlocks = 0;
        if (cube.equalsBlock((Block)Blocks.field_150355_j)) {
            ICoords checkCoords = coords.add(-1, 0, -1);
            block0: for (int z = 0; z < 3; ++z) {
                for (int x = 0; x < 3; ++x) {
                    Cube checkCube = new Cube(world, checkCoords);
                    if (checkCube.toBlock() instanceof IWishingWellBlock) {
                        ++numWishingWellBlocks;
                    }
                    if (numWishingWellBlocks >= 2) continue block0;
                }
            }
            ArrayList<LootTable> lootTables = new ArrayList<LootTable>();
            if (numWishingWellBlocks >= 2) {
                Random random = new Random();
                if (this.getPearl() == Pearls.WHITE) {
                    lootTables.add(Treasure.LOOT_TABLES.getSpecialLootTable(TreasureLootTableMaster.SpecialLootTables.WHITE_PEARL_WELL));
                } else if (this.getPearl() == Pearls.BLACK) {
                    lootTables.add(Treasure.LOOT_TABLES.getSpecialLootTable(TreasureLootTableMaster.SpecialLootTables.BLACK_PEARL_WELL));
                }
                ItemStack stack = null;
                if (lootTables == null || lootTables.size() == 0) {
                    stack = new ItemStack(Items.field_151045_i);
                } else {
                    LootTable table = (LootTable)lootTables.get(RandomHelper.randomInt((Random)random, (int)0, (int)(lootTables.size() - 1)));
                    List list = table.generateLootFromPools(random, Treasure.LOOT_TABLES.getContext());
                    stack = (ItemStack)list.get(random.nextInt(list.size()));
                }
                if (stack != null) {
                    InventoryHelper.func_180173_a((World)world, (double)coords.getX(), (double)((double)coords.getY() + 1.0), (double)coords.getZ(), (ItemStack)stack);
                }
                entityItem.func_70106_y();
                return true;
            }
        }
        return super.onEntityItemUpdate(entityItem);
    }

    public Pearls getPearl() {
        return this.pearl;
    }

    public PearlItem setPearl(Pearls pearl) {
        this.pearl = pearl;
        return this;
    }
}

