/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.chest;

import com.someguyssoftware.gottschcore.loot.LootTable;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.block.TreasureChestBlock;
import com.someguyssoftware.treasure2.chest.TreasureChestType;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.generator.chest.IChestGenerator;
import com.someguyssoftware.treasure2.item.LockItem;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.loot.TreasureLootTableMaster;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import java.util.ArrayList;
import java.util.Random;

public class SkullChestGenerator
implements IChestGenerator {
    @Override
    public LootTable selectLootTable(Random random, Rarity chestRarity) {
        return Treasure.LOOT_TABLES.getSpecialLootTable(TreasureLootTableMaster.SpecialLootTables.SKULL_CHEST);
    }

    @Override
    public TreasureChestBlock selectChest(Random random, Rarity rarity) {
        TreasureChestBlock chest = (TreasureChestBlock)TreasureBlocks.SKULL_CHEST;
        return chest;
    }

    @Override
    public int randomizedNumberOfLocksByChestType(Random random, TreasureChestType type) {
        int numLocks = RandomHelper.randomInt((Random)random, (int)1, (int)type.getMaxLocks());
        Treasure.logger.debug("# of locks to use: {})", (Object)numLocks);
        return numLocks;
    }

    @Override
    public void addLocks(Random random, AbstractChestBlock chest, AbstractTreasureChestTileEntity te, Rarity rarity) {
        ArrayList<LockItem> locks = new ArrayList<LockItem>();
        locks.addAll(TreasureItems.locks.get((Object)Rarity.UNCOMMON));
        locks.addAll(TreasureItems.locks.get((Object)Rarity.SCARCE));
        this.addLocks(random, chest, te, locks);
        locks.clear();
    }
}

