/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.enums;

import com.someguyssoftware.gottschcore.enums.IEnum;
import com.someguyssoftware.gottschcore.enums.IRarity;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum Rarity implements IRarity
{
    COMMON(0, "common"),
    UNCOMMON(1, "uncommon"),
    SCARCE(2, "scarce"),
    RARE(3, "rare"),
    EPIC(4, "epic");

    private static final Map<Integer, IEnum> codes;
    private static final Map<String, IEnum> values;
    private Integer code;
    private String value;

    private Rarity(int code, String value) {
        this.value = value;
    }

    public String getName() {
        return this.name();
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static Rarity getByCode(Integer code) {
        return (Rarity)codes.get(code);
    }

    public static Rarity getByValue(String value) {
        return (Rarity)values.get(value);
    }

    public Map<Integer, IEnum> getCodes() {
        return codes;
    }

    public Map<String, IEnum> getValues() {
        return values;
    }

    public static List<String> getNames() {
        List<String> names = EnumSet.allOf(Rarity.class).stream().map(x -> x.name()).collect(Collectors.toList());
        return names;
    }

    static {
        codes = new HashMap<Integer, IEnum>();
        values = new HashMap<String, IEnum>();
        for (Rarity type : EnumSet.allOf(Rarity.class)) {
            codes.put(type.getCode(), (IEnum)type);
            values.put(type.getValue(), (IEnum)type);
        }
    }
}

