/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.config;

import com.someguyssoftware.gottschcore.biome.BiomeTypeHolder;
import com.someguyssoftware.treasure2.config.BiomesConfig;
import com.someguyssoftware.treasure2.config.IOasisConfig;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Config;

public class OasisConfig
implements IOasisConfig {
    @Config.Comment(value={"Toggle to allow/disallow the spawn of oasis."})
    @Config.Name(value="01. Enabled oasis:")
    public boolean enableOasis = true;
    @Config.Comment(value={"The minimum number of chunks generated before another attempt to spawn the oasis is made.", "Note: this value is per biome."})
    @Config.Name(value="02. Chunks per oasis spawn:")
    @Config.RangeInt(min=100, max=32000)
    public int chunksPerOasis = 200;
    @Config.Comment(value={"The probability that the oasis will generate."})
    @Config.Name(value="03. Generation probability:")
    @Config.RangeDouble(min=0.0, max=100.0)
    public double genProbability = 80.0;
    @Config.Comment(value={"The number of trees per chunk (16x16 blocks) in an oasis."})
    @Config.Name(value="04. Trees per chunk:")
    @Config.RangeInt(min=0, max=256)
    public int treesPerChunk = 15;
    @Config.Comment(value={"The rate at which the number of trees per chunk grows with the size of the oasis."})
    @Config.Name(value="05. Trees per chunk size factor:")
    @Config.RangeDouble(min=0.0, max=5.0)
    public double treesPerChunkSizeFactor = 1.3;
    @Config.Name(value="biomes")
    @Config.Comment(value={"Biome white and black list properties."})
    public BiomesConfig biomes = new BiomesConfig(new String[0], new String[0], new String[0], new String[0]);

    public OasisConfig(boolean isAllowed, int chunksPer, double probability, String[] whiteList, String[] blackList, String[] typeWhiteList, String[] typeBlackList) {
        this.enableOasis = isAllowed;
        this.chunksPerOasis = chunksPer;
        this.genProbability = probability;
        this.biomes = new BiomesConfig(whiteList, blackList, typeWhiteList, typeBlackList);
    }

    @Override
    public void init() {
        this.biomes.init();
    }

    @Override
    public boolean isEnableOasis() {
        return this.enableOasis;
    }

    @Override
    public int getChunksPerOasis() {
        return this.chunksPerOasis;
    }

    @Override
    public double getGenProbability() {
        return this.genProbability;
    }

    @Override
    public List<BiomeTypeHolder> getBiomeTypeWhiteList() {
        return this.biomes.getTypeWhiteList();
    }

    @Override
    public List<BiomeTypeHolder> getBiomeTypeBlackList() {
        return this.biomes.getTypeBlackList();
    }

    @Override
    public List<Biome> getBiomeWhiteList() {
        return this.biomes.getWhiteList();
    }

    @Override
    public List<Biome> getBiomeBlackList() {
        return this.biomes.getBlackList();
    }

    @Override
    public int getTreesPerChunk() {
        return this.treesPerChunk;
    }

    @Override
    public void setTreesPerChunk(int treesPerChunk) {
        this.treesPerChunk = treesPerChunk;
    }

    @Override
    public double getTreesPerChunkSizeFactor() {
        return this.treesPerChunkSizeFactor;
    }

    @Override
    public void setTreesPerChunkSizeFactor(double treesPerChunkSizeFactor) {
        this.treesPerChunkSizeFactor = treesPerChunkSizeFactor;
    }
}

