/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.client.render.tileentity;

import com.someguyssoftware.treasure2.client.model.CauldronChestModel;
import com.someguyssoftware.treasure2.client.model.ITreasureChestModel;
import com.someguyssoftware.treasure2.client.render.tileentity.TreasureChestTileEntityRenderer;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import com.someguyssoftware.treasure2.tileentity.CauldronChestTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CauldronChestTileEntityRenderer
extends TreasureChestTileEntityRenderer {
    public CauldronChestTileEntityRenderer(String texture, ITreasureChestModel model) {
        super(texture, model);
    }

    @Override
    public void render(AbstractTreasureChestTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!(te instanceof CauldronChestTileEntity)) {
            return;
        }
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        }
        CauldronChestModel model = (CauldronChestModel)this.getModel();
        this.func_147499_a(this.getTexture());
        int meta = 0;
        if (te.func_145830_o()) {
            meta = te.func_145832_p();
        }
        int rotation = this.getRotation(meta);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        CauldronChestTileEntity cte = (CauldronChestTileEntity)te;
        float lidRotation = cte.prevLidAngle + (cte.lidAngle - cte.prevLidAngle) * partialTicks;
        lidRotation = 1.0f - lidRotation;
        lidRotation = 1.0f - lidRotation * lidRotation * lidRotation;
        model.getLid().field_78808_h = lidRotation * (float)Math.PI / this.getAngleModifier();
        model.renderAll(te);
        GlStateManager.func_179121_F();
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
        if (!te.getLockStates().isEmpty()) {
            this.renderLocks(te, x, y, z);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void renderLocks(AbstractTreasureChestTileEntity te, double x, double y, double z) {
        int meta = 0;
        if (te.func_145830_o()) {
            meta = te.func_145832_p();
        }
        int rotation = this.getRotation(meta);
        for (LockState lockState : te.getLockStates()) {
            if (lockState.getLock() == null) continue;
            ItemStack lockStack = new ItemStack((Item)lockState.getLock());
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x + lockState.getSlot().getXOffset()), (float)((float)y + lockState.getSlot().getYOffset()), (float)((float)z + lockState.getSlot().getZOffset()));
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)lockState.getSlot().getRotation(), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)0.35f, (float)0.35f, (float)0.35f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(lockStack, ItemCameraTransforms.TransformType.NONE);
            GlStateManager.func_179121_F();
        }
    }
}

