/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.capability;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.ICharmCapability;
import com.someguyssoftware.treasure2.item.charm.Charm;
import com.someguyssoftware.treasure2.item.charm.CharmStateFactory;
import com.someguyssoftware.treasure2.item.charm.ICharm;
import com.someguyssoftware.treasure2.item.charm.ICharmState;
import com.someguyssoftware.treasure2.item.charm.ICharmVitals;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class CharmStorage
implements Capability.IStorage<ICharmCapability> {
    public NBTBase writeNBT(Capability<ICharmCapability> capability, ICharmCapability instance, EnumFacing side) {
        NBTTagCompound mainTag = new NBTTagCompound();
        try {
            if (instance.getCharmStates() != null) {
                NBTTagList stateTags = new NBTTagList();
                for (ICharmState state : instance.getCharmStates()) {
                    NBTTagCompound stateTag = new NBTTagCompound();
                    NBTTagCompound charmTag = new NBTTagCompound();
                    ICharm charm = state.getCharm();
                    charm.writeToNBT(charmTag);
                    stateTag.func_74782_a("charm", (NBTBase)charmTag);
                    NBTTagCompound vitalsTag = new NBTTagCompound();
                    ICharmVitals vitals = state.getVitals();
                    vitals.writeToNBT(vitalsTag);
                    stateTag.func_74782_a("vitals", (NBTBase)vitalsTag);
                    stateTags.func_74742_a((NBTBase)stateTag);
                }
                mainTag.func_82580_o("charmStates");
                mainTag.func_74782_a("charmStates", (NBTBase)stateTags);
                mainTag.func_74780_a("valueModifier", instance.getCharmValueModifier());
                mainTag.func_74780_a("percentModifier", instance.getCharmPercentModifier());
            }
        }
        catch (Exception e) {
            Treasure.logger.error("Unable to write state to NBT:", (Throwable)e);
        }
        return mainTag;
    }

    public void readNBT(Capability<ICharmCapability> capability, ICharmCapability instance, EnumFacing side, NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            instance.getCharmStates().clear();
            NBTTagCompound tag = (NBTTagCompound)nbt;
            NBTTagList stateListTag = tag.func_150295_c("charmStates", 10);
            for (int index = 0; index < stateListTag.func_74745_c(); ++index) {
                NBTTagCompound stateTag = stateListTag.func_150305_b(index);
                ICharm charm = Charm.readFromNBT(stateTag.func_74775_l("charm"));
                ICharmVitals vitals = CharmStateFactory.createCharmVitals(charm);
                vitals.readFromNBT(stateTag.func_74775_l("vitals"));
                ICharmState charmState = CharmStateFactory.createCharmState(charm, vitals);
                instance.getCharmStates().add(charmState);
            }
            if (tag.func_74764_b("valueModifier")) {
                instance.setCharmValueModifier(tag.func_74769_h("valueModifier"));
            }
            if (tag.func_74764_b("percentModifier")) {
                instance.setCharmPercentModifier(tag.func_74769_h("percentModifier"));
            }
        } else {
            Treasure.logger.warn("Not a tag compound!");
        }
    }
}

