/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.block;

import com.someguyssoftware.gottschcore.block.CardinalDirectionFacadeBlock;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.FogBlock;
import com.someguyssoftware.treasure2.block.IMistSupport;
import com.someguyssoftware.treasure2.block.ITreasureBlock;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.particle.AbstractMistParticle;
import com.someguyssoftware.treasure2.particle.PoisonMistParticle;
import com.someguyssoftware.treasure2.particle.WitherMistParticle;
import com.someguyssoftware.treasure2.tileentity.MistEmitterTileEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WitherLogSoulBlock
extends CardinalDirectionFacadeBlock
implements IMistSupport,
ITreasureBlock,
ITileEntityProvider {
    public static final PropertyEnum<Appearance> APPEARANCE = PropertyEnum.func_177709_a((String)"appearance", Appearance.class);
    AxisAlignedBB[] bounds = new AxisAlignedBB[4];

    public WitherLogSoulBlock(String modID, String name) {
        super(modID, name, Material.field_151575_d);
        this.setSoundType(SoundType.field_185848_a);
        this.func_149647_a(Treasure.TREASURE_TAB);
        this.func_149711_c(3.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(APPEARANCE, (Comparable)((Object)Appearance.NONE)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, APPEARANCE});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new MistEmitterTileEntity();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        int z;
        int y;
        int x = pos.func_177958_n();
        if (worldIn.func_175707_a(new BlockPos(x - 5, (y = pos.func_177956_o()) - 5, (z = pos.func_177952_p()) - 5), new BlockPos(x + 5, y + 5, z + 5))) {
            BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos();
            for (int x1 = -5; x1 <= 5; ++x1) {
                for (int y1 = -5; y1 <= 5; ++y1) {
                    for (int z1 = -5; z1 <= 5; ++z1) {
                        IBlockState inspectBlockState = worldIn.func_180495_p((BlockPos)mbp.func_181079_c(x + x1, y + y1, z + z1));
                        if (inspectBlockState.func_185904_a() != TreasureItems.FOG) continue;
                        worldIn.func_175656_a((BlockPos)mbp, inspectBlockState.func_177226_a((IProperty)FogBlock.CHECK_DECAY, (Comparable)Boolean.valueOf(true)));
                    }
                }
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        int z;
        int y;
        if (WorldInfo.isServerSide((World)world)) {
            return;
        }
        if (!TreasureConfig.WORLD_GEN.getGeneralProperties().enablePoisonFog) {
            return;
        }
        Appearance appearance = (Appearance)((Object)state.func_177229_b(APPEARANCE));
        int x = pos.func_177958_n();
        boolean isCreateParticle = this.checkTorchPrevention(world, random, x, y = pos.func_177956_o(), z = pos.func_177952_p());
        if (!isCreateParticle) {
            return;
        }
        double xPos = 0.0;
        double yPos = y;
        double zPos = 0.0;
        if (appearance == Appearance.FACE) {
            double xOffset = (double)random.nextFloat() * 5.0 - 2.5;
            double zOffset = (double)random.nextFloat() * 5.0 - 2.5;
            if (xOffset > 0.0 && (zOffset < 0.5 || zOffset > -1.5)) {
                xOffset = Math.max(1.5, xOffset);
            } else if (xOffset < 0.0 && (zOffset < 0.5 || zOffset > -1.5)) {
                xOffset = Math.min(-0.5, xOffset);
            }
            xPos = (double)x + 0.5 + xOffset;
            zPos = (double)z + 0.5 + zOffset;
            yPos = (double)y - 1.875;
        } else {
            xPos = (double)x + 0.5 + (double)random.nextFloat() * 5.0 - 2.5;
            zPos = (double)z + 0.5 + (double)random.nextFloat() * 5.0 - 2.5;
        }
        double velocityX = 0.0;
        double velocityY = 0.0;
        double velocityZ = 0.0;
        AbstractMistParticle mistParticle = null;
        mistParticle = appearance == Appearance.FACE ? new WitherMistParticle(world, xPos, yPos, zPos, velocityX, velocityY, velocityZ, (ICoords)new Coords(pos)) : new PoisonMistParticle(world, xPos, yPos, zPos, velocityX, velocityY, velocityZ, (ICoords)new Coords(pos));
        mistParticle.init();
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)mistParticle);
    }

    public boolean canSustainFog(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = super.func_176203_a(meta & 7);
        state = state.func_177226_a(APPEARANCE, (Comparable)((Object)((meta & 8) == 0 ? Appearance.NONE : Appearance.FACE)));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int facingBits = 0;
        facingBits = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        facingBits = facingBits == -1 ? 2 : facingBits;
        int appearanceBits = ((Appearance)((Object)state.func_177229_b(APPEARANCE))).getValue() == 0 ? 0 : 8;
        return facingBits + appearanceBits;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        if (RandomHelper.checkProbability((Random)random, (double)TreasureConfig.WITHER_TREE.witherRootItemGenProbability)) {
            return TreasureItems.WITHER_ROOT_ITEM;
        }
        return Items.field_151055_y;
    }

    public AxisAlignedBB[] getBounds() {
        return this.bounds;
    }

    public void setBounds(AxisAlignedBB[] bounds) {
        this.bounds = bounds;
    }

    public static enum Appearance implements IStringSerializable
    {
        NONE("none", 0),
        FACE("face", 1);

        private final String name;
        private final int value;

        private Appearance(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }
    }
}

