/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.block;

import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.chest.TreasureChestType;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.printer.ChestNBTPrettyPrinter;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TreasureChestBlock
extends AbstractChestBlock {
    private int chestGuiID = 1;

    public TreasureChestBlock(String modID, String name, Class<? extends AbstractTreasureChestTileEntity> te, TreasureChestType type, Rarity rarity) {
        this(modID, name, Material.field_151575_d, te, type, rarity);
    }

    public TreasureChestBlock(String modID, String name, Material material, Class<? extends AbstractTreasureChestTileEntity> te, TreasureChestType type, Rarity rarity) {
        super(modID, name, material, te, type, rarity);
    }

    private TreasureChestBlock(String modID, String name, Material material) {
        super(modID, name, material);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        Treasure.logger.debug("Placing chest from item");
        boolean shouldRotate = false;
        boolean shouldUpdate = false;
        boolean forceUpdate = false;
        AbstractTreasureChestTileEntity tcte = null;
        Direction oldPersistedChestDirection = Direction.NORTH;
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 3);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof AbstractTreasureChestTileEntity) {
            tcte = (AbstractTreasureChestTileEntity)te;
            if (stack.func_82837_s()) {
                tcte.setCustomName(stack.func_82833_r());
            }
            if (stack.func_77942_o()) {
                tcte.readFromItemStackNBT(stack.func_77978_p());
                forceUpdate = true;
                oldPersistedChestDirection = Direction.fromFacing((EnumFacing)EnumFacing.func_82600_a((int)tcte.getFacing()));
                if (Treasure.logger.isDebugEnabled()) {
                    this.dump(stack.func_77978_p(), (ICoords)new Coords(pos), "STACK ITEM -> CHEST NBT");
                }
            }
            Direction direction = Direction.fromFacing((EnumFacing)placer.func_174811_aO().func_176734_d());
            shouldUpdate = this.rotateLockStates(worldIn, pos, oldPersistedChestDirection.getRotation(direction));
            tcte.setFacing(placer.func_174811_aO().func_176734_d().func_176745_a());
        }
        if ((forceUpdate || shouldUpdate) && tcte != null) {
            tcte.sendUpdates();
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        AbstractTreasureChestTileEntity te = (AbstractTreasureChestTileEntity)worldIn.func_175625_s(pos);
        if (WorldInfo.isClientSide((World)worldIn)) {
            return true;
        }
        boolean isLocked = false;
        if (te.hasLocks()) {
            isLocked = true;
        }
        if (!isLocked) {
            playerIn.openGui((Object)Treasure.instance, this.getChestGuiID(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        Treasure.logger.debug("Breaking block....!");
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        AbstractTreasureChestTileEntity te = null;
        if (tileEntity instanceof AbstractTreasureChestTileEntity) {
            te = (AbstractTreasureChestTileEntity)tileEntity;
        }
        if (te != null) {
            if (!te.hasLocks()) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)te);
                ItemStack chestItem = new ItemStack(Item.func_150898_a((Block)this), 1);
                Treasure.logger.debug("Item being created from chest -> {}", (Object)chestItem.func_77973_b().getRegistryName());
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)chestItem);
                if (!chestItem.func_77942_o()) {
                    chestItem.func_77982_d(new NBTTagCompound());
                }
                te.writePropertiesToNBT(chestItem.func_77978_p());
            } else {
                Treasure.logger.debug("[BreakingBlock] ChestConfig is locked, save locks and items to NBT");
                if (WorldInfo.isServerSide((World)worldIn)) {
                    ItemStack chestItem = new ItemStack(Item.func_150898_a((Block)this), 1);
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt = te.func_189515_b(nbt);
                    chestItem.func_77982_d(nbt);
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)chestItem);
                }
            }
            worldIn.func_175713_t(pos);
        } else {
            super.func_180663_b(worldIn, pos, state);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    private void dump(NBTTagCompound tag, ICoords coords, String title) {
        ChestNBTPrettyPrinter printer = new ChestNBTPrettyPrinter();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyymmdd");
        String filename = String.format("chest-nbt-%s-%s.txt", formatter.format(new Date()), coords.toShortString().replaceAll(" ", "-"));
        Path path = Paths.get(TreasureConfig.LOGGING.folder, "dumps").toAbsolutePath();
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            Treasure.logger.error("Couldn't create directories for dump files:", (Throwable)e);
            return;
        }
        String s = printer.print(tag, Paths.get(path.toString(), filename), title);
        Treasure.logger.debug(s);
    }

    public int getChestGuiID() {
        return this.chestGuiID;
    }

    public TreasureChestBlock setChestGuiID(int chestGuiID) {
        this.chestGuiID = chestGuiID;
        return this;
    }
}

