/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.block;

import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.block.SkullAndBonesBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SkeletonBlock
extends SkullAndBonesBlock {
    public static final PropertyEnum<EnumPartType> PART = PropertyEnum.func_177709_a((String)"part", EnumPartType.class);

    public SkeletonBlock(String modID, String name, Material material) {
        super(modID, name, material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PART, (Comparable)((Object)EnumPartType.BOTTOM)));
        this.bounds[0] = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
        this.bounds[1] = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
        this.bounds[2] = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
        this.bounds[3] = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, PART});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (state.func_177229_b(PART) == EnumPartType.BOTTOM) {
            if (worldIn.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            }
        } else if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this) {
            if (WorldInfo.isServerSide((World)worldIn)) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
            worldIn.func_175698_g(pos);
        }
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177229_b(PART) == EnumPartType.BOTTOM) {
            return Items.field_190931_a;
        }
        int value = rand.nextInt(100);
        if (value < 5) {
            return Items.field_151144_bL;
        }
        if (value >= 5 && value < 25) {
            return Item.func_150898_a((Block)this);
        }
        return Items.field_151103_aS;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos;
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(PART) == EnumPartType.BOTTOM && worldIn.func_180495_p(blockpos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING))).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState blockState = super.func_176203_a(meta);
        return (meta & 8) > 0 ? blockState.func_177226_a(PART, (Comparable)((Object)EnumPartType.TOP)) : blockState.func_177226_a(PART, (Comparable)((Object)EnumPartType.BOTTOM));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= super.func_176201_c(state);
        if (state.func_177229_b(PART) == EnumPartType.TOP) {
            i |= 8;
        }
        return i;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static enum EnumPartType implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private EnumPartType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

