/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.block;

import com.someguyssoftware.gottschcore.block.AbstractModContainerBlock;
import com.someguyssoftware.gottschcore.enums.Rotate;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.ITreasureBlock;
import com.someguyssoftware.treasure2.chest.ILockSlot;
import com.someguyssoftware.treasure2.chest.TreasureChestType;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractChestBlock
extends AbstractModContainerBlock
implements ITreasureBlock {
    public static final PropertyEnum<EnumFacing> FACING = PropertyDirection.func_177709_a((String)"facing", EnumFacing.class);
    private Class<?> tileEntityClass;
    private AbstractTreasureChestTileEntity tileEntity;
    private TreasureChestType chestType;
    private Rarity rarity;
    private AxisAlignedBB[] bounds = new AxisAlignedBB[4];

    public AbstractChestBlock(String modID, String name, Material material, Class<? extends AbstractTreasureChestTileEntity> te, TreasureChestType type, Rarity rarity) {
        this(modID, name, material);
        this.setTileEntityClass(te);
        this.setChestType(type);
        this.setRarity(rarity);
        this.func_149647_a(Treasure.TREASURE_TAB);
        this.setBounds(new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)});
        try {
            this.setTileEntity((AbstractTreasureChestTileEntity)((Object)this.getTileEntityClass().newInstance()));
        }
        catch (Exception e) {
            Treasure.logger.warn("Unable to create reference AbstractTreasureChestTileEntity object.");
        }
    }

    protected AbstractChestBlock(String modID, String name, Material material) {
        super(modID, name, material);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        AbstractTreasureChestTileEntity chestTileEntity = null;
        try {
            chestTileEntity = (AbstractTreasureChestTileEntity)((Object)this.getTileEntityClass().newInstance());
            LinkedList<LockState> lockStates = new LinkedList<LockState>();
            for (int i = 0; i < this.chestType.getSlots().length; ++i) {
                LockState lockState = new LockState();
                lockState.setSlot(this.chestType.getSlots()[i]);
                lockStates.add(lockState.getSlot().getIndex(), lockState);
            }
            chestTileEntity.setLockStates(lockStates);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return chestTileEntity;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState iBlockState) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean rotateLockStates(World world, BlockPos pos, Rotate rotate) {
        boolean hasRotated = false;
        boolean shouldRotate = false;
        if (rotate != Rotate.NO_ROTATE) {
            shouldRotate = true;
        }
        AbstractTreasureChestTileEntity tcte = null;
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof AbstractTreasureChestTileEntity)) {
            return false;
        }
        tcte = (AbstractTreasureChestTileEntity)te;
        try {
            for (LockState lockState : tcte.getLockStates()) {
                if (lockState == null || lockState.getSlot() == null || !shouldRotate) continue;
                ILockSlot newSlot = lockState.getSlot().rotate(rotate);
                lockState.setSlot(newSlot);
                hasRotated = true;
            }
        }
        catch (Exception e) {
            Treasure.logger.error("Error updating lock states: ", (Throwable)e);
        }
        return hasRotated;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(FACING) == EnumFacing.NORTH) {
            return this.bounds[EnumFacing.NORTH.func_176736_b()];
        }
        if (state.func_177229_b(FACING) == EnumFacing.SOUTH) {
            return this.bounds[EnumFacing.SOUTH.func_176736_b()];
        }
        if (state.func_177229_b(FACING) == EnumFacing.EAST) {
            return this.bounds[EnumFacing.EAST.func_176736_b()];
        }
        if (state.func_177229_b(FACING) == EnumFacing.WEST) {
            return this.bounds[EnumFacing.WEST.func_176736_b()];
        }
        return this.bounds[EnumFacing.NORTH.func_176736_b()];
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a(FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a(FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b(FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b(FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public Class<?> getTileEntityClass() {
        return this.tileEntityClass;
    }

    public void setTileEntityClass(Class<?> tileEntityClass) {
        this.tileEntityClass = tileEntityClass;
    }

    public AbstractTreasureChestTileEntity getTileEntity() {
        return this.tileEntity;
    }

    public AbstractChestBlock setTileEntity(AbstractTreasureChestTileEntity tileEntity) {
        this.tileEntity = tileEntity;
        return this;
    }

    public TreasureChestType getChestType() {
        return this.chestType;
    }

    public AbstractChestBlock setChestType(TreasureChestType chestType) {
        this.chestType = chestType;
        return this;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public AbstractChestBlock setRarity(Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public AxisAlignedBB[] getBounds() {
        return this.bounds;
    }

    public AbstractChestBlock setBounds(AxisAlignedBB[] bounds) {
        this.bounds = bounds;
        return this;
    }
}

