/*
 * Decompiled with CFR 0.152.
 */
package panda.torchlever;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTorchLever
extends Block {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(@Nullable EnumFacing facing) {
            return facing != EnumFacing.DOWN;
        }
    });
    protected static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB((double)0.4f, 0.0, (double)0.4f, (double)0.6f, (double)0.6f, (double)0.6f);
    protected static final AxisAlignedBB TORCH_NORTH_AABB = new AxisAlignedBB((double)0.35f, (double)0.2f, (double)0.7f, (double)0.65f, (double)0.8f, 1.0);
    protected static final AxisAlignedBB TORCH_SOUTH_AABB = new AxisAlignedBB((double)0.35f, (double)0.2f, 0.0, (double)0.65f, (double)0.8f, (double)0.3f);
    protected static final AxisAlignedBB TORCH_WEST_AABB = new AxisAlignedBB((double)0.7f, (double)0.2f, (double)0.35f, 1.0, (double)0.8f, (double)0.65f);
    protected static final AxisAlignedBB TORCH_EAST_AABB = new AxisAlignedBB(0.0, (double)0.2f, (double)0.35f, (double)0.3f, (double)0.8f, (double)0.65f);

    public BlockTorchLever() {
        super(Material.field_151594_q);
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149715_a(0.9375f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(CreativeTabs.field_78028_d);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.7;
        double d2 = (double)pos.func_177952_p() + 0.5;
        if (((Boolean)stateIn.func_177229_b((IProperty)POWERED)).booleanValue()) {
            if (enumfacing.func_176740_k().func_176722_c()) {
                EnumFacing enumfacing1 = enumfacing.func_176734_d();
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.085 * (double)enumfacing1.func_82601_c(), d1 + 0.07, d2 + 0.085 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.085 * (double)enumfacing1.func_82601_c(), d1 + 0.07, d2 + 0.085 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            } else {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1 - 0.1875, d2, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1 - 0.1875, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (enumfacing.func_176740_k().func_176722_c()) {
            EnumFacing enumfacing1 = enumfacing.func_176734_d();
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.27 * (double)enumfacing1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.27 * (double)enumfacing1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
        } else {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return TORCH_EAST_AABB;
            }
            case WEST: {
                return TORCH_WEST_AABB;
            }
            case SOUTH: {
                return TORCH_SOUTH_AABB;
            }
            case NORTH: {
                return TORCH_NORTH_AABB;
            }
        }
        return STANDING_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return BlockTorchLever.canAttachTo(worldIn, pos, side);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockTorchLever.canAttachTo(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canAttachTo(World worldIn, BlockPos pos, EnumFacing facing) {
        return BlockTorchLever.canPlaceBlock(worldIn, pos, facing);
    }

    protected static boolean canPlaceBlock(World worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        boolean flag = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, direction) == BlockFaceShape.SOLID;
        Block block = iblockstate.func_177230_c();
        if (direction == EnumFacing.DOWN) {
            return false;
        }
        if (direction == EnumFacing.UP) {
            return iblockstate.func_185896_q() || !BlockTorchLever.func_193384_b((Block)block) && flag;
        }
        return !BlockTorchLever.func_193382_c((Block)block) && flag;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (facing == EnumFacing.DOWN) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (BlockTorchLever.canAttachTo(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!BlockTorchLever.canAttachTo(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.checkCanSurvive(worldIn, pos, state) && !BlockTorchLever.canAttachTo(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private boolean checkCanSurvive(World worldIn, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(worldIn, pos)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        state = state.func_177231_a((IProperty)POWERED);
        worldIn.func_180501_a(pos, state, 3);
        float f = (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 0.3f : 0.1f;
        worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
        worldIn.func_175685_c(pos, (Block)this, false);
        worldIn.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d()), (Block)this, false);
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            worldIn.func_175685_c(pos, (Block)this, false);
            worldIn.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d()), (Block)this, false);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 0;
        }
        return blockState.func_177229_b((IProperty)FACING) == side ? 15 : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta % 5 + 1))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta < 5));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() - 1;
        return i + ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 0 : 5);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

