/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.common;

import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import net.minecraft.util.ResourceLocation;

public class ResourceManager {
    private static final String PARENT_PATH = "assets/";

    public static URL getResourceURL(ResourceLocation resourceLocation) {
        return ResourceManager.class.getClassLoader().getResource(ResourceManager.toPathString(resourceLocation));
    }

    public static InputStream getResourceStream(ResourceLocation resourceLocation) {
        return ResourceManager.class.getClassLoader().getResourceAsStream(ResourceManager.toPathString(resourceLocation));
    }

    public static CharSource getResourceAsCharSource(ResourceLocation resourceLocation) {
        return ResourceManager.getResourceAsCharSource(resourceLocation, Charsets.UTF_8);
    }

    public static CharSource getResourceAsCharSource(ResourceLocation resourceLocation, Charset charset) {
        URL resourceURL = ResourceManager.getResourceURL(resourceLocation);
        return resourceURL != null ? Resources.asCharSource((URL)resourceURL, (Charset)charset) : null;
    }

    private static String toPathString(ResourceLocation resourceLocation) {
        return PARENT_PATH + resourceLocation.func_110624_b() + "/" + resourceLocation.func_110623_a();
    }
}

