/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.auxiliary;

import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public enum DirectionTetra implements IStringSerializable
{
    NORTH(0, 2, "north", 0, -1),
    EAST(1, 3, "east", 1, 0),
    SOUTH(2, 0, "south", 0, 1),
    WEST(3, 1, "west", -1, 0);

    private static final DirectionTetra[] LOOKUP;
    private final String name;
    private final int index;
    private final int indexOfOpposite;
    private final int offsetX;
    private final int offsetZ;

    private DirectionTetra(int index, int indexOfOpposite, String name, int offsetX, int offsetZ) {
        this.indexOfOpposite = indexOfOpposite;
        this.index = index;
        this.name = name;
        this.offsetX = offsetX;
        this.offsetZ = offsetZ;
    }

    public static DirectionTetra byIndex(int index) {
        if (index < 0 || index >= DirectionTetra.values().length) {
            return null;
        }
        return LOOKUP[index];
    }

    public DirectionTetra getOpposite() {
        return DirectionTetra.byIndex(this.indexOfOpposite);
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    public BlockPos getOffsetBlockPos(BlockPos center) {
        return center.func_177982_a(this.getOffsetX(), 0, this.getOffsetZ());
    }

    @NotNull
    public String func_176610_l() {
        return this.name;
    }

    public String toString() {
        return "DirectionTetra{name='" + this.name + '\'' + '}';
    }

    static {
        LOOKUP = new DirectionTetra[DirectionTetra.values().length];
        DirectionTetra[] directionTetraArray = DirectionTetra.values();
        int n = directionTetraArray.length;
        for (int i = 0; i < n; ++i) {
            DirectionTetra value;
            DirectionTetra.LOOKUP[value.index] = value = directionTetraArray[i];
        }
    }
}

