/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome.spawning.spawners;

import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.common.world.biome.spawning.AreaMobSpawner;

public class SkySpawnEntry
extends AreaMobSpawner.BLSpawnEntry {
    public SkySpawnEntry(int id, Class<? extends EntityLiving> entityType, Function<World, ? extends EntityLiving> entityCtor) {
        super(id, entityType, entityCtor);
    }

    public SkySpawnEntry(int id, Class<? extends EntityLiving> entityType, Function<World, ? extends EntityLiving> entityCtor, short weight) {
        super(id, entityType, entityCtor, weight);
    }

    @Override
    public void update(World world, BlockPos pos) {
        int skyHeight = 150;
        short spawnWeight = this.getBaseWeight();
        if (pos.func_177956_o() < skyHeight) {
            spawnWeight = 0;
        } else {
            float weightPercent = MathHelper.func_76131_a((float)((float)(pos.func_177956_o() - skyHeight) / 16.0f), (float)0.0f, (float)1.0f);
            float closestDistanceSq = Float.MAX_VALUE;
            for (EntityPlayer player : world.field_73010_i) {
                if (player.func_175149_v()) continue;
                float dstSq = (float)player.func_70092_e((double)((float)pos.func_177958_n() + 0.5f), player.field_70163_u, (double)((float)pos.func_177952_p() + 0.5f));
                float dy = Math.max((float)skyHeight, (float)player.field_70163_u) - (float)pos.func_177956_o();
                if (!((dstSq += dy * dy * 1.5f) < closestDistanceSq)) continue;
                closestDistanceSq = dstSq;
            }
            float playerWeight = 0.1f + 0.9f * MathHelper.func_76131_a((float)(1.0f - (float)(Math.sqrt(closestDistanceSq) - 32.0) / 32.0f), (float)0.0f, (float)1.0f);
            spawnWeight = (short)MathHelper.func_76141_d((float)((weightPercent *= playerWeight) * (float)spawnWeight));
        }
        this.setWeight(spawnWeight);
    }

    @Override
    public boolean canSpawn(World world, Chunk chunk, BlockPos pos, IBlockState blockState, IBlockState surfaceBlockState) {
        return blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, pos) && surfaceBlockState.func_177230_c().isAir(surfaceBlockState, (IBlockAccess)world, pos.func_177977_b());
    }
}

