/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome.spawning;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import thebetweenlands.api.entity.spawning.IBiomeSpawnEntriesData;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntriesProvider;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntry;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.util.WeightedList;

public abstract class AreaMobSpawner {
    @Nullable
    protected Predicate<EntityLivingBase> entityCountFilter = null;
    protected boolean strictDynamicLimit = true;
    private final Set<ChunkPos> eligibleChunksForSpawning = new HashSet<ChunkPos>();
    private final TObjectIntHashMap<Class<? extends Entity>> entityCounts = new TObjectIntHashMap();

    public void setStrictDynamicLimit(boolean strict) {
        this.strictDynamicLimit = strict;
    }

    public void setEntityCountFilter(@Nullable Predicate<EntityLivingBase> filter) {
        this.entityCountFilter = filter;
    }

    public boolean isInsideSpawningArea(World world, BlockPos pos, boolean entityCount) {
        return entityCount || world.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 24.0, false) == null;
    }

    public int getSpawningAttemptsPerGroup() {
        return 24;
    }

    public int getSpawningAttempsPerChunk() {
        return 8;
    }

    public int getMaxSpawnsPerChunk() {
        return 6;
    }

    public int getHardEntityLimit() {
        return BetweenlandsConfig.MOB_SPAWNING.hardEntityLimit;
    }

    public abstract float getMaxEntitiesPerSpawnChunkFraction(int var1);

    public float getLoadedAreasCount(int spawnerChunks) {
        return 1.0f;
    }

    public List<ICustomSpawnEntry> getSpawnEntries(World world, BlockPos pos, @Nullable ICustomSpawnEntriesProvider provider) {
        return provider != null ? provider.getCustomSpawnEntries() : Collections.emptyList();
    }

    @Nullable
    public IBiomeSpawnEntriesData getSpawnEntriesData(World world, BlockPos pos, @Nullable ICustomSpawnEntriesProvider provider) {
        return null;
    }

    public void populate(WorldServer world, boolean spawnHostiles, boolean spawnAnimals) {
        int totalWorldEntityCount = 0;
        for (Object entity : world.field_72996_f) {
            if (!(entity instanceof EntityLivingBase)) continue;
            ++totalWorldEntityCount;
        }
        if (totalWorldEntityCount >= this.getHardEntityLimit()) {
            return;
        }
        this.updateSpawnerChunks(world, this.eligibleChunksForSpawning);
        if (this.eligibleChunksForSpawning.isEmpty()) {
            return;
        }
        ArrayList<ChunkPos> spawnerChunks = new ArrayList<ChunkPos>(this.eligibleChunksForSpawning.size());
        for (ChunkPos chunkPos : this.eligibleChunksForSpawning) {
            if (!world.func_175667_e(new BlockPos(chunkPos.field_77276_a * 16, 64, chunkPos.field_77275_b * 16))) continue;
            spawnerChunks.add(chunkPos);
        }
        this.updateEntityCounts((World)world, this.entityCounts);
        int totalEligibleEntityCount = 0;
        for (int count : this.entityCounts.values()) {
            totalEligibleEntityCount += count;
        }
        int n = Math.min(this.getHardEntityLimit(), (int)((float)spawnerChunks.size() * this.getMaxEntitiesPerSpawnChunkFraction(spawnerChunks.size())));
        if (totalEligibleEntityCount >= n) {
            return;
        }
        Collections.shuffle(spawnerChunks);
        float loadedAreas = Math.max(1.0f, this.getLoadedAreasCount(spawnerChunks.size()));
        for (ChunkPos chunkPos : spawnerChunks) {
            this.populateChunk((World)world, chunkPos, spawnHostiles, spawnAnimals, true, false, this.getSpawningAttempsPerChunk(), this.getMaxSpawnsPerChunk(), this.getSpawningAttemptsPerGroup(), n, loadedAreas);
        }
    }

    public int populateChunk(World world, ChunkPos chunkPos, boolean spawnHostiles, boolean spawnAnimals, boolean loadChunks, boolean ignoreRestrictions, int attemptsPerChunk, int maxSpawnsPerChunk, int attemptsPerGroup, int entityLimit, float loadedAreas) {
        loadedAreas = Math.max(1.0f, loadedAreas);
        int attempts = 0;
        int chunkSpawnedEntities = 0;
        block0: while (attempts < attemptsPerChunk && chunkSpawnedEntities < maxSpawnsPerChunk) {
            long lastSpawn;
            int spawnEntityCountLimit;
            ++attempts;
            BlockPos spawnPos = this.getRandomSpawnPosition(world, chunkPos);
            if (!this.isInsideSpawningArea(world, spawnPos, false)) continue;
            Biome biome = world.func_180494_b(spawnPos);
            int totalBaseWeight = 0;
            int totalWeight = 0;
            ArrayList<ICustomSpawnEntry> possibleSpawns = new ArrayList<ICustomSpawnEntry>();
            possibleSpawns.addAll(this.getSpawnEntries(world, spawnPos, biome instanceof ICustomSpawnEntriesProvider ? (ICustomSpawnEntriesProvider)biome : null));
            Iterator spawnEntriesIT = possibleSpawns.iterator();
            while (spawnEntriesIT.hasNext()) {
                ICustomSpawnEntry spawnEntry = (ICustomSpawnEntry)spawnEntriesIT.next();
                if (spawnEntry.isHostile() && !spawnHostiles || !spawnEntry.isHostile() && !spawnAnimals) {
                    spawnEntriesIT.remove();
                    continue;
                }
                spawnEntry.update(world, spawnPos);
                totalBaseWeight += spawnEntry.getBaseWeight();
                totalWeight += spawnEntry.getWeight();
            }
            if (possibleSpawns.isEmpty() || totalWeight == 0 || totalBaseWeight == 0) continue;
            WeightedList weightedPossibleSpawns = new WeightedList();
            weightedPossibleSpawns.addAll(possibleSpawns);
            weightedPossibleSpawns.recalculateWeight();
            ICustomSpawnEntry spawnEntry = (ICustomSpawnEntry)weightedPossibleSpawns.getRandomItem(world.field_73012_v);
            if (spawnEntry == null) continue;
            int dynamicLimitBase = MathHelper.func_76143_f((double)((double)entityLimit / (double)totalBaseWeight * (double)spawnEntry.getBaseWeight()));
            int dynamicLimit = MathHelper.func_76143_f((double)((double)entityLimit / (double)totalWeight * (double)spawnEntry.getWeight()));
            int spawnEntityCount = this.entityCounts.get(spawnEntry.getEntityType());
            if (spawnEntityCount >= (spawnEntityCountLimit = this.strictDynamicLimit ? Math.min(dynamicLimit, dynamicLimitBase) : Math.max(dynamicLimit, dynamicLimitBase)) || spawnEntry.getWorldLimit() >= 0 && spawnEntityCount >= spawnEntry.getWorldLimit()) continue;
            int desiredGroupSize = spawnEntry.getMinGroupSize() + world.field_73012_v.nextInt(spawnEntry.getMaxGroupSize() - spawnEntry.getMinGroupSize() + 1);
            double groupCheckRadius = spawnEntry.getSpawnCheckRadius();
            int csx = MathHelper.func_76128_c((double)((double)spawnPos.func_177958_n() - groupCheckRadius)) >> 4;
            int cex = MathHelper.func_76128_c((double)((double)spawnPos.func_177958_n() + groupCheckRadius)) >> 4;
            int csz = MathHelper.func_76128_c((double)((double)spawnPos.func_177952_p() - groupCheckRadius)) >> 4;
            int cez = MathHelper.func_76128_c((double)((double)spawnPos.func_177952_p() + groupCheckRadius)) >> 4;
            for (int cx = csx; cx <= cex; ++cx) {
                for (int cz = csz; cz <= cez; ++cz) {
                    if (world.func_72863_F().func_186026_b(cx, cz) == null && (cx != chunkPos.field_77276_a || cz != chunkPos.field_77275_b)) continue block0;
                }
            }
            double groupSpawnRadius = spawnEntry.getGroupSpawnRadius();
            Class<? extends EntityLiving> entityType = spawnEntry.getEntityType();
            boolean checkExistingGroups = spawnEntry.shouldCheckExistingGroups();
            if (checkExistingGroups) {
                List foundGroupEntities = world.func_72872_a(entityType, new AxisAlignedBB((double)spawnPos.func_177958_n() - groupCheckRadius, (double)spawnPos.func_177956_o() - spawnEntry.getSpawnCheckRangeY(), (double)spawnPos.func_177952_p() - groupCheckRadius, (double)spawnPos.func_177958_n() + groupCheckRadius, (double)spawnPos.func_177956_o() + spawnEntry.getSpawnCheckRangeY(), (double)spawnPos.func_177952_p() + groupCheckRadius));
                for (Entity foundGroupEntity : foundGroupEntities) {
                    if (!(foundGroupEntity.func_70011_f((double)spawnPos.func_177958_n(), foundGroupEntity.field_70163_u + ((double)spawnPos.func_177956_o() - foundGroupEntity.field_70163_u) / spawnEntry.getSpawnCheckRangeY() * groupCheckRadius, (double)spawnPos.func_177952_p()) <= groupCheckRadius)) continue;
                    --desiredGroupSize;
                }
            }
            if (desiredGroupSize <= 0) continue;
            int groupSpawnedEntities = 0;
            int groupSpawnAttempts = 0;
            int maxGroupSpawnAttempts = attemptsPerGroup + desiredGroupSize * 2;
            IBiomeSpawnEntriesData spawnEntriesData = this.getSpawnEntriesData(world, spawnPos, biome instanceof ICustomSpawnEntriesProvider ? (ICustomSpawnEntriesProvider)biome : null);
            long l = lastSpawn = spawnEntriesData != null ? spawnEntriesData.getLastSpawn(spawnEntry) : -1L;
            if (!ignoreRestrictions && lastSpawn >= 0L) {
                int adjustedInterval = (int)((float)spawnEntry.getSpawningInterval() / loadedAreas);
                if (spawnEntriesData != null && world.func_82737_E() - lastSpawn < (long)adjustedInterval) continue;
            }
            IEntityLivingData groupData = null;
            EntityLiving cachedEntity = null;
            while (groupSpawnAttempts++ < maxGroupSpawnAttempts && groupSpawnedEntities < desiredGroupSize) {
                IBlockState surfaceBlockState;
                boolean inChunk;
                BlockPos entitySpawnPos = this.getRandomSpawnPosition(world, spawnPos, MathHelper.func_76128_c((double)groupSpawnRadius));
                boolean bl = inChunk = entitySpawnPos.func_177958_n() >> 4 == chunkPos.field_77276_a && entitySpawnPos.func_177952_p() >> 4 == chunkPos.field_77275_b;
                if (!loadChunks && !inChunk || !this.isInsideSpawningArea(world, entitySpawnPos, false)) continue;
                IBlockState spawnBlockState = world.func_180495_p(entitySpawnPos);
                int spawnSegmentY = entitySpawnPos.func_177956_o() / 16;
                Chunk spawnChunk = world.func_175726_f(entitySpawnPos);
                ClassInheritanceMultiMap[] entityLists = spawnChunk.func_177429_s();
                int chunkEntityCount = 0;
                for (int l2 = 0; l2 < entityLists.length; ++l2) {
                    int subChunkEntityCount = 0;
                    for (Entity entity : entityLists[l2]) {
                        if (entity.getClass() != spawnEntry.getEntityType()) continue;
                        ++subChunkEntityCount;
                        ++chunkEntityCount;
                    }
                    if (l2 == spawnSegmentY && spawnEntry.getSubChunkLimit() >= 0 && subChunkEntityCount < spawnEntry.getSubChunkLimit()) continue;
                }
                if (spawnEntry.getChunkLimit() >= 0 && chunkEntityCount >= spawnEntry.getChunkLimit() || !spawnEntry.canSpawn(world, spawnChunk, entitySpawnPos, spawnBlockState, surfaceBlockState = spawnChunk.func_186032_a(entitySpawnPos.func_177958_n() - spawnChunk.field_76635_g * 16, entitySpawnPos.func_177956_o() - 1, entitySpawnPos.func_177952_p() - spawnChunk.field_76647_h * 16))) continue;
                double sx = (double)entitySpawnPos.func_177958_n() + 0.5;
                double sy = entitySpawnPos.func_177956_o();
                double sz = (double)entitySpawnPos.func_177952_p() + 0.5;
                float yaw = world.field_73012_v.nextFloat() * 360.0f;
                EntityLiving spawningEntity = cachedEntity != null ? cachedEntity : (cachedEntity = spawnEntry.createEntity(world));
                if (spawningEntity == null) continue;
                spawningEntity.func_70012_b(sx, sy, sz, yaw, 0.0f);
                Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)spawningEntity, (World)world, (float)((float)sx), (float)((float)sy), (float)((float)sz), null);
                if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !spawningEntity.func_70601_bi() || !spawningEntity.func_70058_J())) continue;
                NBTTagCompound entityNBT = spawningEntity.getEntityData();
                entityNBT.func_74757_a("naturallySpawned", true);
                if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)spawningEntity, (World)world, (float)((float)sx), (float)((float)sy), (float)((float)sz), null)) {
                    groupData = spawningEntity.func_180482_a(world.func_175649_E(new BlockPos(sx, sy, sz)), groupData);
                }
                if (spawningEntity.func_70058_J()) {
                    ++groupSpawnedEntities;
                    ++chunkSpawnedEntities;
                    world.func_72838_d((Entity)spawningEntity);
                    spawnEntry.onSpawned((EntityLivingBase)spawningEntity);
                    if (this.isCountedEntity(world, (Entity)spawningEntity)) {
                        this.entityCounts.adjustOrPutValue(spawningEntity.getClass(), 1, 1);
                    }
                    cachedEntity = null;
                } else if (cachedEntity != null) {
                    cachedEntity.func_70106_y();
                    cachedEntity = null;
                }
                if (groupSpawnedEntities < ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)spawningEntity)) continue;
                break;
            }
            if (cachedEntity != null) {
                cachedEntity.func_70106_y();
            }
            if (spawnEntriesData == null || ignoreRestrictions || groupSpawnedEntities <= 0) continue;
            spawnEntriesData.setLastSpawn(spawnEntry, world.func_82737_E());
        }
        return chunkSpawnedEntities;
    }

    protected BlockPos getRandomSpawnPosition(World world, ChunkPos chunkPos) {
        Chunk chunk = world.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b);
        int x = chunkPos.field_77276_a * 16 + world.field_73012_v.nextInt(16);
        int z = chunkPos.field_77275_b * 16 + world.field_73012_v.nextInt(16);
        int y = Math.min(world.field_73012_v.nextInt(chunk == null ? world.func_72940_L() : chunk.func_76625_h() + 16 - 1), 256);
        return new BlockPos(x, y, z);
    }

    protected BlockPos getRandomSpawnPosition(World world, BlockPos centerPos, int radius) {
        return new BlockPos(centerPos.func_177958_n() + world.field_73012_v.nextInt(radius * 2) - radius, MathHelper.func_76125_a((int)(centerPos.func_177956_o() + world.field_73012_v.nextInt(4) - 2), (int)1, (int)world.func_72800_K()), centerPos.func_177952_p() + world.field_73012_v.nextInt(radius * 2) - radius);
    }

    protected abstract void updateSpawnerChunks(WorldServer var1, Set<ChunkPos> var2);

    protected void updateEntityCounts(World world, TObjectIntHashMap<Class<? extends Entity>> entityCounts) {
        entityCounts.clear();
        for (ChunkPos chunkPos : this.eligibleChunksForSpawning) {
            ClassInheritanceMultiMap[] entityLists;
            if (world.func_72863_F().func_186026_b(chunkPos.field_77276_a, chunkPos.field_77275_b) == null) continue;
            Chunk chunk = world.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b);
            for (ClassInheritanceMultiMap entityList : entityLists = chunk.func_177429_s()) {
                for (Entity entity : entityList) {
                    if (!this.isCountedEntity(world, entity)) continue;
                    entityCounts.adjustOrPutValue(entity.getClass(), 1, 1);
                }
            }
        }
    }

    private boolean isCountedEntity(World world, Entity entity) {
        return entity instanceof EntityLivingBase && this.isInsideSpawningArea(world, entity.func_180425_c(), true) && (this.entityCountFilter == null || this.entityCountFilter.test((EntityLivingBase)entity));
    }

    public static class BLSpawnEntry
    implements ICustomSpawnEntry {
        private final Class<? extends EntityLiving> entityType;
        private final Function<World, ? extends EntityLiving> entityCtor;
        private final short baseWeight;
        private short weight;
        private boolean hostile = false;
        private int subChunkLimit = -1;
        private int chunkLimit = -1;
        private int worldLimit = -1;
        private int minGroupSize = 1;
        private int maxGroupSize = 1;
        private double spawnCheckRadius = 16.0;
        private double spawnCheckRangeY = 6.0;
        private double groupSpawnRadius = 6.0;
        private int spawningInterval = 0;
        public final ResourceLocation id;

        public BLSpawnEntry(Class<? extends EntityLiving> entityType, Function<World, ? extends EntityLiving> entityCtor) {
            this(-1, entityType, entityCtor, 100);
        }

        public BLSpawnEntry(Class<? extends EntityLiving> entityType, Function<World, ? extends EntityLiving> entityCtor, short weight) {
            this(-1, entityType, entityCtor, weight);
        }

        public BLSpawnEntry(int id, Class<? extends EntityLiving> entityType, Function<World, ? extends EntityLiving> entityCtor) {
            this(id, entityType, entityCtor, 100);
        }

        public BLSpawnEntry(int id, Class<? extends EntityLiving> entityType, Function<World, ? extends EntityLiving> entityCtor, short weight) {
            this.id = new ResourceLocation("thebetweenlands", String.valueOf(id));
            this.entityType = entityType;
            this.entityCtor = entityCtor;
            this.weight = weight;
            this.baseWeight = weight;
        }

        @Override
        public ResourceLocation getID() {
            return this.id;
        }

        @Override
        public boolean isSaved() {
            return !"-1".equals(this.id.func_110623_a());
        }

        @Override
        public boolean canSpawn(World world, Chunk chunk, BlockPos pos, IBlockState blockState, IBlockState surfaceBlockState) {
            return !blockState.func_185915_l() && surfaceBlockState.func_185915_l();
        }

        @Override
        public void update(World world, BlockPos pos) {
        }

        @Override
        public final short getWeight() {
            return this.weight;
        }

        @Override
        public final BLSpawnEntry setWeight(short weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public final BLSpawnEntry setSpawningInterval(int interval) {
            this.spawningInterval = interval;
            return this;
        }

        @Override
        public final int getSpawningInterval() {
            return this.spawningInterval;
        }

        @Override
        public final short getBaseWeight() {
            return this.baseWeight;
        }

        @Override
        public final BLSpawnEntry setGroupSize(int min, int max) {
            if (max < min) {
                throw new RuntimeException("Maximum group size cannot be smaller than minimum group size!");
            }
            this.minGroupSize = min;
            this.maxGroupSize = max;
            return this;
        }

        @Override
        public final int getMaxGroupSize() {
            return this.maxGroupSize;
        }

        @Override
        public final int getMinGroupSize() {
            return this.minGroupSize;
        }

        @Override
        public final int getChunkLimit() {
            return this.chunkLimit;
        }

        @Override
        public final BLSpawnEntry setChunkLimit(int limit) {
            this.chunkLimit = limit;
            return this;
        }

        @Override
        public final int getWorldLimit() {
            return this.worldLimit;
        }

        @Override
        public final BLSpawnEntry setWorldLimit(int limit) {
            this.worldLimit = limit;
            return this;
        }

        @Override
        public final int getSubChunkLimit() {
            return this.subChunkLimit;
        }

        @Override
        public final BLSpawnEntry setSubChunkLimit(int limit) {
            this.subChunkLimit = limit;
            return this;
        }

        @Override
        public final BLSpawnEntry setHostile(boolean hostile) {
            this.hostile = hostile;
            return this;
        }

        @Override
        public final boolean isHostile() {
            return this.hostile;
        }

        @Override
        public final BLSpawnEntry setSpawnCheckRadius(double radius) {
            this.spawnCheckRadius = radius;
            return this;
        }

        @Override
        public final double getSpawnCheckRadius() {
            return this.spawnCheckRadius;
        }

        @Override
        public final BLSpawnEntry setSpawnCheckRangeY(double y) {
            this.spawnCheckRangeY = y;
            return this;
        }

        @Override
        public final double getSpawnCheckRangeY() {
            return this.spawnCheckRangeY;
        }

        @Override
        public final BLSpawnEntry setGroupSpawnRadius(double radius) {
            this.groupSpawnRadius = radius;
            return this;
        }

        @Override
        public final double getGroupSpawnRadius() {
            return this.groupSpawnRadius;
        }

        @Override
        public boolean shouldCheckExistingGroups() {
            return true;
        }

        @Override
        public EntityLiving createEntity(World world) {
            try {
                return this.entityCtor.apply(world);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public final Class<? extends EntityLiving> getEntityType() {
            return this.entityType;
        }

        public final Function<World, ? extends EntityLiving> getEntityCtor() {
            return this.entityCtor;
        }

        @Override
        public void onSpawned(EntityLivingBase entity) {
        }
    }
}

