/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.registries;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.api.recipes.IDruidAltarRecipe;
import thebetweenlands.api.recipes.IPurifierRecipe;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.block.terrain.BlockCragrock;
import thebetweenlands.common.block.terrain.BlockDentrothyst;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.entity.mobs.EntityRootSprite;
import thebetweenlands.common.entity.mobs.EntitySporeling;
import thebetweenlands.common.entity.rowboat.EntityWeedwoodRowboat;
import thebetweenlands.common.herblore.elixir.ElixirRecipes;
import thebetweenlands.common.item.herblore.ItemCrushed;
import thebetweenlands.common.item.herblore.ItemPlantDrop;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.item.misc.ItemSwampTalisman;
import thebetweenlands.common.recipe.ShapelessOverrideDummyRecipe;
import thebetweenlands.common.recipe.animator.RingOfGatheringRespawnAnimatorRecipe;
import thebetweenlands.common.recipe.animator.ToolRepairAnimatorRecipe;
import thebetweenlands.common.recipe.censer.AbstractCenserRecipe;
import thebetweenlands.common.recipe.censer.CenserRecipeAspect;
import thebetweenlands.common.recipe.censer.CenserRecipeCremains;
import thebetweenlands.common.recipe.censer.CenserRecipeDungeonFog;
import thebetweenlands.common.recipe.censer.CenserRecipeElixir;
import thebetweenlands.common.recipe.censer.CenserRecipePlantTonic;
import thebetweenlands.common.recipe.censer.CenserRecipeSapBall;
import thebetweenlands.common.recipe.censer.CenserRecipeStagnantWater;
import thebetweenlands.common.recipe.censer.CenserRecipeSwampWater;
import thebetweenlands.common.recipe.censer.CenserRecipeWeepingBluePetal;
import thebetweenlands.common.recipe.misc.AnimatorRecipe;
import thebetweenlands.common.recipe.misc.BookMergeRecipe;
import thebetweenlands.common.recipe.misc.CompostRecipe;
import thebetweenlands.common.recipe.misc.DruidAltarRecipe;
import thebetweenlands.common.recipe.misc.HearthgroveTarringRecipe;
import thebetweenlands.common.recipe.misc.PestleAndMortarRecipe;
import thebetweenlands.common.recipe.misc.RecipeClearBoneWayfinder;
import thebetweenlands.common.recipe.misc.RecipeGrapplingHookUpgrades;
import thebetweenlands.common.recipe.misc.RecipeLurkerSkinPouchUpgrades;
import thebetweenlands.common.recipe.misc.RecipeMarshRunnerBoots;
import thebetweenlands.common.recipe.misc.RecipeMummyBait;
import thebetweenlands.common.recipe.misc.RecipeSapSpitCleanTool;
import thebetweenlands.common.recipe.misc.RecipesAspectVials;
import thebetweenlands.common.recipe.misc.RecipesCircleGems;
import thebetweenlands.common.recipe.misc.RecipesCoating;
import thebetweenlands.common.recipe.misc.RecipesLifeCrystal;
import thebetweenlands.common.recipe.misc.RecipesPlantTonic;
import thebetweenlands.common.recipe.purifier.PurifierRecipe;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.CustomRecipeRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityAnimator;
import thebetweenlands.common.tile.spawner.MobSpawnerLogicBetweenlands;
import thebetweenlands.common.tile.spawner.TileEntityMobSpawnerBetweenlands;

public class RecipeRegistry {
    public static final ResourceLocation CIRCLE_GEMS = new ResourceLocation("thebetweenlands", "recipe_circle_gems");
    public static final ResourceLocation COATING = new ResourceLocation("thebetweenlands", "recipe_coating");
    public static final ResourceLocation LIFE_CRYSTAL = new ResourceLocation("thebetweenlands", "recipe_life_crystal");
    public static final ResourceLocation PLANT_TONIC = new ResourceLocation("thebetweenlands", "recipe_plant_tonic");
    public static final ResourceLocation LURKER_POUCH = new ResourceLocation("thebetweenlands", "recipe_lurker_skin_pouch_upgrade");
    public static final ResourceLocation MUMMY_BAIT = new ResourceLocation("thebetweenlands", "recipe_mummy_bait");
    public static final ResourceLocation ASPECT_VIAL = new ResourceLocation("thebetweenlands", "recipe_aspect_vial");
    public static final ResourceLocation RUNNER_BOOTS = new ResourceLocation("thebetweenlands", "recipe_marsh_runner_boots");
    public static final ResourceLocation BOOK_MERGE = new ResourceLocation("thebetweenlands", "recipe_book_merge");
    public static final ResourceLocation HEARTHGROVE_LOG_TARRING = new ResourceLocation("thebetweenlands", "hearthgrove_log_tarring");
    public static final ResourceLocation CLEAR_BONE_WAYFINDER = new ResourceLocation("thebetweenlands", "clear_bone_wayfinder");
    public static final ResourceLocation SAP_SPIT_CLEAN_TOOL = new ResourceLocation("thebetweenlands", "sap_spit_clean_tool");
    public static final ResourceLocation GRAPPLING_HOOK_UPGRADE = new ResourceLocation("thebetweenlands", "grappling_hook_upgrade");

    private RecipeRegistry() {
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        RecipeRegistry.registerSmelting();
        RecipeRegistry.registerDynamicRecipes((IForgeRegistry<IRecipe>)registry);
        RecipeRegistry.registerPurifierRecipes();
        RecipeRegistry.registerPestleAndMortarRecipes();
        RecipeRegistry.registerCompostRecipes();
        RecipeRegistry.registerDruidAltarRecipes();
        RecipeRegistry.registerAnimatorRecipes();
        RecipeRegistry.registerCenserRecipes();
        ElixirRecipes.init();
        CustomRecipeRegistry.loadCustomRecipes();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerRecipesLast(RegistryEvent.Register<IRecipe> event) {
        RecipeRegistry.overrideConflictingRecipes((IForgeRegistry<IRecipe>)event.getRegistry());
    }

    private static void overrideConflictingRecipes(IForgeRegistry<IRecipe> registry) {
        boolean vanilla = BetweenlandsConfig.GENERAL.overrideConflictingVanillaRecipes;
        boolean any = BetweenlandsConfig.GENERAL.overrideAnyConflictingRecipes;
        if (vanilla || any) {
            if (BetweenlandsConfig.DEBUG.debugRecipeOverrides) {
                TheBetweenlands.logger.info("Searching recipe conflicts:");
            }
            ArrayList<IRecipe> blRecipes = new ArrayList<IRecipe>();
            ArrayList<IRecipe> otherRecipes = new ArrayList<IRecipe>();
            for (IRecipe recipe : registry) {
                if ("thebetweenlands".equals(recipe.getRegistryName().func_110624_b())) {
                    blRecipes.add(recipe);
                    continue;
                }
                otherRecipes.add(recipe);
            }
            HashMultimap conflictingRecipes = HashMultimap.create();
            for (IRecipe otherRecipe : otherRecipes) {
                if (otherRecipe.func_192399_d() || !any && (!vanilla || !"minecraft".equals(otherRecipe.getRegistryName().func_110624_b()))) continue;
                NonNullList otherIngredients = otherRecipe.func_192400_c();
                for (IRecipe blRecipe : blRecipes) {
                    NonNullList blIngredients;
                    if (blRecipe.func_192399_d() || (blIngredients = blRecipe.func_192400_c()).size() != otherIngredients.size()) continue;
                    IShapedRecipe blRecipeShaped = blRecipe instanceof IShapedRecipe ? (IShapedRecipe)blRecipe : null;
                    IShapedRecipe otherRecipeShaped = otherRecipe instanceof IShapedRecipe ? (IShapedRecipe)otherRecipe : null;
                    boolean canBlRecipeFit = blRecipeShaped == null || otherRecipeShaped == null || blRecipeShaped.getRecipeWidth() >= otherRecipeShaped.getRecipeWidth() && blIngredients.size() <= otherRecipeShaped.getRecipeWidth() || blRecipeShaped.getRecipeWidth() == otherRecipeShaped.getRecipeWidth() && blRecipeShaped.getRecipeHeight() <= otherRecipeShaped.getRecipeHeight();
                    if (!canBlRecipeFit) continue;
                    boolean hasConflict = true;
                    for (int i = 0; i < blIngredients.size(); ++i) {
                        Ingredient blIngredient = (Ingredient)blIngredients.get(i);
                        Ingredient otherIngredient = (Ingredient)otherIngredients.get(i);
                        if (blIngredient.func_193365_a().length == 0 && otherIngredient.func_193365_a().length == 0) continue;
                        boolean hasSlotMatch = false;
                        for (ItemStack stack : blIngredient.func_193365_a()) {
                            if (!otherIngredient.apply(stack)) continue;
                            hasSlotMatch = true;
                            break;
                        }
                        if (hasSlotMatch) continue;
                        hasConflict = false;
                        break;
                    }
                    if (!hasConflict) continue;
                    if (BetweenlandsConfig.DEBUG.debugRecipeOverrides) {
                        TheBetweenlands.logger.info(blRecipe.getRegistryName() + " " + otherRecipe.getRegistryName());
                    }
                    conflictingRecipes.put((Object)blRecipe, (Object)otherRecipe.getRegistryName());
                }
            }
            if (BetweenlandsConfig.DEBUG.debugRecipeOverrides) {
                TheBetweenlands.logger.info("Replacing conflicting recipes:");
            }
            for (Map.Entry entry : conflictingRecipes.entries()) {
                IRecipe blRecipe = (IRecipe)entry.getKey();
                IRecipe otherRecipe = (IRecipe)registry.getValue((ResourceLocation)entry.getValue());
                ShapelessOverrideDummyRecipe overrideDummy = otherRecipe instanceof IShapedRecipe ? new ShapelessOverrideDummyRecipe.ShapedOverrideDummyRecipe(blRecipe, (IShapedRecipe)otherRecipe) : new ShapelessOverrideDummyRecipe(blRecipe, otherRecipe);
                overrideDummy.setRegistryName(otherRecipe.getRegistryName());
                registry.register((IForgeRegistryEntry)overrideDummy);
                if (!BetweenlandsConfig.DEBUG.debugRecipeOverrides) continue;
                TheBetweenlands.logger.info(blRecipe.getRegistryName() + " " + otherRecipe.getRegistryName() + (registry.getValue((ResourceLocation)entry.getValue()) != overrideDummy ? " FAILED" : ""));
            }
        }
    }

    private static void registerDynamicRecipes(IForgeRegistry<IRecipe> registry) {
        registry.register(new RecipesCircleGems().setRegistryName(CIRCLE_GEMS));
        registry.register(new RecipesCoating().setRegistryName(COATING));
        registry.register(new RecipesLifeCrystal().setRegistryName(LIFE_CRYSTAL));
        registry.register(new RecipesPlantTonic().setRegistryName(PLANT_TONIC));
        registry.register(new RecipeLurkerSkinPouchUpgrades().setRegistryName(LURKER_POUCH));
        registry.register(new RecipeMummyBait().setRegistryName(MUMMY_BAIT));
        registry.register(new RecipesAspectVials().setRegistryName(ASPECT_VIAL));
        registry.register(new RecipeMarshRunnerBoots().setRegistryName(RUNNER_BOOTS));
        registry.register(new BookMergeRecipe().setRegistryName(BOOK_MERGE));
        registry.register(new HearthgroveTarringRecipe().setRegistryName(HEARTHGROVE_LOG_TARRING));
        registry.register(new RecipeClearBoneWayfinder().setRegistryName(CLEAR_BONE_WAYFINDER));
        registry.register(new RecipeSapSpitCleanTool().setRegistryName(SAP_SPIT_CLEAN_TOOL));
        registry.register(new RecipeGrapplingHookUpgrades().setRegistryName(GRAPPLING_HOOK_UPGRADE));
    }

    private static void registerSmelting() {
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.SYRMORITE_ORE), (ItemStack)ItemMisc.EnumItemMisc.SYRMORITE_INGOT.create(1), (float)0.7f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.OCTINE_ORE), (ItemStack)new ItemStack((Item)ItemRegistry.OCTINE_INGOT), (float)0.7f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.DAMP_TORCH), (ItemStack)new ItemStack(Blocks.field_150478_aa), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.SWAMP_REED_ITEM), (ItemStack)ItemMisc.EnumItemMisc.DRIED_SWAMP_REED.create(1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.MUD), (ItemStack)ItemMisc.EnumItemMisc.MUD_BRICK.create(1), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.KRAKEN_TENTACLE), (ItemStack)new ItemStack(ItemRegistry.KRAKEN_CALAMARI, 5), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.SWAMP_KELP_ITEM), (ItemStack)new ItemStack(ItemRegistry.FRIED_SWAMP_KELP), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.ANGLER_MEAT_RAW), (ItemStack)new ItemStack(ItemRegistry.ANGLER_MEAT_COOKED), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.FROG_LEGS_RAW), (ItemStack)new ItemStack(ItemRegistry.FROG_LEGS_COOKED), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.SNAIL_FLESH_RAW), (ItemStack)new ItemStack(ItemRegistry.SNAIL_FLESH_COOKED), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.BETWEENSTONE), (ItemStack)new ItemStack(BlockRegistry.SMOOTH_BETWEENSTONE), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.PITSTONE), (ItemStack)new ItemStack(BlockRegistry.SMOOTH_PITSTONE), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.CRAGROCK), (ItemStack)new ItemStack(BlockRegistry.SMOOTH_CRAGROCK), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.LIMESTONE), (ItemStack)new ItemStack(BlockRegistry.POLISHED_LIMESTONE), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.DENTROTHYST, 1, BlockDentrothyst.EnumDentrothyst.GREEN.getMeta()), (ItemStack)new ItemStack(BlockRegistry.POLISHED_DENTROTHYST, 1, BlockDentrothyst.EnumDentrothyst.GREEN.getMeta()), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.DENTROTHYST, 1, BlockDentrothyst.EnumDentrothyst.ORANGE.getMeta()), (ItemStack)new ItemStack(BlockRegistry.POLISHED_DENTROTHYST, 1, BlockDentrothyst.EnumDentrothyst.ORANGE.getMeta()), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.SLUDGE_BALL), (ItemStack)new ItemStack(ItemRegistry.SLUDGE_JELLO), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.SILT), (ItemStack)new ItemStack(BlockRegistry.SILT_GLASS), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.BETWEENSTONE_TILES), (ItemStack)new ItemStack(BlockRegistry.CRACKED_BETWEENSTONE_TILES), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.BETWEENSTONE_BRICKS), (ItemStack)new ItemStack(BlockRegistry.CRACKED_BETWEENSTONE_BRICKS), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BlockRegistry.LIMESTONE_BRICKS), (ItemStack)new ItemStack(BlockRegistry.CRACKED_LIMESTONE_BRICKS), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.BL_BUCKET_RUBBER, 1, 0), (ItemStack)ItemMisc.EnumItemMisc.RUBBER_BALL.create(3), (float)0.5f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.BL_BUCKET_RUBBER, 1, 1), (ItemStack)new ItemStack(ItemRegistry.SYRMORITE_BUCKET_SOLID_RUBBER), (float)0.5f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemRegistry.MIRE_SNAIL_EGG), (ItemStack)new ItemStack(ItemRegistry.MIRE_SNAIL_EGG_COOKED), (float)0.4f);
        GameRegistry.addSmelting((Block)BlockRegistry.MOSS, (ItemStack)new ItemStack(BlockRegistry.DEAD_MOSS), (float)0.1f);
        GameRegistry.addSmelting((Block)BlockRegistry.LICHEN, (ItemStack)new ItemStack(BlockRegistry.DEAD_LICHEN), (float)0.1f);
        GameRegistry.addSmelting((Block)BlockRegistry.WEEDWOOD_BUSH, (ItemStack)new ItemStack(BlockRegistry.DEAD_WEEDWOOD_BUSH), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.VALONITE_AXE, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.VALONITE_SPLINTER.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.VALONITE_PICKAXE, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.VALONITE_SPLINTER.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.VALONITE_SHOVEL, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.VALONITE_SPLINTER.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.VALONITE_SWORD, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.VALONITE_SPLINTER.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.VALONITE_HELMET, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.VALONITE_SPLINTER.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.VALONITE_CHESTPLATE, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.VALONITE_SPLINTER.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.VALONITE_LEGGINGS, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.VALONITE_SPLINTER.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.VALONITE_BOOTS, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.VALONITE_SPLINTER.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.OCTINE_AXE, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.OCTINE_NUGGET.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.OCTINE_PICKAXE, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.OCTINE_NUGGET.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.OCTINE_SHOVEL, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.OCTINE_NUGGET.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.OCTINE_SWORD, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.OCTINE_NUGGET.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.SYRMORITE_HELMET, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.SYRMORITE_NUGGET.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.SYRMORITE_CHESTPLATE, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.SYRMORITE_NUGGET.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.SYRMORITE_LEGGINGS, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.SYRMORITE_NUGGET.getID()), (float)0.1f);
        GameRegistry.addSmelting((Item)ItemRegistry.SYRMORITE_BOOTS, (ItemStack)new ItemStack(ItemRegistry.ITEMS_MISC, 1, ItemMisc.EnumItemMisc.SYRMORITE_NUGGET.getID()), (float)0.1f);
    }

    private static void registerDruidAltarRecipes() {
        DruidAltarRecipe.addRecipe(ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN_1.create(1), ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN_2.create(1), ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN_3.create(1), ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN_4.create(1), ItemSwampTalisman.EnumTalisman.SWAMP_TALISMAN_0.create(1));
        DruidAltarRecipe.addRecipe(new IDruidAltarRecipe(){

            @Override
            public boolean containsInputItem(ItemStack input) {
                int[] ids;
                if (input.func_190926_b()) {
                    return false;
                }
                for (int id : ids = OreDictionary.getOreIDs((ItemStack)input)) {
                    if (!"treeSapling".equals(OreDictionary.getOreName((int)id))) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean matchesInput(ItemStack[] input) {
                for (ItemStack stack : input) {
                    if (this.containsInputItem(stack)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public ItemStack getOutput(ItemStack[] input) {
                return ItemStack.field_190927_a;
            }

            @Override
            public void onCrafted(World world, BlockPos pos, ItemStack[] input, ItemStack output) {
                BlockPos spawnerPos = pos.func_177977_b();
                if (world.func_180495_p(spawnerPos).func_185887_b(world, spawnerPos) >= 0.0f) {
                    world.func_175656_a(spawnerPos, BlockRegistry.MOB_SPAWNER.func_176223_P());
                    TileEntity te = world.func_175625_s(spawnerPos);
                    if (te instanceof TileEntityMobSpawnerBetweenlands) {
                        MobSpawnerLogicBetweenlands logic = ((TileEntityMobSpawnerBetweenlands)te).getSpawnerLogic();
                        logic.setNextEntityName("thebetweenlands:dark_druid").setCheckRange(32.0).setSpawnRange(6).setSpawnInAir(false).setMaxEntities(1 + world.field_73012_v.nextInt(3));
                    }
                    world.func_184133_a(null, spawnerPos, (SoundEvent)SoundRegistry.DRUID_TELEPORT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    world.func_175718_b(2001, spawnerPos.func_177981_b(4), Block.func_176210_f((IBlockState)Blocks.field_150345_g.func_176223_P()));
                    world.func_175718_b(2003, spawnerPos.func_177981_b(4), 0);
                }
            }
        });
    }

    private static void registerCompostRecipes() {
        CompostRecipe.addRecipe(30, 12000, ItemMisc.EnumItemMisc.DRY_BARK.create(1));
        CompostRecipe.addRecipe(25, 12000, Item.func_150898_a((Block)BlockRegistry.HOLLOW_LOG));
        CompostRecipe.addRecipe(25, 12000, Item.func_150898_a((Block)BlockRegistry.LOG_ROTTEN_BARK));
        CompostRecipe.addRecipe(10, 8000, Item.func_150898_a((Block)BlockRegistry.SUNDEW));
        CompostRecipe.addRecipe(6, 10000, Item.func_150898_a((Block)BlockRegistry.SWAMP_DOUBLE_TALLGRASS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.PHRAGMITES));
        CompostRecipe.addRecipe(6, 10000, Item.func_150898_a((Block)BlockRegistry.TALL_CATTAIL));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.CARDINAL_FLOWER));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BROOMSEDGE));
        CompostRecipe.addRecipe(15, 11000, Item.func_150898_a((Block)BlockRegistry.WEEPING_BLUE));
        CompostRecipe.addRecipe(12, 11000, Item.func_150898_a((Block)BlockRegistry.PITCHER_PLANT));
        CompostRecipe.addRecipe(6, 8000, Item.func_150898_a((Block)BlockRegistry.BOG_BEAN_FLOWER));
        CompostRecipe.addRecipe(6, 8000, Item.func_150898_a((Block)BlockRegistry.BOG_BEAN_STALK));
        CompostRecipe.addRecipe(6, 8000, Item.func_150898_a((Block)BlockRegistry.GOLDEN_CLUB_FLOWER));
        CompostRecipe.addRecipe(6, 8000, Item.func_150898_a((Block)BlockRegistry.GOLDEN_CLUB_STALK));
        CompostRecipe.addRecipe(6, 8000, Item.func_150898_a((Block)BlockRegistry.MARSH_MARIGOLD_FLOWER));
        CompostRecipe.addRecipe(6, 8000, Item.func_150898_a((Block)BlockRegistry.MARSH_MARIGOLD_STALK));
        CompostRecipe.addRecipe(3, 5000, Item.func_150898_a((Block)BlockRegistry.SWAMP_KELP));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.WATER_WEEDS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BLADDERWORT_FLOWER));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BLADDERWORT_STALK));
        CompostRecipe.addRecipe(20, 12000, Item.func_150898_a((Block)BlockRegistry.ROOT));
        CompostRecipe.addRecipe(20, 12000, Item.func_150898_a((Block)BlockRegistry.ROOT_UNDERWATER));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BLACK_HAT_MUSHROOM));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.FLAT_HEAD_MUSHROOM));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BULB_CAPPED_MUSHROOM));
        CompostRecipe.addRecipe(8, 6000, Item.func_150898_a((Block)BlockRegistry.EDGE_LEAF));
        CompostRecipe.addRecipe(8, 6000, Item.func_150898_a((Block)BlockRegistry.EDGE_MOSS));
        CompostRecipe.addRecipe(8, 6000, Item.func_150898_a((Block)BlockRegistry.EDGE_SHROOM));
        CompostRecipe.addRecipe(4, 6000, Item.func_150898_a((Block)BlockRegistry.SWAMP_PLANT));
        CompostRecipe.addRecipe(12, 10000, Item.func_150898_a((Block)BlockRegistry.VENUS_FLY_TRAP));
        CompostRecipe.addRecipe(15, 11000, Item.func_150898_a((Block)BlockRegistry.VOLARPAD));
        CompostRecipe.addRecipe(20, 12000, Item.func_150898_a((Block)BlockRegistry.WEEDWOOD_BUSH));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.THORNS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.POISON_IVY));
        CompostRecipe.addRecipe(6, 9000, Item.func_150898_a((Block)BlockRegistry.MOSS));
        CompostRecipe.addRecipe(6, 3000, Item.func_150898_a((Block)BlockRegistry.DEAD_MOSS));
        CompostRecipe.addRecipe(6, 9000, Item.func_150898_a((Block)BlockRegistry.LICHEN));
        CompostRecipe.addRecipe(6, 3000, Item.func_150898_a((Block)BlockRegistry.DEAD_LICHEN));
        CompostRecipe.addRecipe(6, 9000, Item.func_150898_a((Block)BlockRegistry.CAVE_MOSS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.CAVE_GRASS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.CATTAIL));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.SWAMP_TALLGRASS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.SHOOTS));
        CompostRecipe.addRecipe(6, 9000, Item.func_150898_a((Block)BlockRegistry.NETTLE_FLOWERED));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.NETTLE));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.ARROW_ARUM));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BUTTON_BUSH));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.MARSH_HIBISCUS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.PICKEREL_WEED));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.SOFT_RUSH));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.MARSH_MALLOW));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BLUE_IRIS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.COPPER_IRIS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BLUE_EYED_GRASS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.MILKWEED));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BONESET));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.BOTTLE_BRUSH_GRASS));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.SLUDGECREEP));
        CompostRecipe.addRecipe(8, 6000, Item.func_150898_a((Block)BlockRegistry.TALL_SLUDGECREEP));
        CompostRecipe.addRecipe(8, 6000, Item.func_150898_a((Block)BlockRegistry.ROTBULB));
        CompostRecipe.addRecipe(8, 6000, Item.func_150898_a((Block)BlockRegistry.PALE_GRASS));
        CompostRecipe.addRecipe(8, 6000, Item.func_150898_a((Block)BlockRegistry.STRING_ROOTS));
        CompostRecipe.addRecipe(8, 6000, Item.func_150898_a((Block)BlockRegistry.CRYPTWEED));
        CompostRecipe.addRecipe(5, 8000, Item.func_150898_a((Block)BlockRegistry.DEAD_WEEDWOOD_BUSH));
        CompostRecipe.addRecipe(3, 5000, Item.func_150898_a((Block)BlockRegistry.HANGER));
        CompostRecipe.addRecipe(3, 5000, Item.func_150898_a((Block)BlockRegistry.ALGAE));
        CompostRecipe.addRecipe(3, 5000, ItemRegistry.ROPE_ITEM);
        CompostRecipe.addRecipe(6, 9000, Item.func_150898_a((Block)BlockRegistry.MIRE_CORAL));
        CompostRecipe.addRecipe(6, 9000, Item.func_150898_a((Block)BlockRegistry.DEEP_WATER_CORAL));
        CompostRecipe.addRecipe(15, 11000, Item.func_150898_a((Block)BlockRegistry.SAPLING_RUBBER));
        CompostRecipe.addRecipe(15, 11000, Item.func_150898_a((Block)BlockRegistry.SAPLING_SAP));
        CompostRecipe.addRecipe(15, 11000, Item.func_150898_a((Block)BlockRegistry.SAPLING_WEEDWOOD));
        CompostRecipe.addRecipe(15, 11000, Item.func_150898_a((Block)BlockRegistry.SAPLING_HEARTHGROVE));
        CompostRecipe.addRecipe(15, 11000, Item.func_150898_a((Block)BlockRegistry.SAPLING_NIBBLETWIG));
        CompostRecipe.addRecipe(25, 11000, Item.func_150898_a((Block)BlockRegistry.SAPLING_SPIRIT_TREE));
        CompostRecipe.addRecipe(4, 11000, Item.func_150898_a((Block)BlockRegistry.LEAVES_RUBBER_TREE));
        CompostRecipe.addRecipe(4, 11000, Item.func_150898_a((Block)BlockRegistry.LEAVES_SAP_TREE));
        CompostRecipe.addRecipe(4, 11000, Item.func_150898_a((Block)BlockRegistry.LEAVES_WEEDWOOD_TREE));
        CompostRecipe.addRecipe(4, 11000, Item.func_150898_a((Block)BlockRegistry.LEAVES_HEARTHGROVE_TREE));
        CompostRecipe.addRecipe(4, 11000, Item.func_150898_a((Block)BlockRegistry.LEAVES_NIBBLETWIG_TREE));
        CompostRecipe.addRecipe(6, 11000, Item.func_150898_a((Block)BlockRegistry.LEAVES_SPIRIT_TREE_BOTTOM));
        CompostRecipe.addRecipe(6, 11000, Item.func_150898_a((Block)BlockRegistry.LEAVES_SPIRIT_TREE_MIDDLE));
        CompostRecipe.addRecipe(6, 11000, Item.func_150898_a((Block)BlockRegistry.LEAVES_SPIRIT_TREE_TOP));
        CompostRecipe.addRecipe(4, 11000, Item.func_150898_a((Block)BlockRegistry.FALLEN_LEAVES));
        CompostRecipe.addRecipe(3, 5000, ItemRegistry.SWAMP_REED_ITEM);
        CompostRecipe.addRecipe(3, 5000, ItemMisc.EnumItemMisc.DRIED_SWAMP_REED.create(1));
        CompostRecipe.addRecipe(5, 8000, ItemMisc.EnumItemMisc.SWAMP_REED_ROPE.create(1));
        CompostRecipe.addRecipe(5, 8000, ItemRegistry.TANGLED_ROOT);
        CompostRecipe.addRecipe(3, 5000, ItemRegistry.SWAMP_KELP_ITEM);
        CompostRecipe.addRecipe(5, 8000, ItemRegistry.FLAT_HEAD_MUSHROOM_ITEM);
        CompostRecipe.addRecipe(5, 8000, ItemRegistry.BLACK_HAT_MUSHROOM_ITEM);
        CompostRecipe.addRecipe(5, 8000, ItemRegistry.BULB_CAPPED_MUSHROOM_ITEM);
        CompostRecipe.addRecipe(12, 10000, ItemRegistry.YELLOW_DOTTED_FUNGUS);
        CompostRecipe.addRecipe(10, 6000, ItemRegistry.MIDDLE_FRUIT_BUSH_SEEDS);
        CompostRecipe.addRecipe(10, 6000, ItemRegistry.SPORES);
        CompostRecipe.addRecipe(10, 6000, ItemRegistry.ASPECTRUS_SEEDS);
        for (ItemCrushed.EnumItemCrushed enumItemCrushed : ItemCrushed.EnumItemCrushed.values()) {
            CompostRecipe.addRecipe(3, 4000, new ItemStack(ItemRegistry.ITEMS_CRUSHED, 1, enumItemCrushed.getID()));
        }
        for (Enum enum_ : ItemPlantDrop.EnumItemPlantDrop.values()) {
            CompostRecipe.addRecipe(3, 4000, new ItemStack(ItemRegistry.ITEMS_PLANT_DROP, 1, ((ItemPlantDrop.EnumItemPlantDrop)enum_).getID()));
        }
    }

    private static void registerPestleAndMortarRecipes() {
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LIMESTONE_FLUX.create(3), new ItemStack(BlockRegistry.LIMESTONE));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LIMESTONE_FLUX.create(3), new ItemStack(BlockRegistry.POLISHED_LIMESTONE));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_ALGAE.create(1), ItemPlantDrop.EnumItemPlantDrop.ALGAE_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_ANGLER_TOOTH.create(1), ItemMisc.EnumItemMisc.ANGLER_TOOTH.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_AQUA_MIDDLE_GEM.create(1), new ItemStack(ItemRegistry.AQUA_MIDDLE_GEM, 1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_ARROW_ARUM.create(1), ItemPlantDrop.EnumItemPlantDrop.ARROW_ARUM_LEAF.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BLACKHAT_MUSHROOM.create(1), new ItemStack(ItemRegistry.BLACK_HAT_MUSHROOM_ITEM));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BLOOD_SNAIL_SHELL.create(1), ItemMisc.EnumItemMisc.BLOOD_SNAIL_SHELL.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BLUE_EYED_GRASS.create(1), ItemPlantDrop.EnumItemPlantDrop.BLUE_EYED_GRASS_FLOWERS.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BLUE_IRIS.create(1), ItemPlantDrop.EnumItemPlantDrop.BLUE_IRIS_PETAL.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BOG_BEAN.create(1), ItemPlantDrop.EnumItemPlantDrop.BOG_BEAN_FLOWER_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BONESET.create(1), ItemPlantDrop.EnumItemPlantDrop.BONESET_FLOWERS.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BOTTLE_BRUSH_GRASS.create(1), ItemPlantDrop.EnumItemPlantDrop.BOTTLE_BRUSH_GRASS_BLADES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BROOM_SEDGE.create(1), ItemPlantDrop.EnumItemPlantDrop.BROOM_SEDGE_LEAVES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BULB_CAPPED_MUSHROOM.create(1), new ItemStack(ItemRegistry.BULB_CAPPED_MUSHROOM_ITEM));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BUTTON_BUSH.create(1), ItemPlantDrop.EnumItemPlantDrop.BUTTON_BUSH_FLOWERS.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_CARDINAL_FLOWER.create(1), ItemPlantDrop.EnumItemPlantDrop.CARDINAL_FLOWER_PETALS.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_CATTAIL.create(1), ItemPlantDrop.EnumItemPlantDrop.CATTAIL_HEAD.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_CAVE_GRASS.create(1), ItemPlantDrop.EnumItemPlantDrop.CAVE_GRASS_BLADES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_CAVE_MOSS.create(1), ItemPlantDrop.EnumItemPlantDrop.CAVE_MOSS_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_COPPER_IRIS.create(1), ItemPlantDrop.EnumItemPlantDrop.COPPER_IRIS_PETALS.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_CRIMSON_MIDDLE_GEM.create(1), new ItemStack(ItemRegistry.CRIMSON_MIDDLE_GEM, 1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_DEEP_WATER_CORAL.create(1), ItemPlantDrop.EnumItemPlantDrop.DEEP_WATER_CORAL_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_DRIED_SWAMP_REED.create(1), ItemMisc.EnumItemMisc.DRIED_SWAMP_REED.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_FLATHEAD_MUSHROOM.create(1), new ItemStack(ItemRegistry.FLAT_HEAD_MUSHROOM_ITEM));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_GOLDEN_CLUB.create(1), ItemPlantDrop.EnumItemPlantDrop.GOLDEN_CLUB_FLOWER_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_GREEN_MIDDLE_GEM.create(1), new ItemStack(ItemRegistry.GREEN_MIDDLE_GEM, 1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_LICHEN.create(1), ItemPlantDrop.EnumItemPlantDrop.LICHEN_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_MARSH_HIBISCUS.create(1), ItemPlantDrop.EnumItemPlantDrop.MARSH_HIBISCUS_FLOWER.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_MARSH_MALLOW.create(1), ItemPlantDrop.EnumItemPlantDrop.MARSH_MALLOW_FLOWER.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_MARSH_MARIGOLD.create(1), ItemPlantDrop.EnumItemPlantDrop.MARSH_MARIGOLD_FLOWER_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_MILKWEED.create(1), ItemPlantDrop.EnumItemPlantDrop.MILKWEED_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_MIRE_CORAL.create(1), ItemPlantDrop.EnumItemPlantDrop.MIRE_CORAL_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_MIRE_SNAIL_SHELL.create(1), ItemMisc.EnumItemMisc.MIRE_SNAIL_SHELL.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_MOSS.create(1), ItemPlantDrop.EnumItemPlantDrop.MOSS_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_NETTLE.create(1), ItemPlantDrop.EnumItemPlantDrop.NETTLE_LEAF.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_PHRAGMITES.create(1), ItemPlantDrop.EnumItemPlantDrop.PHRAGMITE_STEMS.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_PICKEREL_WEED.create(1), ItemPlantDrop.EnumItemPlantDrop.PICKEREL_WEED_FLOWER.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_SHOOTS.create(1), ItemPlantDrop.EnumItemPlantDrop.SHOOT_LEAVES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_SLUDGECREEP.create(1), ItemPlantDrop.EnumItemPlantDrop.SLUDGECREEP_LEAVES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_SOFT_RUSH.create(1), ItemPlantDrop.EnumItemPlantDrop.SOFT_RUSH_LEAVES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_SUNDEW.create(1), ItemPlantDrop.EnumItemPlantDrop.SUNDEW_HEAD.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_SWAMP_KELP.create(1), new ItemStack(ItemRegistry.SWAMP_KELP_ITEM));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_SWAMP_GRASS_TALL.create(1), ItemPlantDrop.EnumItemPlantDrop.SWAMP_TALL_GRASS_BLADES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_ROOTS.create(1), new ItemStack(ItemRegistry.TANGLED_ROOT));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_ROOTS.create(1), new ItemStack(BlockRegistry.GIANT_ROOT));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_WEEDWOOD_BARK.create(1), new ItemStack(BlockRegistry.LOG_WEEDWOOD, 1, Short.MAX_VALUE));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_WEEDWOOD_BARK.create(1), ItemMisc.EnumItemMisc.DRY_BARK.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_HANGER.create(1), ItemPlantDrop.EnumItemPlantDrop.HANGER_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_WATER_WEEDS.create(1), ItemPlantDrop.EnumItemPlantDrop.WATER_WEEDS_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_VENUS_FLY_TRAP.create(1), ItemPlantDrop.EnumItemPlantDrop.VENUS_FLY_TRAP_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_VOLARPAD.create(1), ItemPlantDrop.EnumItemPlantDrop.VOLARPAD_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_THORNS.create(1), ItemPlantDrop.EnumItemPlantDrop.THORNS_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_POISON_IVY.create(1), ItemPlantDrop.EnumItemPlantDrop.POISON_IVY_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_PITCHER_PLANT.create(1), ItemPlantDrop.EnumItemPlantDrop.PITCHER_PLANT_TRAP.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_GENERIC_LEAF.create(1), ItemPlantDrop.EnumItemPlantDrop.GENERIC_LEAF.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BLADDERWORT_FLOWER.create(1), ItemPlantDrop.EnumItemPlantDrop.BLADDERWORT_FLOWER_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_BLADDERWORT_STALK.create(1), ItemPlantDrop.EnumItemPlantDrop.BLADDERWORT_STALK_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_EDGE_SHROOM.create(1), ItemPlantDrop.EnumItemPlantDrop.EDGE_SHROOM_GILLS.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_EDGE_MOSS.create(1), ItemPlantDrop.EnumItemPlantDrop.EDGE_MOSS_CLUMP.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_EDGE_LEAF.create(1), ItemPlantDrop.EnumItemPlantDrop.EDGE_LEAF_ITEM.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_ROTBULB.create(1), ItemPlantDrop.EnumItemPlantDrop.ROTBULB_STALK.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_PALE_GRASS.create(1), ItemPlantDrop.EnumItemPlantDrop.PALE_GRASS_BLADES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_STRING_ROOTS.create(1), ItemPlantDrop.EnumItemPlantDrop.STRING_ROOT_FIBERS.create(1));
        PestleAndMortarRecipe.addRecipe(ItemCrushed.EnumItemCrushed.GROUND_CRYPTWEED.create(1), ItemPlantDrop.EnumItemPlantDrop.CRYPTWEED_BLADES.create(1));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack(ItemRegistry.SKULL_MASK));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack(ItemRegistry.WIGHTS_BANE));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack(ItemRegistry.SLUDGE_SLICER));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack(ItemRegistry.CRITTER_CRUNCHER));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack(ItemRegistry.HAG_HACKER));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack(ItemRegistry.VOODOO_DOLL));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack(ItemRegistry.SWIFT_PICK));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack(ItemRegistry.MAGIC_ITEM_MAGNET));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack(ItemRegistry.RING_OF_DISPERSION));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack(ItemRegistry.RING_OF_FLIGHT));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack(ItemRegistry.RING_OF_POWER));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack(ItemRegistry.RING_OF_RECRUITMENT));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack(ItemRegistry.RING_OF_SUMMONING));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack((Item)ItemRegistry.RING_OF_GATHERING));
        PestleAndMortarRecipe.addRecipe(ItemMisc.EnumItemMisc.LOOT_SCRAPS.create(1), new ItemStack(ItemRegistry.GEM_SINGER));
    }

    private static void registerAnimatorRecipes() {
        AnimatorRecipe.addRecipe(new AnimatorRecipe(ItemMisc.EnumItemMisc.SCROLL.create(1), 16, 16, LootTableRegistry.SCROLL){

            @Override
            public ItemStack onAnimated(World world, BlockPos pos, ItemStack stack) {
                LootContext.Builder lootBuilder;
                LootTable lootTable = world.func_184146_ak().func_186521_a(LootTableRegistry.SCROLL);
                List loot = lootTable.func_186462_a(world.field_73012_v, (lootBuilder = new LootContext.Builder((WorldServer)world)).func_186471_a());
                if (!loot.isEmpty()) {
                    return (ItemStack)loot.get(world.field_73012_v.nextInt(loot.size()));
                }
                return ItemStack.field_190927_a;
            }
        });
        AnimatorRecipe.addRecipe(new AnimatorRecipe(ItemMisc.EnumItemMisc.FABRICATED_SCROLL.create(1), 16, 16, LootTableRegistry.FABRICATED_SCROLL){

            @Override
            public ItemStack onAnimated(World world, BlockPos pos, ItemStack stack) {
                LootContext.Builder lootBuilder;
                LootTable lootTable = world.func_184146_ak().func_186521_a(LootTableRegistry.FABRICATED_SCROLL);
                List loot = lootTable.func_186462_a(world.field_73012_v, (lootBuilder = new LootContext.Builder((WorldServer)world)).func_186471_a());
                if (!loot.isEmpty()) {
                    return (ItemStack)loot.get(world.field_73012_v.nextInt(loot.size()));
                }
                return ItemStack.field_190927_a;
            }
        });
        AnimatorRecipe.addRecipe(new AnimatorRecipe(ItemMisc.EnumItemMisc.TAR_BEAST_HEART.create(1), 32, 32, ItemMisc.EnumItemMisc.TAR_BEAST_HEART_ANIMATED.create(1)));
        AnimatorRecipe.addRecipe(new AnimatorRecipe(ItemMisc.EnumItemMisc.INANIMATE_TARMINION.create(1), 8, 8, new ItemStack(ItemRegistry.TARMINION)).setRenderEntity(new ResourceLocation("thebetweenlands:tarminion")));
        if (BetweenlandsConfig.DEBUG.debug) {
            AnimatorRecipe.addRecipe(new AnimatorRecipe(new ItemStack(ItemRegistry.TEST_ITEM), 2, 1){

                @Override
                public boolean onRetrieved(World world, BlockPos pos, ItemStack stack) {
                    TileEntity te = world.func_175625_s(pos);
                    if (te instanceof TileEntityAnimator) {
                        TileEntityAnimator animator = (TileEntityAnimator)te;
                        EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, new ItemStack(ItemRegistry.TEST_ITEM));
                        entityitem.field_70159_w = 0.0;
                        entityitem.field_70179_y = 0.0;
                        entityitem.field_70181_x = 0.11000000298023224;
                        world.func_72838_d((Entity)entityitem);
                        animator.func_70299_a(0, ItemStack.field_190927_a);
                        return false;
                    }
                    return true;
                }
            });
        }
        AnimatorRecipe.addRecipe(new AnimatorRecipe(new ItemStack(ItemRegistry.SPORES), 8, 4, EntitySporeling.class).setRenderEntity(new ResourceLocation("thebetweenlands:sporeling")));
        AnimatorRecipe.addRecipe(new AnimatorRecipe(new ItemStack(BlockRegistry.ROOT_POD), 10, 6, EntityRootSprite.class).setRenderEntity(new ResourceLocation("thebetweenlands:root_sprite")));
        AnimatorRecipe.addRecipe(new AnimatorRecipe(new ItemStack(ItemRegistry.SPIRIT_TREE_FACE_SMALL_MASK), 24, 24, new ItemStack(ItemRegistry.SPIRIT_TREE_FACE_SMALL_MASK_ANIMATED)));
        AnimatorRecipe.addRecipe(new AnimatorRecipe(ItemMisc.EnumItemMisc.INANIMATE_ANGRY_PEBBLE.create(1), 1, 1, new ItemStack(ItemRegistry.ANGRY_PEBBLE)));
        AnimatorRecipe.addRecipe(new AnimatorRecipe(new ItemStack((Item)ItemRegistry.SLUDGE_WORM_EGG_SAC), 6, 3, new ItemStack(ItemRegistry.SLUDGE_WORM_ARROW)));
        AnimatorRecipe.addRecipe(new RingOfGatheringRespawnAnimatorRecipe());
        for (Item item : ItemRegistry.ITEMS) {
            if (!(item instanceof IAnimatorRepairable)) continue;
            AnimatorRecipe.addRecipe(new ToolRepairAnimatorRecipe((IAnimatorRepairable)item));
        }
    }

    private static void registerPurifierRecipes() {
        PurifierRecipe.addRecipe(new ItemStack(BlockRegistry.CRAGROCK, 1, BlockCragrock.EnumCragrockType.DEFAULT.getMetadata()), new ItemStack(BlockRegistry.CRAGROCK, 1, BlockCragrock.EnumCragrockType.MOSSY_1.getMetadata()));
        PurifierRecipe.addRecipe(new ItemStack(BlockRegistry.CRAGROCK, 1, BlockCragrock.EnumCragrockType.DEFAULT.getMetadata()), new ItemStack(BlockRegistry.CRAGROCK, 1, BlockCragrock.EnumCragrockType.MOSSY_2.getMetadata()));
        PurifierRecipe.addRecipe(new ItemStack(ItemRegistry.AQUA_MIDDLE_GEM, 1), new ItemStack(BlockRegistry.AQUA_MIDDLE_GEM_ORE));
        PurifierRecipe.addRecipe(new ItemStack(ItemRegistry.CRIMSON_MIDDLE_GEM, 1), new ItemStack(BlockRegistry.CRIMSON_MIDDLE_GEM_ORE));
        PurifierRecipe.addRecipe(new ItemStack(ItemRegistry.GREEN_MIDDLE_GEM, 1), new ItemStack(BlockRegistry.GREEN_MIDDLE_GEM_ORE));
        PurifierRecipe.addRecipe(new ItemStack(BlockRegistry.PURIFIED_SWAMP_DIRT), new ItemStack(BlockRegistry.SWAMP_DIRT));
        PurifierRecipe.addRecipe(ItemRegistry.DENTROTHYST_VIAL.createStack(0), ItemRegistry.DENTROTHYST_VIAL.createStack(1));
        PurifierRecipe.addRecipe(new IPurifierRecipe(){

            @Override
            public boolean matchesInput(ItemStack stack) {
                return !stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.WEEDWOOD_ROWBOAT && EntityWeedwoodRowboat.isTarred(stack);
            }

            @Override
            public ItemStack getOutput(ItemStack input) {
                ItemStack output = input.func_77946_l();
                NBTTagCompound compound = output.func_77978_p();
                NBTTagCompound attrs = compound.func_74775_l("attributes");
                attrs.func_82580_o("isTarred");
                if (attrs.func_82582_d()) {
                    compound.func_82580_o("attributes");
                }
                if (compound.func_82582_d()) {
                    output.func_77982_d(null);
                }
                return output;
            }
        });
    }

    private static void registerCenserRecipes() {
        AbstractCenserRecipe.addRecipe(new CenserRecipeDungeonFog());
        AbstractCenserRecipe.addRecipe(new CenserRecipeSapBall());
        AbstractCenserRecipe.addRecipe(new CenserRecipeWeepingBluePetal());
        AbstractCenserRecipe.addRecipe(new CenserRecipeStagnantWater());
        AbstractCenserRecipe.addRecipe(new CenserRecipePlantTonic());
        AbstractCenserRecipe.addRecipe(new CenserRecipeElixir());
        AbstractCenserRecipe.addRecipe(new CenserRecipeAspect());
        AbstractCenserRecipe.addRecipe(new CenserRecipeCremains());
        AbstractCenserRecipe.addRecipe(new CenserRecipeSwampWater());
    }
}

