/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.recipe;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class ShapelessOverrideDummyRecipe
implements IRecipe {
    private ResourceLocation regName;
    public final IRecipe override;
    public final IRecipe original;
    private NonNullList<Ingredient> ingredients;

    public ShapelessOverrideDummyRecipe(IRecipe override, IRecipe original) {
        this.override = override;
        this.original = original;
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        this.regName = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.regName;
    }

    public Class<IRecipe> getRegistryType() {
        return this.original.getRegistryType();
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        if (this.override.func_77569_a(inv, worldIn)) {
            return false;
        }
        return this.original.func_77569_a(inv, worldIn);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.original.func_77572_b(inv);
    }

    public boolean func_194133_a(int width, int height) {
        return this.original.func_194133_a(width, height);
    }

    public ItemStack func_77571_b() {
        return this.original.func_77571_b();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return this.original.func_179532_b(inv);
    }

    public NonNullList<Ingredient> func_192400_c() {
        if (this.ingredients == null) {
            NonNullList originalIngredients = this.original.func_192400_c();
            NonNullList overrideIngredients = this.override.func_192400_c();
            this.ingredients = NonNullList.func_191197_a((int)originalIngredients.size(), (Object)Ingredient.field_193370_a);
            for (int i = 0; i < originalIngredients.size(); ++i) {
                Ingredient originalIngredient = (Ingredient)originalIngredients.get(i);
                if (i < overrideIngredients.size() && originalIngredient != Ingredient.field_193370_a) {
                    Ingredient overrideIngredient = (Ingredient)overrideIngredients.get(i);
                    this.ingredients.set(i, (Object)new OverrideIngredient(this, overrideIngredient, originalIngredient));
                    continue;
                }
                this.ingredients.set(i, (Object)originalIngredient);
            }
        }
        return this.ingredients;
    }

    public String func_193358_e() {
        return this.original.func_193358_e();
    }

    protected void invalidate() {
        this.ingredients = null;
    }

    public static class OverrideIngredient
    extends Ingredient {
        public final Ingredient removed;
        public final Ingredient original;
        public final ShapelessOverrideDummyRecipe recipe;
        private ItemStack[] stacks = null;
        private IntList itemIds = null;
        private int originalMatchingStacksLength = -1;
        private int originalValidItemStacksPackedSize = -1;

        public OverrideIngredient(ShapelessOverrideDummyRecipe recipe, Ingredient removed, Ingredient original) {
            super(0);
            this.recipe = recipe;
            this.removed = removed;
            this.original = original;
        }

        public ItemStack[] func_193365_a() {
            ItemStack[] originalStacks = this.original.func_193365_a();
            if (this.stacks == null || originalStacks.length != this.originalMatchingStacksLength) {
                ArrayList<ItemStack> matchingStacks = new ArrayList<ItemStack>(originalStacks.length);
                for (ItemStack stack : originalStacks) {
                    if (this.removed.apply(stack)) continue;
                    matchingStacks.add(stack);
                }
                this.stacks = matchingStacks.toArray(new ItemStack[0]);
                this.originalMatchingStacksLength = originalStacks.length;
            }
            return this.stacks;
        }

        public boolean apply(@Nullable ItemStack stack) {
            if (this.removed.apply(stack)) {
                return false;
            }
            return this.original.apply(stack);
        }

        public IntList func_194139_b() {
            IntList original = this.original.func_194139_b();
            if (this.itemIds == null || this.originalValidItemStacksPackedSize != original.size()) {
                this.itemIds = new IntArrayList(original);
                this.itemIds.removeAll((IntCollection)this.removed.func_194139_b());
                this.originalValidItemStacksPackedSize = original.size();
            }
            return this.itemIds;
        }

        protected void invalidate() {
            this.stacks = null;
            this.itemIds = null;
            this.recipe.invalidate();
        }

        public boolean isSimple() {
            return this.original.isSimple();
        }
    }

    public static class ShapedOverrideDummyRecipe
    extends ShapelessOverrideDummyRecipe
    implements IShapedRecipe {
        public final IShapedRecipe shapedOriginal;

        public ShapedOverrideDummyRecipe(IRecipe override, IShapedRecipe original) {
            super(override, (IRecipe)original);
            this.shapedOriginal = original;
        }

        public int getRecipeWidth() {
            return this.shapedOriginal.getRecipeWidth();
        }

        public int getRecipeHeight() {
            return this.shapedOriginal.getRecipeHeight();
        }
    }
}

