/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.GameRules;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import thebetweenlands.common.network.MessageBase;
import thebetweenlands.common.registries.GameruleRegistry;

public class MessageSyncGameRules
extends MessageBase {
    private Map<String, String> values = new HashMap<String, String>();

    public MessageSyncGameRules() {
    }

    public MessageSyncGameRules(Collection<String> gameRules) {
        for (String gameRule : gameRules) {
            this.values.put(gameRule, GameruleRegistry.getGameRuleStringValue(gameRule));
        }
    }

    @Override
    public void serialize(PacketBuffer buf) throws IOException {
        buf.func_150787_b(this.values.size());
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            buf.func_180714_a(entry.getKey());
            buf.func_180714_a(entry.getValue());
        }
    }

    @Override
    public void deserialize(PacketBuffer buf) throws IOException {
        int entries = buf.func_150792_a();
        for (int i = 0; i < entries; ++i) {
            this.values.put(buf.func_150789_c(256), buf.func_150789_c(256));
        }
    }

    @Override
    public IMessage process(MessageContext ctx) {
        GameRules gameRules;
        if (ctx.side == Side.CLIENT && (gameRules = GameruleRegistry.getGameRules()) != null) {
            for (Map.Entry<String, String> entry : this.values.entrySet()) {
                gameRules.func_82764_b(entry.getKey(), entry.getValue());
            }
        }
        return null;
    }
}

