/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.herblore;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemDentrothystFluidVial
extends UniversalBucket
implements ItemRegistry.IMultipleItemModelDefinition {
    public ItemDentrothystFluidVial() {
        super(1000, ItemStack.field_190927_a, true);
        this.func_77627_a(true);
        this.func_77625_d(16);
        this.func_77656_e(0);
        this.func_77637_a(BLCreativeTabs.HERBLORE);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74782_a("Fluid", (NBTBase)new NBTTagCompound());
        stack.func_77982_d(nbt);
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        HashMap<Integer, ResourceLocation> models = new HashMap<Integer, ResourceLocation>();
        models.put(0, new ResourceLocation(this.getRegistryName().toString() + "_green"));
        models.put(1, new ResourceLocation(this.getRegistryName().toString() + "_orange"));
        return models;
    }

    public int getItemStackLimit(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack != null) {
            return 1;
        }
        return super.getItemStackLimit(stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return new DentrothystFluidVialFluidHandler(stack, this.getCapacity());
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() >= 2) {
            return this.func_77658_a() + ".unknown";
        }
        return this.func_77658_a() + (stack.func_77960_j() == 0 ? "_green" : "_orange");
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        String unlocName = this.getEmpty(stack).func_77977_a();
        if (fluidStack == null) {
            return I18n.func_74838_a((String)(unlocName + ".name")).trim();
        }
        String fluidUnlocKey = unlocName + "." + fluidStack.getUnlocalizedName() + ".name";
        if (I18n.func_94522_b((String)fluidUnlocKey)) {
            return I18n.func_74838_a((String)fluidUnlocKey).trim();
        }
        return I18n.func_74837_a((String)(this.getEmpty(stack).func_77977_a() + ".filled.name"), (Object[])new Object[]{fluidStack.getFluid().getRarity((FluidStack)fluidStack).field_77937_e + fluidStack.getLocalizedName() + TextFormatting.WHITE});
    }

    public void func_150895_a(@Nullable CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            for (Fluid fluid : net.minecraftforge.fluids.FluidRegistry.getRegisteredFluids().values()) {
                FluidStack fs = new FluidStack(fluid, this.getCapacity());
                ItemStack stack = new ItemStack((Item)this, 1, i);
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (fluidHandler == null || fluidHandler.fill(fs, true) != fs.amount) continue;
                ItemStack filled = fluidHandler.getContainer();
                subItems.add((Object)filled);
            }
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.getEmpty(stack).func_190926_b();
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        if (!this.getEmpty(itemStack).func_190926_b()) {
            return this.getEmpty(itemStack).func_77946_l();
        }
        return super.getContainerItem(itemStack);
    }

    @Nullable
    public FluidStack getFluid(ItemStack container) {
        NBTTagCompound tagCompound = container.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("Fluid"));
    }

    public ItemStack getEmpty(ItemStack stack) {
        return stack.func_77960_j() == 1 ? new ItemStack((Item)ItemRegistry.DENTROTHYST_VIAL, stack.func_190916_E(), 2) : new ItemStack((Item)ItemRegistry.DENTROTHYST_VIAL, stack.func_190916_E(), 0);
    }

    public ItemStack withFluid(int meta, Fluid fluid) {
        FluidStack fs = new FluidStack(fluid, this.getCapacity());
        ItemStack stack = new ItemStack((Item)this, 1, meta);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        fluidHandler.fill(fs, true);
        return fluidHandler.getContainer();
    }

    public boolean canFillWith(ItemStack stack, FluidStack fluid) {
        return fluid.getFluid() == FluidRegistry.FOG || fluid.getFluid() == FluidRegistry.SHALLOWBREATH;
    }

    private static final class DentrothystFluidVialFluidHandler
    extends FluidHandlerItemStackSimple {
        public DentrothystFluidVialFluidHandler(ItemStack container, int capacity) {
            super(container, capacity);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return ((ItemDentrothystFluidVial)this.container.func_77973_b()).canFillWith(this.container, fluid);
        }

        @Nullable
        public FluidStack getFluid() {
            return this.container.func_77973_b() != ItemRegistry.DENTROTHYST_VIAL ? ((ItemDentrothystFluidVial)this.container.func_77973_b()).getFluid(this.container) : null;
        }

        protected void setContainerToEmpty() {
            this.container = ((ItemDentrothystFluidVial)this.container.func_77973_b()).getEmpty(this.container).func_77946_l();
        }
    }
}

