/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.herblore;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.container.BlockAspectVial;
import thebetweenlands.common.block.terrain.BlockDentrothyst;
import thebetweenlands.common.item.ITintedItem;
import thebetweenlands.common.registries.AspectRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityAspectVial;
import thebetweenlands.util.ColorUtils;
import thebetweenlands.util.TranslationHelper;

public class ItemAspectVial
extends Item
implements ITintedItem,
ItemRegistry.IMultipleItemModelDefinition {
    public ItemAspectVial() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(BLCreativeTabs.HERBLORE);
        this.func_77642_a(ItemRegistry.DENTROTHYST_VIAL);
        this.func_185043_a(new ResourceLocation("aspect"), (stack, worldIn, entityIn) -> {
            List<Aspect> itemAspects = ItemAspectContainer.fromItem(stack).getAspects();
            if (GuiScreen.func_146272_n() && itemAspects.size() >= 1) {
                return AspectRegistry.ASPECT_TYPES.indexOf(itemAspects.get((int)0).type) + 1;
            }
            return 0.0f;
        });
    }

    public String func_77653_i(ItemStack stack) {
        List<Aspect> itemAspects = ItemAspectContainer.fromItem(stack).getAspects();
        if (itemAspects.size() >= 1) {
            Aspect aspect = itemAspects.get(0);
            return I18n.func_74837_a((String)(this.func_77657_g(stack) + ".filled.name"), (Object[])new Object[]{aspect.type.getName(), aspect.getRoundedDisplayAmount()}).trim();
        }
        return super.func_77653_i(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this, 1, 0));
            list.add((Object)new ItemStack((Item)this, 1, 1));
            for (IAspectType aspect : AspectRegistry.ASPECT_TYPES) {
                ItemStack stackGreen = new ItemStack((Item)this, 1, 0);
                ItemAspectContainer greenAspectContainer = ItemAspectContainer.fromItem(stackGreen);
                greenAspectContainer.add(aspect, 2000);
                list.add((Object)stackGreen);
                ItemStack stackOrange = new ItemStack((Item)this, 1, 1);
                ItemAspectContainer orangeAspectContainer = ItemAspectContainer.fromItem(stackOrange);
                orangeAspectContainer.add(aspect, 2000);
                list.add((Object)stackOrange);
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        try {
            switch (stack.func_77952_i()) {
                case 0: {
                    return "item.thebetweenlands.aspect_vial.green";
                }
                case 1: {
                    return "item.thebetweenlands.aspect_vial.orange";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "item.thebetweenlands.unknown";
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        ItemStack containerEmpty;
        switch (itemStack.func_77952_i()) {
            default: {
                containerEmpty = ItemRegistry.DENTROTHYST_VIAL.createStack(0);
                break;
            }
            case 1: {
                containerEmpty = ItemRegistry.DENTROTHYST_VIAL.createStack(2);
            }
        }
        return containerEmpty;
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        HashMap<Integer, ResourceLocation> models = new HashMap<Integer, ResourceLocation>();
        models.put(0, new ResourceLocation(this.getRegistryName().toString() + "_green"));
        models.put(1, new ResourceLocation(this.getRegistryName().toString() + "_orange"));
        return models;
    }

    @Override
    public int getColorMultiplier(ItemStack stack, int tintIndex) {
        switch (tintIndex) {
            case 0: {
                List<Aspect> aspects = ItemAspectContainer.fromItem(stack).getAspects();
                if (aspects.size() > 0) {
                    Aspect aspect = aspects.get(0);
                    float[] aspectRGBA = ColorUtils.getRGBA(aspect.type.getColor());
                    return ColorUtils.toHex(aspectRGBA[0], aspectRGBA[1], aspectRGBA[2], 1.0f);
                }
                return -1;
            }
            case 2: {
                return -1;
            }
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        List<Aspect> itemAspects;
        if (world != null && !(itemAspects = ItemAspectContainer.fromItem(stack).getAspects()).isEmpty() && itemAspects.get((int)0).type == AspectRegistry.BYARIIS) {
            tooltip.add(TranslationHelper.translateToLocal("tooltip.bl.aspectvial.byariis.fuel", new Object[0]));
        }
    }

    public static void placeAspectVial(World world, BlockPos pos, int vialType, Aspect aspect) {
        world.func_180501_a(pos, BlockRegistry.ASPECT_VIAL_BLOCK.func_176223_P().func_177226_a(BlockAspectVial.TYPE, (Comparable)((Object)BlockDentrothyst.EnumDentrothyst.values()[vialType])), 2);
        TileEntityAspectVial tile = (TileEntityAspectVial)world.func_175625_s(pos);
        if (tile != null) {
            tile.setAspect(aspect);
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return world.func_180495_p(pos).func_177230_c() == BlockRegistry.ASPECT_VIAL_BLOCK;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        List<Aspect> itemAspects = ItemAspectContainer.fromItem(stack).getAspects();
        if (player.func_70093_af() && itemAspects.size() == 1 && facing == EnumFacing.UP && world.func_175623_d(pos.func_177984_a()) && BlockRegistry.ASPECT_VIAL_BLOCK.func_176196_c(world, pos.func_177984_a())) {
            if (!world.field_72995_K) {
                ItemAspectVial.placeAspectVial(world, pos.func_177984_a(), stack.func_77952_i(), itemAspects.get(0));
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }
}

