/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.book;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.aspect.AspectItem;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.herblore.book.ManualCategory;
import thebetweenlands.common.herblore.book.Page;
import thebetweenlands.common.herblore.book.PageCreators;
import thebetweenlands.common.herblore.book.widgets.ButtonWidget;
import thebetweenlands.common.herblore.book.widgets.PictureWidget;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.herblore.elixir.effects.ElixirEffect;
import thebetweenlands.common.registries.AspectRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class HLEntryRegistry {
    public static ArrayList<ManualCategory> CATEGORIES = new ArrayList();
    public static ManualCategory aspectCategory;
    public static ArrayList<Page> aspectPages;
    public static ArrayList<Page> itemPages;
    public static ArrayList<Page> elixirPages;
    public static Item manualType;
    public static ManualCategory elixirCategory;

    @SideOnly(value=Side.CLIENT)
    public static void init() {
        CATEGORIES.clear();
        HLEntryRegistry.initAspectEntries();
        HLEntryRegistry.initElixirEntries();
    }

    @SideOnly(value=Side.CLIENT)
    public static void initAspectEntries() {
        int indexPages = 3;
        aspectPages.clear();
        itemPages.clear();
        ArrayList<Page> temp = new ArrayList<Page>();
        ArrayList<Page> entryPages = new ArrayList<Page>();
        aspectPages.add(new Page("aspect_info", false, manualType, new PictureWidget(16, 12, "thebetweenlands:textures/gui/manual/manual_hl.png", 122, 150, 454, 271, 1024.0, 1024.0)));
        for (IAspectType iAspectType : AspectRegistry.ASPECT_TYPES) {
            aspectPages.addAll(PageCreators.AspectPages(iAspectType, manualType));
        }
        entryPages.add(new Page("aspect_list", false, manualType, new PictureWidget(16, 12, "thebetweenlands:textures/gui/manual/manual_hl.png", 122, 150, 162, 271, 1024.0, 1024.0)));
        int pageNumber = 1;
        for (Page page : aspectPages) {
            page.setPageNumber(pageNumber);
            temp.add(page);
            ++pageNumber;
        }
        entryPages.addAll(PageCreators.pageCreatorButtons(temp, manualType));
        indexPages += PageCreators.pageCreatorButtons(temp, manualType).size();
        Map<AspectItem, List<AspectManager.AspectItemEntry>> map = AspectManager.getRegisteredItems();
        for (Map.Entry<AspectItem, List<AspectManager.AspectItemEntry>> entry : map.entrySet()) {
            if (entry.getKey() == null) continue;
            itemPages.addAll(PageCreators.AspectItemPages(entry.getKey(), manualType));
        }
        ArrayList<Page> arrayList = new ArrayList<Page>();
        int n = pageNumber++;
        while (itemPages.size() > 0) {
            Page currentFirst = null;
            block4: for (Page page : itemPages) {
                if (currentFirst == null) {
                    currentFirst = page;
                    continue;
                }
                String pageName = page.pageName.toLowerCase();
                char[] characters = pageName.toCharArray();
                String pageNameFirst = currentFirst.pageName.toLowerCase();
                char[] charactersFirst = pageNameFirst.toCharArray();
                for (int i = 0; i < characters.length; ++i) {
                    if (charactersFirst.length <= i) continue;
                    if (Character.valueOf(characters[i]).compareTo(Character.valueOf(charactersFirst[i])) > 0) continue block4;
                    if (Character.valueOf(characters[i]).compareTo(Character.valueOf(charactersFirst[i])) >= 0) continue;
                    currentFirst = page;
                    continue block4;
                }
            }
            itemPages.remove(currentFirst);
            if (currentFirst != null) {
                currentFirst.setPageNumber(pageNumber);
            }
            ++pageNumber;
            arrayList.add(currentFirst);
        }
        arrayList.add(0, new Page("ingredient_info", false, manualType, new PictureWidget(16, 12, "thebetweenlands:textures/gui/manual/manual_hl.png", 122, 150, 600, 271, 1024.0, 1024.0)).setPageNumber(n));
        entryPages.add(new Page("ingredient_list", false, manualType, new PictureWidget(16, 12, "thebetweenlands:textures/gui/manual/manual_hl.png", 122, 150, 308, 271, 1024.0, 1024.0)));
        ArrayList<Page> buttons = PageCreators.pageCreatorButtons(arrayList, manualType);
        indexPages += buttons.size();
        entryPages.addAll(buttons);
        entryPages.addAll(temp);
        entryPages.addAll(arrayList);
        entryPages.add(0, new Page("intro_1", false, manualType, new PictureWidget(16, 12, "thebetweenlands:textures/gui/manual/manual_hl.png", 122, 150, 16, 271, 1024.0, 1024.0), new ButtonWidget(31, 49, 87, 9, 6, false), new ButtonWidget(31, 68, 55, 9, 1, true), new ButtonWidget(31, 86, 73, 9, n, true)));
        aspectCategory = new ManualCategory(entryPages, 1, manualType, "aspect_category", true, indexPages);
        CATEGORIES.add(aspectCategory);
    }

    @SideOnly(value=Side.CLIENT)
    public static void initElixirEntries() {
        int i;
        char[] charactersFirst;
        String pageNameFirst;
        char[] characters;
        String pageName;
        Page currentFirst;
        elixirPages.clear();
        ArrayList<Page> infusionPages = new ArrayList<Page>();
        ArrayList<Page> antiInfusionPages = new ArrayList<Page>();
        for (ElixirEffect effect : ElixirEffectRegistry.getEffects()) {
            if (effect == ElixirEffectRegistry.EFFECT_PETRIFY || effect == ElixirEffectRegistry.EFFECT_ISOLATEDSENSES || effect == ElixirEffectRegistry.EFFECT_LIMBLESS || effect == ElixirEffectRegistry.EFFECT_DEFORMED || effect == ElixirEffectRegistry.EFFECT_HUNTERSSENSEMASTER || effect == ElixirEffectRegistry.EFFECT_WINGS || effect == ElixirEffectRegistry.EFFECT_GILLSGROWTH) continue;
            if (effect.isAntiInfusion()) {
                antiInfusionPages.addAll(PageCreators.elixirPages(ItemRegistry.ELIXIR.getElixirItem(effect, 1, 1, 0), manualType, effect));
                continue;
            }
            infusionPages.addAll(PageCreators.elixirPages(ItemRegistry.ELIXIR.getElixirItem(effect, 1, 1, 0), manualType, effect));
        }
        ArrayList<Page> temp = new ArrayList<Page>();
        while (infusionPages.size() > 0) {
            currentFirst = null;
            block2: for (Page page : infusionPages) {
                if (currentFirst == null) {
                    currentFirst = page;
                    continue;
                }
                pageName = page.pageName.toLowerCase();
                characters = pageName.toCharArray();
                pageNameFirst = currentFirst.pageName.toLowerCase();
                charactersFirst = pageNameFirst.toCharArray();
                for (i = 0; i < characters.length; ++i) {
                    if (charactersFirst.length <= i) continue;
                    if (Character.valueOf(characters[i]).compareTo(Character.valueOf(charactersFirst[i])) > 0) continue block2;
                    if (Character.valueOf(characters[i]).compareTo(Character.valueOf(charactersFirst[i])) >= 0) continue;
                    currentFirst = page;
                    continue block2;
                }
            }
            infusionPages.remove(currentFirst);
            temp.add(currentFirst);
        }
        infusionPages.clear();
        infusionPages.addAll(temp);
        infusionPages.add(0, new Page("infusions", false, manualType, new PictureWidget(16, 12, "thebetweenlands:textures/gui/manual/manual_hl.png", 122, 150, 16, 451, 1024.0, 1024.0)).setPageNumber(1));
        temp.clear();
        while (antiInfusionPages.size() > 0) {
            currentFirst = null;
            block5: for (Page page : antiInfusionPages) {
                if (currentFirst == null) {
                    currentFirst = page;
                    continue;
                }
                pageName = page.pageName.toLowerCase();
                characters = pageName.toCharArray();
                pageNameFirst = currentFirst.pageName.toLowerCase();
                charactersFirst = pageNameFirst.toCharArray();
                for (i = 0; i < characters.length; ++i) {
                    if (charactersFirst.length <= i) continue;
                    if (Character.valueOf(characters[i]).compareTo(Character.valueOf(charactersFirst[i])) > 0) continue block5;
                    if (Character.valueOf(characters[i]).compareTo(Character.valueOf(charactersFirst[i])) >= 0) continue;
                    currentFirst = page;
                    continue block5;
                }
            }
            antiInfusionPages.remove(currentFirst);
            temp.add(currentFirst);
        }
        antiInfusionPages.clear();
        antiInfusionPages.addAll(temp);
        antiInfusionPages.add(0, new Page("infusions", false, manualType, new PictureWidget(16, 12, "thebetweenlands:textures/gui/manual/manual_hl.png", 122, 150, 162, 451, 1024.0, 1024.0)).setPageNumber(infusionPages.size()));
        elixirPages.clear();
        elixirPages.addAll(infusionPages);
        elixirPages.addAll(antiInfusionPages);
        elixirCategory = new ManualCategory(elixirPages, 2, manualType, "elixir_category");
        CATEGORIES.add(elixirCategory);
    }

    static {
        aspectPages = new ArrayList();
        itemPages = new ArrayList();
        elixirPages = new ArrayList();
        manualType = ItemRegistry.MANUAL_HL;
    }
}

