/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.rowboat;

import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import thebetweenlands.util.MathUtils;
import thebetweenlands.util.phys.DiffEqSolver;
import thebetweenlands.util.phys.PendulumSimulation;
import thebetweenlands.util.phys.RungeKuttaSolver;

public final class Lantern {
    private static final float MOVE_FORCE = 6.0f;
    private final PendulumSimulation sim;
    private final DiffEqSolver solver;
    private float prevAngle;
    private Vec3d position = Vec3d.field_186680_a;

    public Lantern(float length, float friction) {
        this.sim = new PendulumSimulation(length, friction);
        this.solver = new RungeKuttaSolver(this.sim);
    }

    public float getAngle(float t) {
        return MathUtils.lerpAngle(this.prevAngle, this.sim.getAngle(), t);
    }

    public void tick(Vec3d position, float yaw) {
        Vec3d m = position.func_178788_d(this.position);
        if (m.func_189985_c() < 1.0) {
            this.move(m, yaw);
        }
        this.position = position;
        this.prevAngle = this.sim.getAngle();
        this.solver.step(0.05f);
    }

    private void move(Vec3d motion, float yaw) {
        float vx = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float vz = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        this.sim.move(6.0f * (float)(((double)vx * motion.field_72450_a + (double)vz * motion.field_72449_c) / (double)MathHelper.func_76129_c((float)(vx * vx + vz * vz))), 6.0f * (float)motion.field_72448_b);
    }
}

