/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.projectiles;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.entity.mobs.EntityChiromawGreeblingRider;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityBetweenstonePebble
extends Entity
implements IProjectile,
IThrowableEntity {
    private static final Predicate<Entity> ARROW_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_.func_70067_L();
        }
    }});
    private static final DataParameter<Byte> CRITICAL = EntityDataManager.func_187226_a(EntityBetweenstonePebble.class, (DataSerializer)DataSerializers.field_187191_a);
    public Entity shootingEntity;
    private double damage = 0.5;
    private int knockbackStrength;
    private int ticksInAir;

    public EntityBetweenstonePebble(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityBetweenstonePebble(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public EntityBetweenstonePebble(World world, EntityLivingBase shooter) {
        this(world, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70161_v);
        this.shootingEntity = shooter;
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setKnockbackStrength(int knockbackStrengthIn) {
        this.knockbackStrength = knockbackStrengthIn;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void shoot(Entity shooter, float pitch, float yaw, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70071_h_() {
        Entity entity;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa >= 1200) {
            this.func_70106_y();
        }
        ++this.ticksInAir;
        Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
        vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if ((entity = this.findEntityOnPath(vec3d1, vec3d)) != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
            if (this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.onHit(raytraceresult);
        }
        if (this.getIsCritical()) {
            for (int k = 0; k < 4; ++k) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + this.field_70159_w * (double)k / 4.0, this.field_70163_u + this.field_70181_x * (double)k / 4.0, this.field_70161_v + this.field_70179_y * (double)k / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y, new int[0]);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f1 = 0.99f;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f3 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f1 = 0.6f;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        this.field_70159_w *= (double)f1;
        this.field_70181_x *= (double)f1;
        this.field_70179_y *= (double)f1;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.05f;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    protected void onHit(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            int i = MathHelper.func_76143_f((double)((double)f * this.damage));
            if (this.getIsCritical()) {
                i += this.field_70146_Z.nextInt(i / 2 + 2);
            }
            DamageSource damagesource = this.shootingEntity == null ? DamageSource.func_76356_a((Entity)this, (Entity)this) : DamageSource.func_76356_a((Entity)this, (Entity)this.shootingEntity);
            if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
                entity.func_70015_d(5);
            }
            if (entity.func_70097_a(damagesource, (float)i)) {
                if (entity instanceof EntityLivingBase) {
                    float f1;
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                    if (this.knockbackStrength > 0 && (f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                        entitylivingbase.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * (double)0.6f / (double)f1, 0.1, this.field_70179_y * (double)this.knockbackStrength * (double)0.6f / (double)f1);
                    }
                    if (this.shootingEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.shootingEntity);
                        EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (Entity)entitylivingbase);
                        if (this.shootingEntity instanceof EntityChiromawGreeblingRider) {
                            this.func_130014_f_().func_184133_a(null, this.shootingEntity.func_180425_c(), (SoundEvent)SoundRegistry.GREEBLING_GIGGLE, SoundCategory.HOSTILE, 1.0f, 1.0f);
                        }
                    }
                    if (this.shootingEntity != null && entitylivingbase != this.shootingEntity && entitylivingbase instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.shootingEntity).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                if (!(entity instanceof EntityEnderman)) {
                    this.func_70106_y();
                }
            } else {
                this.field_70159_w *= (double)-0.1f;
                this.field_70181_x *= (double)-0.1f;
                this.field_70179_y *= (double)-0.1f;
                this.ticksInAir = 0;
                if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                    this.func_70106_y();
                }
            }
        } else {
            this.func_70106_y();
        }
        this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.SLINGSHOT_HIT, SoundCategory.HOSTILE, 1.0f, 1.0f + (this.func_130014_f_().field_73012_v.nextFloat() - this.func_130014_f_().field_73012_v.nextFloat()) * 0.8f);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
    }

    @Nullable
    protected Entity findEntityOnPath(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ARROW_TARGETS);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == this.shootingEntity && this.ticksInAir < 5 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CRITICAL, (Object)0);
    }

    public void setIsCritical(boolean critical) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        if (critical) {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public boolean getIsCritical() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        return (b0 & 1) != 0;
    }

    public boolean func_70075_an() {
        return false;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74769_h("damage");
        }
        this.setIsCritical(compound.func_74767_n("crit"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74780_a("damage", this.damage);
        compound.func_74757_a("crit", this.getIsCritical());
    }

    public Entity getThrower() {
        return this.shootingEntity;
    }

    public void setThrower(Entity entity) {
        this.shootingEntity = entity;
    }
}

