/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.entity.mobs.EntityWight;

public class EntityFortressBossSpawner
extends EntityMob
implements IEntityBL {
    protected static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(EntityFortressBossSpawner.class, (DataSerializer)DataSerializers.field_187203_m);
    public int spawnDelay = 40;
    public final int maxSpawnDelay = 40;
    private Entity cachedOwner;

    public EntityFortressBossSpawner(World world) {
        super(world);
        this.func_70105_a(0.4f, 0.4f);
    }

    public EntityFortressBossSpawner(World world, Entity source) {
        super(world);
        this.setOwner(source);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(OWNER, (Object)Optional.absent());
    }

    public void setOwner(@Nullable Entity entity) {
        this.func_184212_Q().func_187227_b(OWNER, (Object)(entity == null ? Optional.absent() : Optional.of((Object)entity.func_110124_au())));
    }

    @Nullable
    public UUID getOwnerUUID() {
        Optional uuid = (Optional)this.func_184212_Q().func_187225_a(OWNER);
        return uuid.isPresent() ? (UUID)uuid.get() : null;
    }

    @Nullable
    public Entity getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid == null) {
            this.cachedOwner = null;
        } else if (this.cachedOwner == null || !this.cachedOwner.func_70089_S() || !this.cachedOwner.func_110124_au().equals(uuid)) {
            this.cachedOwner = null;
            for (Entity entity : this.func_130014_f_().func_72872_a(Entity.class, this.func_174813_aQ().func_72314_b(64.0, 64.0, 64.0))) {
                if (!entity.func_110124_au().equals(uuid)) continue;
                this.cachedOwner = entity;
                break;
            }
        }
        return this.cachedOwner;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("spawnDelay", this.spawnDelay);
        if (this.getOwnerUUID() != null) {
            nbt.func_186854_a("owner", this.getOwnerUUID());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.spawnDelay = nbt.func_74762_e("spawnDelay");
        if (nbt.func_186855_b("owner")) {
            this.func_184212_Q().func_187227_b(OWNER, (Object)Optional.of((Object)nbt.func_186857_a("owner")));
        } else {
            this.func_184212_Q().func_187227_b(OWNER, (Object)Optional.absent());
        }
    }

    public void func_70071_h_() {
        Entity owner;
        if (!this.field_70170_p.field_72995_K && (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL || this.getOwner() != null && !this.getOwner().func_70089_S())) {
            this.func_70106_y();
            return;
        }
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && (owner = this.getOwner()) != null) {
            for (int i = 0; i < 3; ++i) {
                double sx = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double sy = this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25;
                double sz = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double ex = owner.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)owner.field_70130_N;
                double ey = owner.field_70163_u + this.field_70146_Z.nextDouble() * (double)owner.field_70131_O - 0.25;
                double ez = owner.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)owner.field_70130_N;
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, sx, sy, sz, ex - sx, ey - sy, ez - sz, new int[0]);
            }
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
        } else if (!this.field_70170_p.field_72995_K) {
            EntityWight wight = new EntityWight(this.field_70170_p);
            wight.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            wight.setCanTurnVolatile(false);
            wight.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            wight.func_70606_j(wight.func_110138_aP());
            if (this.getOwner() instanceof EntityLiving) {
                wight.func_70624_b(((EntityLiving)this.getOwner()).func_70638_az());
            }
            this.field_70170_p.func_72838_d((Entity)wight);
            this.func_70106_y();
        } else {
            for (int i = 0; i < 6; ++i) {
                this.spawnVolatileParticles();
            }
            this.func_70106_y();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnVolatileParticles() {
        double radius = 0.3f;
        double cx = this.field_70165_t;
        double cy = this.field_70163_u + 0.35;
        double cz = this.field_70161_v;
        for (int i = 0; i < 8; ++i) {
            double px = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            double py = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            double pz = this.field_70170_p.field_73012_v.nextFloat() * 0.7f;
            Vec3d vec = new Vec3d(px, py, pz).func_178788_d(new Vec3d((double)0.35f, (double)0.35f, (double)0.35f)).func_72432_b();
            px = cx + vec.field_72450_a * (double)0.3f;
            py = cy + vec.field_72448_b * (double)0.3f;
            pz = cz + vec.field_72449_c * (double)0.3f;
            BLParticles.STEAM_PURIFIER.spawn(this.field_70170_p, px, py, pz);
        }
    }

    public void func_191986_a(float strafe, float up, float forward) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public boolean func_70652_k(Entity target) {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }
}

