/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.ai;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import thebetweenlands.common.entity.ai.IPathObstructionAwareEntity;

public class ObstructionAwareWalkNodeProcessor<T extends EntityLiving>
extends WalkNodeProcessor {
    private T callbackEntity;

    public void setCallback(T callback) {
        this.callbackEntity = callback;
    }

    public int func_186320_a(PathPoint[] pathOptions, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
        int k;
        boolean avoidPathNX;
        int k2;
        int openedNodeCount = 0;
        int stepHeight = 0;
        PathNodeType nodeTypeAbove = this.getPathNodeType(this.field_186326_b, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(nodeTypeAbove) >= 0.0f) {
            stepHeight = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        BlockPos posDown = new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c).func_177977_b();
        double height = (double)currentPoint.field_75837_b - (1.0 - this.field_176169_a.func_180495_p((BlockPos)posDown).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)posDown).field_72337_e);
        PathPoint[] pathsPZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, height, EnumFacing.SOUTH, true);
        PathPoint[] pathsNX = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, stepHeight, height, EnumFacing.WEST, true);
        PathPoint[] pathsPX = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, stepHeight, height, EnumFacing.EAST, true);
        PathPoint[] pathsNZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, height, EnumFacing.NORTH, true);
        for (k2 = 0; k2 < pathsPZ.length; ++k2) {
            if (pathsPZ[k2] == null || pathsPZ[k2].field_75842_i || !(pathsPZ[k2].func_75829_a(targetPoint) < maxDistance)) continue;
            pathOptions[openedNodeCount++] = pathsPZ[k2];
        }
        for (k2 = 0; k2 < pathsNX.length; ++k2) {
            if (pathsNX[k2] == null || pathsNX[k2].field_75842_i || !(pathsNX[k2].func_75829_a(targetPoint) < maxDistance)) continue;
            pathOptions[openedNodeCount++] = pathsNX[k2];
        }
        for (k2 = 0; k2 < pathsPX.length; ++k2) {
            if (pathsPX[k2] == null || pathsPX[k2].field_75842_i || !(pathsPX[k2].func_75829_a(targetPoint) < maxDistance)) continue;
            pathOptions[openedNodeCount++] = pathsPX[k2];
        }
        for (k2 = 0; k2 < pathsNZ.length; ++k2) {
            if (pathsNZ[k2] == null || pathsNZ[k2].field_75842_i || !(pathsNZ[k2].func_75829_a(targetPoint) < maxDistance)) continue;
            pathOptions[openedNodeCount++] = pathsNZ[k2];
        }
        PathPoint[] pathsNY = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, stepHeight, height, EnumFacing.DOWN, true);
        for (int k3 = 0; k3 < pathsNY.length; ++k3) {
            if (pathsNY[k3] == null || pathsNY[k3].field_75842_i || !(pathsNY[k3].func_75829_a(targetPoint) < maxDistance)) continue;
            pathOptions[openedNodeCount++] = pathsNY[k3];
        }
        boolean avoidPathNZ = pathsNZ.length == 0 || pathsNZ[0] != null && (pathsNZ[0].field_186287_m == PathNodeType.OPEN || pathsNZ[0].field_186286_l != 0.0f);
        boolean avoidPathPZ = pathsPZ.length == 0 || pathsPZ[0] != null && (pathsPZ[0].field_186287_m == PathNodeType.OPEN || pathsPZ[0].field_186286_l != 0.0f);
        boolean avoidPathPX = pathsPX.length == 0 || pathsPX[0] != null && (pathsPX[0].field_186287_m == PathNodeType.OPEN || pathsPX[0].field_186286_l != 0.0f);
        boolean bl = avoidPathNX = pathsNX.length == 0 || pathsNX[0] != null && (pathsNX[0].field_186287_m == PathNodeType.OPEN || pathsNX[0].field_186286_l != 0.0f);
        if (avoidPathNZ && avoidPathNX) {
            PathPoint[] pathsNXNZ = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, height, EnumFacing.NORTH, true);
            for (k = 0; k < pathsNXNZ.length; ++k) {
                if (pathsNXNZ[k] == null || pathsNXNZ[k].field_75842_i || !(pathsNXNZ[k].func_75829_a(targetPoint) < maxDistance)) continue;
                pathOptions[openedNodeCount++] = pathsNXNZ[k];
            }
        }
        if (avoidPathNZ && avoidPathPX) {
            PathPoint[] pathsPXNZ = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, height, EnumFacing.NORTH, true);
            for (k = 0; k < pathsPXNZ.length; ++k) {
                if (pathsPXNZ[k] == null || pathsPXNZ[k].field_75842_i || !(pathsPXNZ[k].func_75829_a(targetPoint) < maxDistance)) continue;
                pathOptions[openedNodeCount++] = pathsPXNZ[k];
            }
        }
        if (avoidPathPZ && avoidPathNX) {
            PathPoint[] pathsNXPZ = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, height, EnumFacing.SOUTH, true);
            for (k = 0; k < pathsNXPZ.length; ++k) {
                if (pathsNXPZ[k] == null || pathsNXPZ[k].field_75842_i || !(pathsNXPZ[k].func_75829_a(targetPoint) < maxDistance)) continue;
                pathOptions[openedNodeCount++] = pathsNXPZ[k];
            }
        }
        if (avoidPathPZ && avoidPathPX) {
            PathPoint[] pathsPXPZ = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, height, EnumFacing.SOUTH, true);
            for (k = 0; k < pathsPXPZ.length; ++k) {
                if (pathsPXPZ[k] == null || pathsPXPZ[k].field_75842_i || !(pathsPXPZ[k].func_75829_a(targetPoint) < maxDistance)) continue;
                pathOptions[openedNodeCount++] = pathsPXPZ[k];
            }
        }
        return openedNodeCount;
    }

    @Nullable
    private PathPoint[] getSafePoints(int x, int y, int z, int stepHeight, double height, EnumFacing facing, boolean allowBlocked) {
        PathPoint directPathPoint = null;
        BlockPos pos = new BlockPos(x, y, z);
        BlockPos posDown = pos.func_177977_b();
        double blockHeight = (double)y - (1.0 - this.field_176169_a.func_180495_p((BlockPos)posDown).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)posDown).field_72337_e);
        if (blockHeight - height > 1.125) {
            return new PathPoint[0];
        }
        PathNodeType nodeType = this.getPathNodeType(this.field_186326_b, x, y, z);
        float malus = ((IPathObstructionAwareEntity)this.callbackEntity).getPathingMalus((EntityLiving)this.callbackEntity, nodeType, pos);
        double halfWidth = (double)this.field_186326_b.field_70130_N / 2.0;
        PathPoint[] result = new PathPoint[1];
        if (malus >= 0.0f && (allowBlocked || nodeType != PathNodeType.BLOCKED)) {
            directPathPoint = this.func_176159_a(x, y, z);
            directPathPoint.field_186287_m = nodeType;
            directPathPoint.field_186286_l = Math.max(directPathPoint.field_186286_l, malus);
            if (directPathPoint.field_186287_m == PathNodeType.BLOCKED) {
                result = new PathPoint[2];
                result[1] = directPathPoint;
                directPathPoint = null;
            }
        }
        if (nodeType == PathNodeType.WALKABLE) {
            result[0] = directPathPoint;
            return result;
        }
        if (directPathPoint == null && stepHeight > 0 && nodeType != PathNodeType.FENCE && nodeType != PathNodeType.TRAPDOOR) {
            PathPoint[] pointsAbove = this.getSafePoints(x, y + 1, z, stepHeight - 1, height, facing, false);
            PathPoint pathPoint = directPathPoint = pointsAbove.length > 0 ? pointsAbove[0] : null;
            if (directPathPoint != null && (directPathPoint.field_186287_m == PathNodeType.OPEN || directPathPoint.field_186287_m == PathNodeType.WALKABLE) && this.field_186326_b.field_70130_N < 1.0f) {
                double offsetX = (double)(x - facing.func_82601_c()) + 0.5;
                double offsetZ = (double)(z - facing.func_82599_e()) + 0.5;
                AxisAlignedBB checkAabb = new AxisAlignedBB(offsetX - halfWidth, (double)y + 0.001, offsetZ - halfWidth, offsetX + halfWidth, (double)((float)y + this.field_186326_b.field_70131_O), offsetZ + halfWidth);
                AxisAlignedBB blockAabb = this.field_176169_a.func_180495_p(pos).func_185900_c(this.field_176169_a, pos);
                AxisAlignedBB enclosingAabb = checkAabb.func_72321_a(0.0, blockAabb.field_72337_e - 0.002, 0.0);
                if (this.field_186326_b.field_70170_p.func_184143_b(enclosingAabb)) {
                    directPathPoint = null;
                }
            }
        }
        if (nodeType == PathNodeType.OPEN) {
            float bridingMalus;
            PathNodeType nodeTypeBelow;
            AxisAlignedBB checkAabb = new AxisAlignedBB((double)x - halfWidth + 0.5, (double)y + 0.001, (double)z - halfWidth + 0.5, (double)x + halfWidth + 0.5, (double)((float)y + this.field_186326_b.field_70131_O), (double)z + halfWidth + 0.5);
            if (this.field_186326_b.field_70170_p.func_184143_b(checkAabb)) {
                result[0] = null;
                return result;
            }
            if (this.field_186326_b.field_70130_N >= 1.0f && (nodeTypeBelow = this.getPathNodeType(this.field_186326_b, x, y - 1, z)) == PathNodeType.BLOCKED) {
                directPathPoint = this.func_176159_a(x, y, z);
                directPathPoint.field_186287_m = PathNodeType.WALKABLE;
                directPathPoint.field_186286_l = Math.max(directPathPoint.field_186286_l, malus);
                result[0] = directPathPoint;
                return result;
            }
            int fallDistance = 0;
            boolean cancelFall = false;
            PathPoint fallPathPoint = null;
            int preFallY = y;
            while (y > 0 && nodeType == PathNodeType.OPEN) {
                --y;
                if (fallDistance++ >= this.field_186326_b.func_82143_as()) {
                    result[0] = null;
                    return result;
                }
                nodeType = this.getPathNodeType(this.field_186326_b, x, y, z);
                malus = this.field_186326_b.func_184643_a(nodeType);
                if (nodeType != PathNodeType.OPEN && malus >= 0.0f) {
                    fallPathPoint = directPathPoint = this.func_176159_a(x, y, z);
                    directPathPoint.field_186287_m = nodeType;
                    directPathPoint.field_186286_l = Math.max(directPathPoint.field_186286_l, malus);
                    break;
                }
                if (!(malus < 0.0f)) continue;
                cancelFall = true;
            }
            if (result.length == 1 && (bridingMalus = ((IPathObstructionAwareEntity)this.callbackEntity).getBridgePathingMalus((EntityLiving)this.callbackEntity, new BlockPos(x, preFallY, z), fallPathPoint)) >= 0.0f) {
                result = new PathPoint[2];
                result[0] = directPathPoint;
                PathPoint bridgePathPoint = this.func_176159_a(x, preFallY, z);
                bridgePathPoint.field_186287_m = PathNodeType.WALKABLE;
                bridgePathPoint.field_186286_l = Math.max(bridgePathPoint.field_186286_l, bridingMalus);
                result[1] = bridgePathPoint;
            }
            if (cancelFall) {
                result[0] = null;
                return result;
            }
        }
        result[0] = directPathPoint;
        return result;
    }

    private PathNodeType getPathNodeType(EntityLiving entitylivingIn, int x, int y, int z) {
        return this.func_186319_a(this.field_176169_a, x, y, z, entitylivingIn, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c());
    }
}

